/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.provisioning.cli;

import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.modeldriven.fuml.Fuml;
import org.modeldriven.fuml.io.ResourceArtifact;
import org.plasma.config.NamespaceProvisioning;
import org.plasma.config.PlasmaConfig;
import org.plasma.metamodel.Model;
import org.plasma.provisioning.ProvisioningException;
import org.plasma.provisioning.cli.RDBDialect;
import org.plasma.provisioning.cli.UMLTool;
import org.plasma.provisioning.rdb.MySql55Converter;
import org.plasma.provisioning.rdb.MySqlVersion;
import org.plasma.provisioning.rdb.MySqlVersionFinder;
import org.plasma.provisioning.rdb.Oracle11GConverter;
import org.plasma.provisioning.rdb.OracleVersion;
import org.plasma.provisioning.rdb.OracleVersionFinder;
import org.plasma.provisioning.rdb.RDBConstants;
import org.plasma.provisioning.rdb.mysql.any.GlobalVariable;
import org.plasma.provisioning.rdb.oracle.any.sys.Version;
import org.plasma.sdo.repository.fuml.FumlRepository;

public class RDBReader
implements RDBConstants {
    private static Log log = LogFactory.getLog(RDBReader.class);

    public Model read(RDBDialect dialect, String[] schemaNames, String[] namespaces) {
        FumlRepository.getInstance();
        Model model = null;
        switch (dialect) {
            case oracle: {
                RDBReader.loadDynamicArtifact("Plasma_RDB_Oracle.mdxml");
                RDBReader.loadDynamicNamespace("http://org.plasma/sdo/oracle/any/sys", Version.class.getPackage(), "Plasma_RDB_Oracle.mdxml");
                OracleVersionFinder versionFinder = new OracleVersionFinder();
                OracleVersion version = versionFinder.findVersion();
                log.info((Object)("detected version '" + (Object)((Object)version) + "'"));
                Oracle11GConverter converter = null;
                switch (version) {
                    case _9i: 
                    case _10g: 
                    case _11g: {
                        RDBReader.loadDynamicNamespace("http://org.plasma/sdo/oracle/11g/sys", org.plasma.provisioning.rdb.oracle.g11.sys.Version.class.getPackage(), "Plasma_RDB_Oracle.mdxml");
                        converter = new Oracle11GConverter(schemaNames, namespaces);
                        break;
                    }
                    default: {
                        log.warn((Object)"unknown Oracle version - using 11g metamodel");
                        RDBReader.loadDynamicNamespace("http://org.plasma/sdo/oracle/11g/sys", org.plasma.provisioning.rdb.oracle.g11.sys.Version.class.getPackage(), "Plasma_RDB_Oracle.mdxml");
                        converter = new Oracle11GConverter(schemaNames, namespaces);
                    }
                }
                model = converter.buildModel();
                break;
            }
            case mysql: {
                RDBReader.loadDynamicArtifact("Plasma_RDB_MySql.mdxml");
                RDBReader.loadDynamicNamespace("http://org.plasma/sdo/mysql/any", GlobalVariable.class.getPackage(), "Plasma_RDB_MySql.mdxml");
                MySqlVersionFinder mysqlVersionFinder = new MySqlVersionFinder();
                MySqlVersion mysqlVersion = mysqlVersionFinder.findVersion();
                log.info((Object)("detected version '" + (Object)((Object)mysqlVersion) + "'"));
                MySql55Converter converter = null;
                switch (mysqlVersion) {
                    case _5_5: {
                        RDBReader.loadDynamicNamespace("http://org.plasma/sdo/mysql/5_5", org.plasma.provisioning.rdb.mysql.v5_5.GlobalVariable.class.getPackage(), "Plasma_RDB_MySql.mdxml");
                        converter = new MySql55Converter(schemaNames, namespaces);
                        break;
                    }
                    default: {
                        log.warn((Object)"unknown MySql version - using 5.5 metamodel");
                        RDBReader.loadDynamicNamespace("http://org.plasma/sdo/mysql/5_5", org.plasma.provisioning.rdb.mysql.v5_5.GlobalVariable.class.getPackage(), "Plasma_RDB_MySql.mdxml");
                        converter = new MySql55Converter(schemaNames, namespaces);
                    }
                }
                model = converter.buildModel();
                break;
            }
            default: {
                throw new ProvisioningException("unknown dialect, '" + dialect.name() + "'");
            }
        }
        return model;
    }

    private static void loadDynamicNamespace(String namespace, Package pkg, String artifactResourceName) {
        NamespaceProvisioning provisioning = new NamespaceProvisioning();
        provisioning.setPackageName(pkg.getName());
        PlasmaConfig.getInstance().addDynamicSDONamespace(namespace, artifactResourceName, provisioning);
    }

    private static void loadDynamicArtifact(String artifactResourceName) {
        InputStream stream = UMLTool.class.getClassLoader().getResourceAsStream(artifactResourceName);
        if (log.isDebugEnabled()) {
            log.info((Object)"loading UML/XMI model");
        }
        Fuml.load((ResourceArtifact)new ResourceArtifact(artifactResourceName, artifactResourceName, stream));
    }
}

