/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.query.model;

import commonj.sdo.Type;
import commonj.sdo.impl.HelperProvider;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.plasma.query.model.Entity;
import org.plasma.query.visitor.QueryVisitor;
import org.plasma.query.visitor.Traversal;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="From", propOrder={"entities"})
@XmlRootElement(name="From")
public class From
implements org.plasma.query.From {
    @XmlElement(name="Entity", required=true)
    protected List<Entity> entities;
    @XmlAttribute(name="randomSample")
    protected Float randomSample;

    public From() {
    }

    public From(Entity entity) {
        this();
        this.getEntities().add(entity);
    }

    public From(String name, String namespaceURI) {
        this();
        this.getEntities().add(new Entity(name, namespaceURI));
    }

    public From(Class c) {
        this();
        Type type = HelperProvider.getTypeHelper().getType(c);
        this.getEntities().add(new Entity(type.getName(), type.getURI()));
    }

    public List<Entity> getEntities() {
        if (this.entities == null) {
            this.entities = new ArrayList<Entity>();
        }
        return this.entities;
    }

    public Entity getEntity() {
        this.validateSingleEntity();
        return this.getEntities().get(0);
    }

    public void setEntity(Entity entity) {
        this.getEntities().add(entity);
        this.validateSingleEntity();
    }

    @Override
    public String getName() {
        this.validateSingleEntity();
        return this.getEntities().get(0).getName();
    }

    @Override
    public String getUri() {
        this.validateSingleEntity();
        return this.getEntities().get(0).getNamespaceURI();
    }

    private void validateSingleEntity() {
        int size = this.getEntities().size();
        if (size > 0) {
            if (size > 1) {
                throw new IllegalStateException("clause containes multiple entities");
            }
        } else {
            throw new IllegalStateException("clause containes no entities");
        }
    }

    @Override
    public Float getRandomSample() {
        return this.randomSample;
    }

    public void setRandomSample(Float value) {
        this.randomSample = value;
    }

    public void accept(QueryVisitor visitor) {
        visitor.start(this);
        if (visitor.getContext().getTraversal().ordinal() == Traversal.CONTINUE.ordinal()) {
            for (Entity entity : this.getEntities()) {
                entity.accept(visitor);
            }
        }
        visitor.end(this);
    }
}

