/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.query.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.plasma.query.DataProperty;
import org.plasma.query.IntegralDataProperty;
import org.plasma.query.Query;
import org.plasma.query.RealDataProperty;
import org.plasma.query.StringDataProperty;
import org.plasma.query.TemporalDataProperty;
import org.plasma.query.model.AbstractProperty;
import org.plasma.query.model.Entity;
import org.plasma.query.model.Expression;
import org.plasma.query.model.Function;
import org.plasma.query.model.FunctionArg;
import org.plasma.query.model.FunctionValues;
import org.plasma.query.model.Literal;
import org.plasma.query.model.NullLiteral;
import org.plasma.query.model.Path;
import org.plasma.query.model.PathNode;
import org.plasma.query.model.Projection;
import org.plasma.query.model.SortDirectionValues;
import org.plasma.query.model.WildcardProperty;
import org.plasma.query.visitor.QueryVisitor;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Property", propOrder={"query", "as", "functions"})
@XmlRootElement(name="Property")
public class Property
extends AbstractProperty
implements StringDataProperty,
IntegralDataProperty,
RealDataProperty,
TemporalDataProperty {
    @XmlElement(name="Query", namespace="")
    protected org.plasma.query.model.Query query;
    @XmlElement(name="As", namespace="")
    protected Projection as;
    @XmlElement(name="Function", namespace="")
    protected List<Function> functions;
    @XmlAttribute(required=true)
    protected String name;
    @XmlAttribute
    protected Boolean values;
    @XmlAttribute
    protected Boolean distinct;
    @XmlAttribute
    protected SortDirectionValues direction;
    @XmlAttribute(name="alias")
    protected String alias;
    protected transient String physicalName;
    protected transient byte[] physicalNameBytes;

    public Property() {
    }

    public Property(String name) {
        this();
        this.setName(name);
    }

    public Property(String name, Path path) {
        this();
        this.setName(name);
        this.setPath(path);
    }

    public Property(String name, SortDirectionValues direction) {
        this();
        this.setName(name);
        this.setDirection(direction);
    }

    public Property(String name, Path path, SortDirectionValues direction) {
        this();
        this.setName(name);
        this.setPath(path);
        this.setDirection(direction);
    }

    public Property(String name, FunctionValues function) {
        this();
        this.setName(name);
        Function func = new Function(function);
        this.getFunctions().add(func);
    }

    public Property(String name, org.plasma.query.model.Query query) {
        this();
        this.setName(name);
        this.setQuery(query);
    }

    public Property(String name, Path path, org.plasma.query.model.Query query) {
        this();
        this.setName(name);
        this.setPath(path);
        this.setQuery(query);
    }

    public static Property forName(String name) {
        return new Property(name);
    }

    public static Property forName(String name, Path path) {
        return new Property(name, path);
    }

    public static WildcardProperty wildcard() {
        return new WildcardProperty();
    }

    public static WildcardProperty wildcard(Path path) {
        return new WildcardProperty(path);
    }

    @Override
    public Expression eq(Object value) {
        return Expression.eq(this, Literal.valueOf(value));
    }

    @Override
    public Expression ne(Object value) {
        return Expression.ne(this, Literal.valueOf(value));
    }

    @Override
    public Expression gt(Object value) {
        return Expression.gt(this, Literal.valueOf(value));
    }

    @Override
    public Expression ge(Object value) {
        return Expression.ge(this, Literal.valueOf(value));
    }

    @Override
    public Expression lt(Object value) {
        return Expression.lt(this, Literal.valueOf(value));
    }

    @Override
    public Expression le(Object value) {
        return Expression.le(this, Literal.valueOf(value));
    }

    @Override
    public Expression between(Object min, Object max) {
        return Expression.between(this, Literal.valueOf(min), Literal.valueOf(max));
    }

    @Override
    public Expression like(String value) {
        return Expression.like(this, Literal.valueOf(value));
    }

    @Override
    public Expression isNull() {
        return Expression.eq(this, new NullLiteral());
    }

    @Override
    public org.plasma.query.Expression isNotNull() {
        return Expression.ne(this, new NullLiteral());
    }

    @Override
    public org.plasma.query.Expression in(Query subquery) {
        return Expression.in(this, subquery.getModel());
    }

    @Override
    public org.plasma.query.Expression notIn(Query subquery) {
        return Expression.notIn(this, subquery.getModel());
    }

    public org.plasma.query.Expression exists(Query subquery) {
        return Expression.exists(this, subquery.getModel());
    }

    public org.plasma.query.model.Query getQuery() {
        return this.query;
    }

    public void setQuery(org.plasma.query.model.Query value) {
        this.query = value;
    }

    @Override
    public DataProperty min() {
        Function func = new Function(FunctionValues.MIN);
        this.getFunctions().add(func);
        return this;
    }

    @Override
    public DataProperty max() {
        Function func = new Function(FunctionValues.MAX);
        this.getFunctions().add(func);
        return this;
    }

    @Override
    public DataProperty sum() {
        Function func = new Function(FunctionValues.SUM);
        this.getFunctions().add(func);
        return this;
    }

    @Override
    public DataProperty avg() {
        Function func = new Function(FunctionValues.AVG);
        this.getFunctions().add(func);
        return this;
    }

    @Override
    public IntegralDataProperty abs() {
        Function func = new Function(FunctionValues.ABS);
        this.getFunctions().add(func);
        return this;
    }

    @Override
    public RealDataProperty ceiling() {
        Function func = new Function(FunctionValues.CEILING);
        this.getFunctions().add(func);
        return this;
    }

    @Override
    public RealDataProperty floor() {
        Function func = new Function(FunctionValues.FLOOR);
        this.getFunctions().add(func);
        return this;
    }

    @Override
    public RealDataProperty round() {
        Function func = new Function(FunctionValues.ROUND);
        this.getFunctions().add(func);
        return this;
    }

    @Override
    public StringDataProperty substringBefore(String value) {
        Function func = new Function(FunctionValues.SUBSTRING_BEFORE);
        FunctionArg arg1 = new FunctionArg();
        func.getFunctionArgs().add(arg1);
        arg1.setName("arg1");
        arg1.setValue(value);
        this.getFunctions().add(func);
        return this;
    }

    @Override
    public StringDataProperty substringAfter(String value) {
        Function func = new Function(FunctionValues.SUBSTRING_AFTER);
        FunctionArg arg1 = new FunctionArg();
        func.getFunctionArgs().add(arg1);
        arg1.setName("arg1");
        arg1.setValue(value);
        this.getFunctions().add(func);
        return this;
    }

    @Override
    public StringDataProperty normalizeSpace() {
        Function func = new Function(FunctionValues.NORMALIZE_SPACE);
        this.getFunctions().add(func);
        return this;
    }

    @Override
    public StringDataProperty upperCase() {
        Function func = new Function(FunctionValues.UPPER_CASE);
        this.getFunctions().add(func);
        return this;
    }

    @Override
    public StringDataProperty lowerCase() {
        Function func = new Function(FunctionValues.LOWER_CASE);
        this.getFunctions().add(func);
        return this;
    }

    @Override
    public DataProperty asc() {
        this.setDirection(SortDirectionValues.ASC);
        return this;
    }

    @Override
    public DataProperty desc() {
        this.setDirection(SortDirectionValues.DESC);
        return this;
    }

    public Projection getAs() {
        return this.as;
    }

    public void setAs(Projection value) {
        this.as = value;
    }

    public List<Function> getFunctions() {
        if (this.functions == null) {
            this.functions = new ArrayList<Function>();
        }
        return this.functions;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getPhysicalName() {
        return this.physicalName;
    }

    public void setPhysicalName(String value) {
        this.physicalName = value;
    }

    public byte[] getPhysicalNameBytes() {
        return this.physicalNameBytes;
    }

    public void setPhysicalNameBytes(byte[] value) {
        this.physicalNameBytes = value;
    }

    public boolean isValues() {
        if (this.values == null) {
            return false;
        }
        return this.values;
    }

    public void setValues(Boolean value) {
        this.values = value;
    }

    @Override
    public boolean isDistinct() {
        if (this.distinct == null) {
            return false;
        }
        return this.distinct;
    }

    public void setDistinct(Boolean value) {
        this.distinct = value;
    }

    public SortDirectionValues getDirection() {
        if (this.direction == null) {
            return SortDirectionValues.ASC;
        }
        return this.direction;
    }

    public void setDirection(SortDirectionValues value) {
        this.direction = value;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String value) {
        this.alias = value;
    }

    public String asPathString() {
        StringBuilder buf = new StringBuilder();
        if (this.getPath() != null) {
            for (PathNode node : this.getPath().getPathNodes()) {
                buf.append(node.getPathElement().getValue());
                buf.append("/");
            }
        }
        buf.append(this.getName());
        return buf.toString();
    }

    @Override
    public void accept(QueryVisitor visitor) {
        visitor.start(this);
        visitor.end(this);
    }

    @Override
    public String getQualifiedName() {
        if (this.qualifiedName == null) {
            StringBuilder buf = new StringBuilder();
            if (this.alias != null) {
                buf.append("(");
                buf.append(this.alias);
                buf.append("}");
            }
            if (this.path != null) {
                for (PathNode node : this.path.getPathNodes()) {
                    buf.append(node.getPathElement().getValue());
                    buf.append(".");
                }
            }
            buf.append(this.name);
            this.qualifiedName = buf.toString();
        }
        return this.qualifiedName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getQualifiedName() == null ? 0 : this.getQualifiedName().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Entity other = (Entity)obj;
        return !(this.getQualifiedName() == null ? other.getQualifiedName() != null : !this.getQualifiedName().equals(other.getQualifiedName()));
    }

    @Override
    public int compareTo(AbstractProperty o) {
        return this.getQualifiedName().compareTo(o.getQualifiedName());
    }
}

