/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.access.provider.common;

import commonj.sdo.Type;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.config.DataAccessProviderName;
import org.plasma.query.QueryException;
import org.plasma.query.model.AbstractPathElement;
import org.plasma.query.model.AbstractProperty;
import org.plasma.query.model.Path;
import org.plasma.query.model.PathElement;
import org.plasma.query.model.Property;
import org.plasma.query.model.Select;
import org.plasma.query.model.WildcardPathElement;
import org.plasma.query.model.WildcardProperty;
import org.plasma.query.visitor.DefaultQueryVisitor;
import org.plasma.sdo.access.DataAccessException;
import org.plasma.sdo.access.provider.common.TraversalMap;

public class TraversalMapAssembler {
    private static Log log = LogFactory.getLog(TraversalMapAssembler.class);
    private Type rootType;
    private TraversalMap map;

    private TraversalMapAssembler() {
    }

    public TraversalMapAssembler(Select select, Type rootType, DataAccessProviderName providerName) {
        this.rootType = rootType;
        this.map = new TraversalMap(providerName);
        if (select.getProperties().size() == 0) {
            throw new DataAccessException("Select clause has no properties");
        }
        DefaultQueryVisitor visitor = new DefaultQueryVisitor(){

            @Override
            public void start(Property property) {
                TraversalMapAssembler.this.assembleProperty(property);
                super.start(property);
            }

            @Override
            public void start(WildcardProperty wildcardProperty) {
                TraversalMapAssembler.this.assembleProperty(wildcardProperty);
                super.start(wildcardProperty);
            }
        };
        select.accept(visitor);
    }

    public TraversalMap getMap() {
        return this.map;
    }

    private void assembleProperty(AbstractProperty abstractProperty) {
        Path path = null;
        if (abstractProperty instanceof Property) {
            path = ((Property)abstractProperty).getPath();
        } else if (abstractProperty instanceof WildcardProperty) {
            path = ((WildcardProperty)abstractProperty).getPath();
        } else {
            throw new IllegalArgumentException("unknown property class, " + abstractProperty.getClass().getName());
        }
        if (path == null) {
            String[] names = this.findPropertyNames(this.rootType, abstractProperty);
            if (names.length == 1) {
                this.map.add(TraversalMap.DELIM_PATH, names[0]);
                this.map.add(this.rootType.getURI() + "#" + this.rootType.getName(), names[0]);
            } else {
                this.map.add(TraversalMap.DELIM_PATH, names);
                this.map.add(this.rootType.getURI() + "#" + this.rootType.getName(), names);
            }
        } else {
            this.assemblePath(path, this.rootType, TraversalMap.DELIM_PATH, path.getPathNodes().get(0).getPathElement(), 0, abstractProperty);
        }
    }

    private void assemblePath(Path path, Type currType, String currTraversalPath, AbstractPathElement currPathElement, int curPathElementIndex, AbstractProperty abstractProperty) {
        if (currPathElement instanceof PathElement) {
            PathElement pathElement = (PathElement)currPathElement;
            commonj.sdo.Property prop = currType.getProperty(pathElement.getValue());
            if (prop.getType().isDataType()) {
                if (abstractProperty instanceof Property) {
                    throw new QueryException("traversal path for property '" + ((Property)abstractProperty).getName() + "' from root '" + this.rootType.getName() + "' contains a non-reference property '" + prop.getName() + "'");
                }
                throw new QueryException("traversal path for wildcard property ' from root '" + this.rootType.getName() + "' contains a non-reference property '" + prop.getName() + "'");
            }
            String nextTraversalPath = currTraversalPath + prop.getName() + TraversalMap.DELIM_PATH;
            Type nextType = prop.getType();
            if (path.getPathNodes().size() > curPathElementIndex + 1) {
                int nextPathElementIndex = curPathElementIndex + 1;
                AbstractPathElement nextPathElement = path.getPathNodes().get(nextPathElementIndex).getPathElement();
                this.assemblePath(path, nextType, nextTraversalPath, nextPathElement, nextPathElementIndex, abstractProperty);
            } else {
                String[] names = this.findPropertyNames(nextType, abstractProperty);
                if (names.length == 1) {
                    this.map.add(nextTraversalPath, names[0]);
                    this.map.add(nextType.getURI() + "#" + nextType.getName(), names[0]);
                } else {
                    this.map.add(nextTraversalPath, names);
                    this.map.add(nextType.getURI() + "#" + nextType.getName(), names);
                }
            }
        } else if (currPathElement instanceof WildcardPathElement) {
            List properties = currType.getDeclaredProperties();
            for (commonj.sdo.Property prop : properties) {
                if (prop.getType().isDataType()) continue;
                Type nextType = prop.getType();
                String nextTraversalPath = currTraversalPath + prop.getName() + TraversalMap.DELIM_PATH;
                if (path.getPathNodes().size() > curPathElementIndex + 1) {
                    int nextPathElementIndex = curPathElementIndex + 1;
                    AbstractPathElement nextPathElement = path.getPathNodes().get(nextPathElementIndex).getPathElement();
                    this.assemblePath(path, nextType, nextTraversalPath, nextPathElement, nextPathElementIndex, abstractProperty);
                    continue;
                }
                String[] names = this.findPropertyNames(nextType, abstractProperty);
                if (names.length == 1) {
                    this.map.add(nextTraversalPath, names[0]);
                    this.map.add(nextType.getURI() + "#" + nextType.getName(), names[0]);
                    continue;
                }
                this.map.add(nextTraversalPath, names);
                this.map.add(nextType.getURI() + "#" + nextType.getName(), names);
            }
        } else {
            throw new IllegalArgumentException("unknown path element class, " + currPathElement.getClass().getName());
        }
    }

    private String[] findPropertyNames(Type type, AbstractProperty abstractProperty) {
        String[] result = null;
        if (abstractProperty instanceof Property) {
            result = new String[1];
            String name = ((Property)abstractProperty).getName();
            type.getProperty(name);
            result[0] = name;
        } else if (abstractProperty instanceof WildcardProperty) {
            WildcardProperty wildcardProperty = (WildcardProperty)abstractProperty;
            ArrayList<String> list = new ArrayList<String>();
            List props = type.getProperties();
            switch (wildcardProperty.getType()) {
                default: {
                    for (commonj.sdo.Property prop : props) {
                        if (prop.isMany()) continue;
                        list.add(prop.getName());
                    }
                    break;
                }
                case REFERENCE: {
                    for (commonj.sdo.Property prop : props) {
                        if (prop.isMany() || prop.getType().isDataType()) continue;
                        list.add(prop.getName());
                    }
                    break;
                }
                case DATA: {
                    for (commonj.sdo.Property prop : props) {
                        if (prop.isMany() || !prop.getType().isDataType()) continue;
                        list.add(prop.getName());
                    }
                }
            }
            result = new String[list.size()];
            list.toArray(result);
        } else {
            throw new IllegalArgumentException("unknown property class, " + abstractProperty.getClass().getName());
        }
        return result;
    }
}

