/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.helper;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.sdo.PlasmaDataGraph;
import org.plasma.sdo.PlasmaDataGraphVisitor;
import org.plasma.sdo.PlasmaDataObject;
import org.plasma.sdo.core.CoreChangeSummary;
import org.plasma.sdo.core.CoreDataObject;
import org.plasma.sdo.core.CoreNode;
import org.plasma.sdo.helper.PlasmaDataFactory;

public class DataGraphCopyVisitor
implements PlasmaDataGraphVisitor {
    private static Log log = LogFactory.getLog(DataGraphCopyVisitor.class);
    private PlasmaDataObject result;
    private Map<String, PlasmaDataObject> resultMap = new HashMap<String, PlasmaDataObject>();
    private HashSet<Type> referenceTypes;
    private boolean copyUUIDs = false;

    public DataGraphCopyVisitor() {
    }

    public DataGraphCopyVisitor(Type[] referenceTypes) {
        this.referenceTypes = new HashSet();
        for (Type t : referenceTypes) {
            this.referenceTypes.add(t);
        }
    }

    public boolean isCopyUUIDs() {
        return this.copyUUIDs;
    }

    public void setCopyUUIDs(boolean copyUUIDs) {
        this.copyUUIDs = copyUUIDs;
    }

    @Override
    public void visit(DataObject target, DataObject source, String sourceKey, int level) {
        PlasmaDataObject targetObject = (PlasmaDataObject)target;
        if (source == null) {
            PlasmaDataGraph dataGraph = PlasmaDataFactory.INSTANCE.createDataGraph();
            dataGraph.getChangeSummary().beginLogging();
            if (log.isDebugEnabled()) {
                log.debug((Object)("copying root object " + targetObject.getUUIDAsString()));
            }
            Type rootType = target.getType();
            this.result = (PlasmaDataObject)dataGraph.createRootObject(rootType);
            if (this.copyUUIDs) {
                this.result.resetUUID(((PlasmaDataObject)target).getUUID());
            }
            this.copyDataProperties(targetObject, this.result);
            this.resultMap.put(targetObject.getUUIDAsString(), this.result);
            return;
        }
        PlasmaDataObject sourceObject = (PlasmaDataObject)source;
        Property sourceProperty = sourceObject.getType().getProperty(sourceKey);
        PlasmaDataObject sourceResult = this.resultMap.get(sourceObject.getUUIDAsString());
        if (sourceResult == null) {
            throw new IllegalStateException("expected source result object " + sourceObject.getType().getURI() + "#" + sourceObject.getType().getName() + " (" + sourceObject.getUUIDAsString() + ")");
        }
        PlasmaDataObject targetResult = this.resultMap.get(targetObject.getUUIDAsString());
        if (target.getContainer().equals(source)) {
            if (targetResult == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("creating contained object " + targetObject.toString()));
                }
                targetResult = (PlasmaDataObject)sourceResult.createDataObject(sourceProperty);
                if (this.copyUUIDs) {
                    targetResult.resetUUID(sourceResult.getUUID());
                }
                this.copyDataProperties(targetObject, targetResult);
                this.resultMap.put(targetObject.getUUIDAsString(), targetResult);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("reparenting contained object " + targetObject.toString()));
                }
                targetResult.setContainer(sourceResult);
                targetResult.setContainmentProperty(sourceProperty);
            }
        } else if (targetResult != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("linking existing object " + targetObject.toString()));
            }
            sourceResult.set(sourceProperty, targetResult);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("copying/linking orphaned object " + targetObject.toString()));
            }
            targetResult = (PlasmaDataObject)PlasmaDataFactory.INSTANCE.create(targetObject.getType());
            if (this.copyUUIDs) {
                targetResult.resetUUID(sourceResult.getUUID());
            }
            this.copyDataProperties(targetObject, targetResult);
            sourceResult.set(sourceProperty, targetResult);
            this.resultMap.put(targetObject.getUUIDAsString(), targetResult);
        }
        if (this.isReferenceType(targetResult.getType())) {
            CoreChangeSummary changeSummary = (CoreChangeSummary)targetResult.getChangeSummary();
            changeSummary.clear(targetResult);
            if (log.isDebugEnabled()) {
                log.debug((Object)("clearing change summary for reference object " + targetObject.toString()));
            }
        }
    }

    private boolean isReferenceType(Type type) {
        return this.referenceTypes != null && this.referenceTypes.contains(type);
    }

    private void copyDataProperties(PlasmaDataObject source, PlasmaDataObject copy) {
        Object value = null;
        for (Property property : source.getType().getProperties()) {
            value = source.get(property);
            if (value == null || !property.getType().isDataType()) continue;
            if (!property.isReadOnly()) {
                copy.set(property, value);
                continue;
            }
            ((CoreNode)((Object)copy)).getValueObject().put(property.getName(), value);
        }
        Object timestamp = ((CoreDataObject)source).getValueObject().get("snapshotTimestamp");
        if (timestamp != null) {
            ((CoreDataObject)copy).getValueObject().put("snapshotTimestamp", timestamp);
        }
    }

    public DataObject getResult() {
        return this.result;
    }
}

