/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.helper;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Type;
import commonj.sdo.helper.TypeHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.sdo.PlasmaDataObjectConstants;
import org.plasma.sdo.PlasmaDataObjectException;
import org.plasma.sdo.core.CoreType;
import org.plasma.sdo.repository.Classifier;
import org.plasma.sdo.repository.InvalidClassifierNameException;
import org.plasma.sdo.repository.PlasmaRepository;
import org.plasma.sdo.repository.Stereotype;

public class PlasmaTypeHelper
implements TypeHelper {
    private static Log log = LogFactory.getLog(PlasmaTypeHelper.class);
    public static volatile PlasmaTypeHelper INSTANCE = PlasmaTypeHelper.initializeInstance();
    private Map<String, Type> namespaceQualifiedNameToTypeMap = new HashMap<String, Type>();
    private Map<String, List<Type>> namespaceToTypesMap = new HashMap<String, List<Type>>();
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();

    private PlasmaTypeHelper() {
    }

    private static synchronized PlasmaTypeHelper initializeInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PlasmaTypeHelper();
        }
        return INSTANCE;
    }

    public Type define(DataObject type) {
        throw new RuntimeException("not yet supported");
    }

    public List define(List types) {
        throw new RuntimeException("not yet supported");
    }

    public Property defineOpenContentProperty(String uri, DataObject property) {
        throw new RuntimeException("not yet supported");
    }

    public Property getOpenContentProperty(String uri, String propertyName) {
        throw new RuntimeException("not yet supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type getType(String uri, String typeName) {
        Type result;
        block9: {
            String qualifiedName = uri + "#" + typeName;
            result = this.namespaceQualifiedNameToTypeMap.get(qualifiedName);
            if (result == null) {
                this.rwl.writeLock().lock();
                try {
                    List<Type> namespaceTypes;
                    result = this.namespaceQualifiedNameToTypeMap.get(qualifiedName);
                    if (result != null) break block9;
                    try {
                        result = new CoreType(uri, typeName);
                    }
                    catch (InvalidClassifierNameException e) {
                        log.warn((Object)e.getMessage(), (Throwable)((Object)e));
                        Type type = null;
                        this.rwl.writeLock().unlock();
                        return type;
                    }
                    this.namespaceQualifiedNameToTypeMap.put(qualifiedName, result);
                    if (!result.getName().equals(typeName)) {
                        qualifiedName = uri + "#" + result.getName();
                        this.namespaceQualifiedNameToTypeMap.put(qualifiedName, result);
                    }
                    if ((namespaceTypes = this.namespaceToTypesMap.get(uri)) == null) {
                        namespaceTypes = new ArrayList<Type>();
                    }
                    namespaceTypes.add(result);
                }
                finally {
                    this.rwl.writeLock().unlock();
                }
            }
        }
        return result;
    }

    public void releaseType(Type type) {
        this.releaseType(type.getURI(), type.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseType(String uri, String typeName) {
        String qualifiedName = uri + "#" + typeName;
        if (log.isDebugEnabled()) {
            log.debug((Object)("releasing type: " + qualifiedName));
        }
        this.rwl.writeLock().lock();
        try {
            Type removed = this.namespaceQualifiedNameToTypeMap.remove(qualifiedName);
            if (removed != null) {
                List<Type> namespaceTypes = this.namespaceToTypesMap.get(uri);
                if (namespaceTypes != null) {
                    if (!namespaceTypes.remove(removed)) {
                        log.warn((Object)("could not remove type from namespace mapping, " + qualifiedName));
                    }
                } else {
                    log.warn((Object)("could not remove type from namespace mapping, " + qualifiedName));
                }
            } else {
                log.warn((Object)("could not remove type, " + qualifiedName));
            }
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    public Type getType(Class interfaceClass) {
        String uri = null;
        try {
            Field uriField = interfaceClass.getDeclaredField(PlasmaDataObjectConstants.NAMESPACE_URI_FIELD_NAME);
            uri = (String)uriField.get(null);
        }
        catch (SecurityException e) {
            throw new PlasmaDataObjectException(e);
        }
        catch (NoSuchFieldException e) {
            throw new PlasmaDataObjectException(e);
        }
        catch (IllegalArgumentException e) {
            throw new PlasmaDataObjectException(e);
        }
        catch (IllegalAccessException e) {
            throw new PlasmaDataObjectException(e);
        }
        return this.getType(uri, interfaceClass.getSimpleName());
    }

    public List<Type> getTypes(String uri) {
        ArrayList<Type> result = new ArrayList<Type>();
        List<Classifier> list = PlasmaRepository.getInstance().getClassifiers(uri);
        for (Classifier classifier : list) {
            if (classifier instanceof Stereotype) {
                log.warn((Object)("ignoring stereotype: " + classifier.getName()));
                continue;
            }
            Type type = this.getType(uri, classifier.getName());
            result.add(type);
        }
        return result;
    }
}

