/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.repository.fuml;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.sdo.AssociationPath;
import org.plasma.sdo.repository.Class_;
import org.plasma.sdo.repository.Classifier;
import org.plasma.sdo.repository.Property;
import org.plasma.sdo.repository.RelationCache;
import org.plasma.sdo.repository.RepositoryException;
import org.plasma.sdo.repository.fuml.FumlRepository;

class FumlRelationCache
implements RelationCache {
    private static Log log = LogFactory.getFactory().getInstance(FumlRelationCache.class);
    private Map<String, RelationPathResult> map = new HashMap<String, RelationPathResult>();

    FumlRelationCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRelation(Class_ target, Class_ source, AssociationPath relation) {
        switch (relation) {
            case singular: {
                String key = this.createHashKey(target, source);
                RelationPathResult result = this.map.get(key);
                if (result == null) {
                    boolean isRelated = this.isLateralSingularRelation(target, source, null, new HashMap<String, Integer>());
                    result = new RelationPathResult(AssociationPath.singular, isRelated);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("cacheing (" + isRelated + ") lateral-singular relation: " + target.getName() + "/" + source.getName() + " (" + key + ")"));
                    }
                    Map<String, RelationPathResult> map = this.map;
                    synchronized (map) {
                        this.map.put(key, result);
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("cache hit (" + result.isRelated() + ") lateral-singular relation: " + target.getName() + "/" + source.getName() + " (" + key + ")"));
                }
                return result.isRelated();
            }
        }
        return false;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    private String createHashKey(Classifier targetType, Classifier sourceType) {
        return targetType.getId() + "/" + sourceType.getId();
    }

    private String createHashKey(Property target, Property source) {
        return target.getId() + "/" + source.getId();
    }

    private boolean isLateralSingularRelation(Class_ targetType, Class_ sourceType, Property traversalSourceProperty, Map<String, Integer> visited) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("comparing targetType/sourceType " + targetType.toString() + " / " + sourceType.toString()));
        }
        List<Property> targetProperties = targetType.getAllProperties();
        if (log.isDebugEnabled()) {
            log.debug((Object)("checking targetType  " + targetType.toString() + " with " + targetProperties.size() + " properties"));
        }
        for (Property targetProperty : targetProperties) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("checking " + targetType.toString() + "." + this.getDebugName(targetProperty)));
            }
            if (targetProperty.getType().isDataType()) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("not a reference property " + targetType.toString() + "." + this.getDebugName(targetProperty)));
                continue;
            }
            Property targetPropertyOpposite = targetProperty.getOpposite();
            if (targetPropertyOpposite == null) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("no opposite " + targetType.toString() + "." + this.getDebugName(targetProperty)));
                continue;
            }
            if (targetPropertyOpposite.isMany()) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("opposite not singular " + targetType.toString() + "." + this.getDebugName(targetProperty)));
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("processing " + targetType.toString() + "." + this.getDebugName(targetProperty)));
            }
            if (traversalSourceProperty != null) {
                String linkKey = this.createHashKey(targetProperty, traversalSourceProperty);
                Integer count = null;
                count = visited.get(linkKey);
                if (count == null) {
                    visited.put(linkKey, 1);
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("exiting - visited  " + targetType.toString() + "." + this.getDebugName(targetProperty)));
                    }
                    return false;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("comparing " + targetType.toString() + "." + this.getDebugName(targetProperty) + " (" + targetProperty.getType().getId() + ")" + "->" + sourceType.toString() + " (" + sourceType.getId() + ")"));
            }
            if (targetProperty.getType().getId().equals(sourceType.getId())) {
                if (targetType.getId().equals(sourceType.getId())) {
                    log.warn((Object)("potential circular reference: " + targetType.toString() + "." + this.getDebugName(targetProperty) + "->" + sourceType.toString()));
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("found child link property " + targetType.toString() + "." + this.getDebugName(targetProperty) + "->" + sourceType.toString()));
                }
                return true;
            }
            if (targetProperty.getType().getId().equals(targetType.getId())) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("traversing " + targetType.toString() + "." + this.getDebugName(targetProperty)));
            }
            Classifier tempClassifier = FumlRepository.getFumlRepositoryInstance().getClassifierById(targetProperty.getType().getId());
            String urn = tempClassifier.getArtifactNamespaceURI();
            String qualifiedName = urn + "#" + tempClassifier.getName();
            Classifier targetClassifier = FumlRepository.getFumlRepositoryInstance().getClassifier(qualifiedName);
            Class_ nextClassifier = null;
            if (!Class_.class.isAssignableFrom(targetClassifier.getClass())) {
                throw new RepositoryException("expected classifier assignable to class");
            }
            nextClassifier = (Class_)targetClassifier;
            if (!this.isLateralSingularRelation(nextClassifier, sourceType, targetProperty, visited)) continue;
            return true;
        }
        return false;
    }

    private String getDebugName(Property prop) {
        if (prop.getName() != null && prop.getName().trim().length() > 0) {
            return prop.getName();
        }
        return prop.getType().getName();
    }

    class RelationPathResult {
        private AssociationPath relationPath;
        private boolean related;

        private RelationPathResult() {
        }

        public RelationPathResult(AssociationPath relationPath, boolean related) {
            this.relationPath = relationPath;
            this.related = related;
        }

        public AssociationPath getRelationPath() {
            return this.relationPath;
        }

        public boolean isRelated() {
            return this.related;
        }
    }
}

