/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.text.ddl;

import org.plasma.sdo.DataType;
import org.plasma.text.ddl.Behavior;
import org.plasma.text.ddl.Check;
import org.plasma.text.ddl.Column;
import org.plasma.text.ddl.DDLException;
import org.plasma.text.ddl.DDLFactory;
import org.plasma.text.ddl.DefaultDDLFactory;
import org.plasma.text.ddl.Fk;
import org.plasma.text.ddl.Index;
import org.plasma.text.ddl.On;
import org.plasma.text.ddl.Schema;
import org.plasma.text.ddl.Table;
import org.plasma.text.ddl.Unique;

public class CassandraFactory
extends DefaultDDLFactory
implements DDLFactory {
    @Override
    public String getType(Table table, Column column) {
        DataType sdoType = DataType.valueOf((String)column.getType());
        switch (sdoType) {
            case String: 
            case URI: {
                return "TEXT";
            }
            case Strings: {
                return "SET";
            }
            case Boolean: {
                return "BOOLEAN";
            }
            case Byte: {
                return "INT";
            }
            case Character: {
                return "TEXT";
            }
            case Decimal: {
                return "DECIMAL";
            }
            case Double: {
                return "DOUBLE";
            }
            case Float: {
                return "FLOAT";
            }
            case Short: {
                return "INT";
            }
            case Integer: {
                return "VARINT";
            }
            case Int: {
                return "INT";
            }
            case Long: {
                return "BIGINT";
            }
            case Bytes: {
                return "BLOB";
            }
            case Date: 
            case DateTime: 
            case Time: {
                return "TIMESTAMP";
            }
            case Day: 
            case Duration: 
            case Month: 
            case MonthDay: 
            case Year: 
            case YearMonth: 
            case YearMonthDay: {
                return "TEXT";
            }
        }
        throw new DDLException("unsupported SDO type, " + sdoType.toString());
    }

    @Override
    public String createTable(Schema schema, Table table) {
        StringBuilder buf = new StringBuilder();
        buf.append("CREATE TABLE ");
        buf.append(schema.getName());
        buf.append(".");
        buf.append(table.getName());
        buf.append(" ( ");
        int i = 0;
        for (Column column : table.getColumns()) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(column.getName());
            buf.append(" ");
            buf.append(this.getType(table, column));
            ++i;
        }
        if (table.getPk() != null) {
            buf.append(", PRIMARY KEY (");
            i = 0;
            for (On on : table.getPk().getOns()) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(on.getColumn());
                ++i;
            }
            buf.append(" )");
        }
        buf.append(" );\n");
        return buf.toString();
    }

    @Override
    public String createView(Schema schema, Table table, Behavior create) {
        StringBuilder buf = new StringBuilder();
        buf.append("/* view create statement omitted for behaviored entity ");
        buf.append(schema.getName());
        buf.append(".");
        buf.append(table.getName());
        buf.append(" */");
        return buf.toString();
    }

    @Override
    public String dropView(Schema schema, Table table, Behavior drop) {
        StringBuilder buf = new StringBuilder();
        buf.append("/* view drop statement omitted for behaviored entity ");
        buf.append(schema.getName());
        buf.append(".");
        buf.append(table.getName());
        buf.append(" */");
        return buf.toString();
    }

    @Override
    public String createForeignKeyConstraint(Schema schema, Table table, Fk fk, Table toTable) {
        return "";
    }

    @Override
    public String dropForeignKeyConstraint(Schema schema, Table table, Fk fk, Table toTable) {
        return "";
    }

    @Override
    public String enableForeignKeyConstraint(Schema schema, Table table, Fk fk, Table toTable, boolean enable) {
        return "";
    }

    @Override
    public String createUniqueConstraint(Schema schema, Table table, Unique unique) {
        return "";
    }

    @Override
    public String dropUniqueConstraint(Schema schema, Table table, Unique unique) {
        return "";
    }

    @Override
    public String createSequence(Schema schema, Table table) {
        return "";
    }

    @Override
    public String dropSequence(Schema schema, Table table) {
        return "";
    }

    @Override
    public String createCheckConstraint(Schema schema, Table table, Check check) {
        return "";
    }

    @Override
    public String dropCheckConstraint(Schema schema, Table table, Check check) {
        return "";
    }

    @Override
    public String enableUniqueConstraint(Schema schema, Table table, Unique unique, boolean enable) {
        return "";
    }

    @Override
    public String createIndex(Schema schema, Table table, Index index) {
        Column indexColumn = this.getColumn(table, index.getColumn());
        if (!this.isPk(table, indexColumn)) {
            StringBuilder buf = new StringBuilder();
            buf.append("CREATE INDEX ");
            buf.append(index.getName());
            buf.append(" ON ");
            buf.append(schema.getName());
            buf.append(".");
            buf.append(table.getName());
            buf.append(" ( ");
            buf.append(index.getColumn());
            buf.append(" );\n");
            return buf.toString();
        }
        return "";
    }

    @Override
    public String dropIndex(Schema schema, Table table, Index index) {
        Column indexColumn = this.getColumn(table, index.getColumn());
        if (!this.isPk(table, indexColumn)) {
            StringBuilder buf = new StringBuilder();
            buf.append("DROP INDEX ");
            buf.append(index.getName());
            buf.append(";\n");
            return buf.toString();
        }
        return "";
    }
}

