/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.text.lang3gl.java;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.config.Namespace;
import org.plasma.config.PlasmaConfig;
import org.plasma.metamodel.Class;
import org.plasma.metamodel.ClassRef;
import org.plasma.metamodel.Package;
import org.plasma.text.lang3gl.ClassNameResolver;
import org.plasma.text.lang3gl.java.DefaultNameResolver;

public class SDOClassNameResolver
extends DefaultNameResolver
implements ClassNameResolver {
    private static Log log = LogFactory.getLog(SDOClassNameResolver.class);

    @Override
    public String getName(Class clss) {
        String name = PlasmaConfig.getInstance().getSDOImplementationClassName(clss.getUri(), clss.getName());
        return this.replaceReservedCharacters(name);
    }

    @Override
    public String getQualifiedName(Class clss, Package pkg) {
        Namespace sdoNamespace = PlasmaConfig.getInstance().getSDONamespaceByURI(clss.getUri());
        String packageName = sdoNamespace.getProvisioning().getPackageName();
        String name = PlasmaConfig.getInstance().getSDOImplementationClassName(clss.getUri(), clss.getName());
        String qualifiedName = packageName + "." + this.replaceReservedCharacters(name);
        this.checkUnresolvableNameCollision(qualifiedName, clss, pkg);
        return qualifiedName;
    }

    @Override
    public String getQualifiedName(ClassRef clssRef) {
        Namespace sdoNamespace = PlasmaConfig.getInstance().getSDONamespaceByURI(clssRef.getUri());
        String packageName = sdoNamespace.getProvisioning().getPackageName();
        String name = PlasmaConfig.getInstance().getSDOImplementationClassName(clssRef.getUri(), clssRef.getName());
        String qualifiedName = packageName + "." + this.replaceReservedCharacters(name);
        return qualifiedName;
    }
}

