/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.text.lang3gl.java;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.plasma.config.EnumSource;
import org.plasma.config.InterfaceProvisioning;
import org.plasma.config.PlasmaConfig;
import org.plasma.config.PropertyNameStyle;
import org.plasma.metamodel.Class;
import org.plasma.metamodel.Package;
import org.plasma.metamodel.Property;
import org.plasma.text.TextBuilder;
import org.plasma.text.TextProvisioningException;
import org.plasma.text.lang3gl.ClassNameResolver;
import org.plasma.text.lang3gl.Lang3GLContext;
import org.plasma.text.lang3gl.java.DefaultFactory;
import org.plasma.text.lang3gl.java.SDOClassNameResolver;
import org.plasma.text.lang3gl.java.SDOEnumerationNameResolver;
import org.plasma.text.lang3gl.java.SDOInterfaceNameResolver;

public abstract class SDODefaultFactory
extends DefaultFactory {
    protected static String[] SDO_RESERVED_NAMES = new String[]{"type", "dataobject", "sequence", "list"};
    private Map<String, String> reservedGetterNameMap = new HashMap<String, String>();
    protected InterfaceProvisioning globalInterfaceProvisioning;
    protected ClassNameResolver interfaceResolver = new SDOInterfaceNameResolver();
    protected ClassNameResolver classResolver = new SDOClassNameResolver();
    protected ClassNameResolver enumResolver = new SDOEnumerationNameResolver();

    public SDODefaultFactory(Lang3GLContext context) {
        super(context);
        for (String name : SDO_RESERVED_NAMES) {
            this.reservedGetterNameMap.put(name, name);
        }
        this.globalInterfaceProvisioning = PlasmaConfig.getInstance().getSDO().getGlobalProvisioning().getInterface();
        if (this.globalInterfaceProvisioning == null) {
            this.globalInterfaceProvisioning = new InterfaceProvisioning();
            this.globalInterfaceProvisioning.setPropertyNameStyle(PropertyNameStyle.ENUMS);
            this.globalInterfaceProvisioning.setEnumSource(EnumSource.DERIVED);
        }
    }

    protected String createPackageDeclaration(Package pkg) {
        String packageName = PlasmaConfig.getInstance().getSDOInterfacePackageName(pkg.getUri());
        TextBuilder buf = new TextBuilder(LINE_SEP, this.context.getIndentationToken());
        buf.append("package " + packageName);
        buf.append(";");
        return buf.toString();
    }

    public String createBaseDirectoryName(Package pkg) {
        String packageName = PlasmaConfig.getInstance().getSDOInterfacePackageName(pkg.getUri());
        String packageDir = packageName.replace(".", "/");
        TextBuilder buf = new TextBuilder(LINE_SEP, this.context.getIndentationToken());
        buf.append(packageDir);
        return buf.toString();
    }

    public String createDirectoryName(Package pkg) {
        String packageName = PlasmaConfig.getInstance().getSDOInterfacePackageName(pkg.getUri());
        String packageDir = packageName.replace(".", "/");
        TextBuilder buf = new TextBuilder(LINE_SEP, this.context.getIndentationToken());
        buf.append(packageDir);
        return buf.toString();
    }

    protected String toQualifiedPropertyNameReference(Package pkg, Class clss, Property field) {
        TextBuilder buf = new TextBuilder(LINE_SEP, this.context.getIndentationToken());
        InterfaceProvisioning interfaceProvisioning = PlasmaConfig.getInstance().getSDOInterfaceProvisioning(pkg.getUri());
        if (interfaceProvisioning == null) {
            interfaceProvisioning = this.globalInterfaceProvisioning;
        }
        block0 : switch (interfaceProvisioning.getPropertyNameStyle()) {
            case ENUMS: {
                switch (interfaceProvisioning.getEnumSource()) {
                    case DERIVED: {
                        buf.append(this.interfaceResolver.getName(clss));
                        buf.append(".PROPERTY.");
                        buf.append(field.getName());
                        buf.append(".name()");
                        break block0;
                    }
                    case EXTERNAL: {
                        buf.append(this.enumResolver.getQualifiedName(clss, pkg));
                        buf.append(".");
                        buf.append(field.getAlias().getLocalName());
                        buf.append(".name()");
                        break block0;
                    }
                }
                throw new TextProvisioningException("unexpected enum source, " + interfaceProvisioning.getEnumSource());
            }
            case CONSTANTS: {
                buf.append(this.interfaceResolver.getName(clss));
                buf.append(".");
                buf.append(this.toConstantName(field.getName()));
                break;
            }
            default: {
                buf.append("\"");
                buf.append(field.getName());
                buf.append("\"");
            }
        }
        return buf.toString();
    }

    protected String createSDOInterfaceReferenceImportDeclarations(Package pkg, Class clss) {
        TextBuilder buf = new TextBuilder(LINE_SEP, this.context.getIndentationToken());
        TreeMap<String, String> nameMap = new TreeMap<String, String>();
        SDOInterfaceNameResolver resolver = new SDOInterfaceNameResolver();
        this.collectSuperclassNames(pkg, clss, nameMap, resolver);
        for (String name : nameMap.values()) {
            buf.append(LINE_SEP);
            buf.append("import ");
            buf.append(name);
            buf.append(";");
        }
        return buf.toString();
    }

    protected String getImplementationClassName(Class clss, Package pkg) {
        SDOClassNameResolver resolver = new SDOClassNameResolver();
        String name = resolver.getName(clss);
        return name;
    }

    @Override
    protected String toMethodFieldName(String name) {
        String result = this.firstToUpperCase(name);
        if (this.reservedGetterNameMap.get(name.toLowerCase()) != null) {
            result = result + "_";
        }
        return result;
    }
}

