/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.xml.uml;

import java.util.UUID;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.plasma.metamodel.Model;
import org.plasma.profile.ProfileConfig;
import org.plasma.profile.ProfileURN;
import org.plasma.profile.adapter.ProfileArtifactAdapter;
import org.plasma.query.Query;
import org.plasma.xml.schema.Schema;
import org.plasma.xml.uml.DefaultUMLModelAssembler;
import org.plasma.xml.uml.UMLModelAssembler;

public class PapyrusModelAssembler
extends DefaultUMLModelAssembler
implements UMLModelAssembler {
    private ProfileArtifactAdapter profile;

    public PapyrusModelAssembler(Model model, String destNamespaceURI, String destNamespacePrefix) {
        super(model, destNamespaceURI, destNamespacePrefix);
        this.construct();
    }

    @Deprecated
    public PapyrusModelAssembler(Query query, String destNamespaceURI, String destNamespacePrefix) {
        super(query, destNamespaceURI, destNamespacePrefix);
        this.construct();
    }

    @Deprecated
    public PapyrusModelAssembler(Schema schema, String destNamespaceURI, String destNamespacePrefix) {
        super(schema, destNamespaceURI, destNamespacePrefix);
        this.construct();
    }

    private void construct() {
        this.profile = ProfileConfig.getInstance().findArtifactByUrn(ProfileURN.PLASMA_SDO_PROFILE_V_1_1_UML);
        this.umlNs = Namespace.getNamespace((String)"uml", (String)this.profile.getUmlNamespaceUri());
        this.xmiNs = Namespace.getNamespace((String)"xmi", (String)this.profile.getXmiNamespaceUri());
        this.plasmaNs = Namespace.getNamespace((String)"PlasmaSDOProfile", (String)this.profile.getNamespaceUri());
        this.xmiVersion = this.profile.getXmiVersion();
        this.dataTypeHRefPrefix = "pathmap://PLASMA_LIBRARIES/PlasmaSDODataTypes_v1_1.uml#plasma-sdo-profile-datatypes-";
        this.platformNs = Namespace.getNamespace((String)"ecore", (String)this.profile.getEcoreNamespaceUri());
        this.xsiNs = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
        this.xsiSchemaLocation = this.plasmaNs.getURI() + " pathmap://PLASMA_PROFILES/" + this.profile.getUrn().value() + "#" + this.profile.getEcoreId();
    }

    @Override
    protected Element buildProfileApplication() {
        Element profileApplicationElem = new Element("profileApplication");
        profileApplicationElem.setAttribute(new Attribute("type", "uml:ProfileApplication", this.xmiNs));
        profileApplicationElem.setAttribute(new Attribute("id", UUID.randomUUID().toString(), this.xmiNs));
        Element eAnnotationsElem = new Element("eAnnotations");
        profileApplicationElem.addContent((Content)eAnnotationsElem);
        eAnnotationsElem.setAttribute(new Attribute("type", "ecore:EAnnotation", this.xmiNs));
        eAnnotationsElem.setAttribute(new Attribute("id", UUID.randomUUID().toString(), this.xmiNs));
        eAnnotationsElem.setAttribute(new Attribute("source", this.profile.getUmlNamespaceUri()));
        Element referencesElem = new Element("references");
        eAnnotationsElem.addContent((Content)referencesElem);
        referencesElem.setAttribute(new Attribute("type", "ecore:EPackage", this.xmiNs));
        referencesElem.setAttribute(new Attribute("id", UUID.randomUUID().toString(), this.xmiNs));
        referencesElem.setAttribute(new Attribute("href", "pathmap://PLASMA_PROFILES/" + this.profile.getUrn().value() + "#" + this.profile.getEcoreId()));
        Element appliedProfileElem = new Element("appliedProfile");
        profileApplicationElem.addContent((Content)appliedProfileElem);
        appliedProfileElem.setAttribute(new Attribute("type", "uml:Profile", this.xmiNs));
        appliedProfileElem.setAttribute(new Attribute("id", UUID.randomUUID().toString(), this.xmiNs));
        appliedProfileElem.setAttribute(new Attribute("href", "pathmap://PLASMA_PROFILES/" + this.profile.getUrn().value() + "#" + this.profile.getId()));
        return profileApplicationElem;
    }
}

