/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.provisioning.rdb;

import commonj.sdo.DataGraph;
import commonj.sdo.helper.XMLDocument;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.config.PlasmaConfig;
import org.plasma.metamodel.Alias;
import org.plasma.metamodel.Behavior;
import org.plasma.metamodel.BehaviorType;
import org.plasma.metamodel.Body;
import org.plasma.metamodel.Class;
import org.plasma.metamodel.ClassRef;
import org.plasma.metamodel.DataTypeRef;
import org.plasma.metamodel.Documentation;
import org.plasma.metamodel.DocumentationType;
import org.plasma.metamodel.Enumeration;
import org.plasma.metamodel.EnumerationConstraint;
import org.plasma.metamodel.EnumerationLiteral;
import org.plasma.metamodel.EnumerationRef;
import org.plasma.metamodel.Key;
import org.plasma.metamodel.KeyType;
import org.plasma.metamodel.Model;
import org.plasma.metamodel.Package;
import org.plasma.metamodel.Property;
import org.plasma.metamodel.TypeRef;
import org.plasma.metamodel.UniqueConstraint;
import org.plasma.metamodel.ValueConstraint;
import org.plasma.metamodel.VisibilityType;
import org.plasma.provisioning.ProvisioningException;
import org.plasma.provisioning.SchemaConverter;
import org.plasma.provisioning.common.NameUtils;
import org.plasma.provisioning.rdb.ConverterSupport;
import org.plasma.provisioning.rdb.mysql.v5_5.ColumnKeyType;
import org.plasma.provisioning.rdb.mysql.v5_5.ConstraintType;
import org.plasma.provisioning.rdb.mysql.v5_5.SysDataType;
import org.plasma.provisioning.rdb.mysql.v5_5.Table;
import org.plasma.provisioning.rdb.mysql.v5_5.TableColumn;
import org.plasma.provisioning.rdb.mysql.v5_5.TableColumnConstraint;
import org.plasma.provisioning.rdb.mysql.v5_5.TableColumnKeyUsage;
import org.plasma.provisioning.rdb.mysql.v5_5.TableConstraint;
import org.plasma.provisioning.rdb.mysql.v5_5.TableType;
import org.plasma.provisioning.rdb.mysql.v5_5.View;
import org.plasma.provisioning.rdb.mysql.v5_5.query.QTable;
import org.plasma.provisioning.rdb.mysql.v5_5.query.QTableColumn;
import org.plasma.provisioning.rdb.mysql.v5_5.query.QTableColumnConstraint;
import org.plasma.provisioning.rdb.mysql.v5_5.query.QTableColumnKeyUsage;
import org.plasma.provisioning.rdb.mysql.v5_5.query.QTableConstraint;
import org.plasma.provisioning.rdb.mysql.v5_5.query.QView;
import org.plasma.sdo.DataType;
import org.plasma.sdo.helper.PlasmaXMLHelper;
import org.plasma.sdo.xml.DefaultOptions;

public class MySql55Converter
extends ConverterSupport
implements SchemaConverter {
    private static Log log = LogFactory.getLog(MySql55Converter.class);
    protected Map<String, Class> classQualifiedPropertyPhysicalNameMap = new HashMap<String, Class>();
    protected Map<Property, ConstraintInfo[]> constraintMap = new HashMap<Property, ConstraintInfo[]>();

    public MySql55Converter(String[] schemaNames, String[] namespaces) {
        this.schemaNames = schemaNames;
        this.namespaces = namespaces;
    }

    @Override
    public Model buildModel() {
        this.model = new Model();
        this.model.setId(UUID.randomUUID().toString());
        if (this.schemaNames.length == 1) {
            this.model.setUri(this.namespaces[0]);
            Alias alias = new Alias();
            alias.setPhysicalName(this.schemaNames[0]);
            this.model.setAlias(alias);
            this.model.setName(this.schemaNames[0]);
        } else {
            this.model.setName("model");
        }
        int i = 0;
        while (i < this.schemaNames.length) {
            log.info((Object)("loading schema '" + this.schemaNames[i] + "'"));
            Package pkg = this.findPackage(this.schemaNames[i], this.namespaces[i]);
            this.loadTables(pkg, this.schemaNames[i]);
            ++i;
        }
        for (Class clss : this.classQualifiedNameMap.values()) {
            Property[] props = new Property[clss.getProperties().size()];
            clss.getProperties().toArray(props);
            Property[] propertyArray = props;
            int n = props.length;
            int n2 = 0;
            while (n2 < n) {
                Property prop = propertyArray[n2];
                ConstraintInfo[] infos = this.constraintMap.get(prop);
                if (infos != null) {
                    ConstraintInfo[] constraintInfoArray = infos;
                    int n3 = infos.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ConstraintInfo info = constraintInfoArray[n4];
                        String constraintType = info.getConstraint().getConstraintType().replace(' ', '_');
                        ConstraintType consType = ConstraintType.valueOf(constraintType);
                        switch (consType) {
                            case FOREIGN_KEY: {
                                String qualifiedName = String.valueOf(info.getTableColumnConstraint().getReferencedTableName()) + "." + info.getTableColumnConstraint().getReferencedColumnName();
                                Class targetClass = this.classQualifiedPropertyPhysicalNameMap.get(qualifiedName);
                                if (targetClass == null) {
                                    throw new ProvisioningException("no target class found for, " + qualifiedName);
                                }
                                String name = NameUtils.firstToLowerCase(targetClass.getName());
                                int count = this.countPropertiesByLogicalNamePrefix(clss, name);
                                if (count > 0) {
                                    name = String.valueOf(name) + String.valueOf(count);
                                }
                                prop.setName(name);
                                ClassRef typeRef = new ClassRef();
                                typeRef.setName(targetClass.getName());
                                typeRef.setUri(targetClass.getUri());
                                prop.setType((TypeRef)typeRef);
                                Property targetPkProp = (Property)this.propertyQualifiedPriKeyConstrainatNameMap.get(qualifiedName);
                                String oppositeName = NameUtils.firstToLowerCase(clss.getName());
                                count = this.countPropertiesByLogicalNamePrefix(targetClass, oppositeName);
                                if (count > 0) {
                                    oppositeName = String.valueOf(oppositeName) + String.valueOf(count);
                                }
                                prop.setOpposite(oppositeName);
                                Property derived = this.createDerivedPropertyOpposite(clss, prop);
                                targetClass.getProperties().add(derived);
                                break;
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return this.model;
    }

    private int countPropertiesByLogicalNamePrefix(Class clss, String namePrefix) {
        int result = 0;
        for (Property prop : clss.getProperties()) {
            if (!prop.getName().endsWith(namePrefix)) continue;
            ++result;
        }
        return result;
    }

    private Property createDerivedPropertyOpposite(Class clss, Property sourceProperty) {
        Property derived = new Property();
        derived.setId(UUID.randomUUID().toString());
        derived.setName(sourceProperty.getOpposite());
        Documentation documentation = new Documentation();
        documentation.setType(DocumentationType.DEFINITION);
        Body docBody = new Body();
        documentation.setBody(docBody);
        docBody.setValue("private derived opposite for, " + clss.getUri() + "#" + clss.getName() + "." + sourceProperty.getName());
        derived.getDocumentations().add(documentation);
        derived.setVisibility(VisibilityType.PRIVATE);
        derived.setNullable(true);
        derived.setMany(true);
        derived.setDerived(Boolean.valueOf(true));
        derived.setContainment(Boolean.valueOf(false));
        derived.setOpposite(sourceProperty.getName());
        ClassRef targetClassRef = new ClassRef();
        targetClassRef.setName(clss.getName());
        targetClassRef.setUri(clss.getUri());
        derived.setType((TypeRef)targetClassRef);
        return derived;
    }

    private void loadTables(Package pkg, String schema) {
        for (String tableName : this.getTableNames(schema)) {
            log.info((Object)("loading table '" + tableName + "'"));
            Table table = this.getTableGraph(schema, tableName);
            if (log.isDebugEnabled()) {
                try {
                    log.debug((Object)this.serializeGraph(table.getDataGraph()));
                }
                catch (IOException e) {
                    log.error((Object)e.getMessage());
                }
            }
            Class clss = this.buildClass(pkg, table);
            pkg.getClazzs().add(clss);
            String key = String.valueOf(pkg.getUri()) + "#" + clss.getName();
            this.classQualifiedNameMap.put(key, clss);
            TableColumn[] tableColumnArray = table.getTableColumn();
            int n = tableColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn column = tableColumnArray[n2];
                log.debug((Object)("\tloading column '" + column.getColumnName() + "'"));
                ConstraintInfo[] constraints = this.findConstraints(column, table);
                Property prop = this.buildProperty(pkg, clss, column, constraints);
                clss.getProperties().add(prop);
                if (prop.getAlias() != null && prop.getAlias().getPhysicalName() != null) {
                    this.classQualifiedPropertyPhysicalNameMap.put(String.valueOf(clss.getAlias().getPhysicalName()) + "." + prop.getAlias().getPhysicalName(), clss);
                }
                this.constraintMap.put(prop, constraints);
                ++n2;
            }
        }
    }

    private Package findPackage(String schema, String namespace) {
        Model pkg = null;
        if (this.schemaNames.length > 1) {
            pkg = new Package();
            pkg.setName(schema.toLowerCase());
            pkg.setId(UUID.randomUUID().toString());
            pkg.setUri(namespace);
            Alias alias = new Alias();
            alias.setPhysicalName(schema);
            pkg.setAlias(alias);
            this.model.getPackages().add(pkg);
        } else {
            pkg = this.model;
        }
        return pkg;
    }

    private ConstraintInfo[] findConstraints(TableColumn column, Table table) {
        return this.findConstraints(column, table.getTableConstraint(), table.getTableColumnConstraint(), table.getTableColumnKeyUsage());
    }

    private ConstraintInfo[] findConstraints(TableColumn column, TableConstraint[] constraints, TableColumnConstraint[] columnConstraints, TableColumnKeyUsage[] columnKeyUsages) {
        ArrayList<ConstraintInfo> list = new ArrayList<ConstraintInfo>();
        if (columnConstraints != null && constraints != null) {
            TableColumnKeyUsage[] tableColumnKeyUsageArray = columnKeyUsages;
            int n = columnKeyUsages.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumnKeyUsage colConst = tableColumnKeyUsageArray[n2];
                if (colConst.getColumnName().equals(column.getColumnName())) {
                    list.add(new ConstraintInfo(this.getTableConstraint(colConst, constraints), this.getColumnConstraint(colConst, columnKeyUsages)));
                }
                ++n2;
            }
        }
        ConstraintInfo[] result = new ConstraintInfo[list.size()];
        list.toArray(result);
        return result;
    }

    private TableConstraint getTableConstraint(TableColumnKeyUsage constraint, TableConstraint[] constraints) {
        if (constraints != null) {
            TableConstraint[] tableConstraintArray = constraints;
            int n = constraints.length;
            int n2 = 0;
            while (n2 < n) {
                TableConstraint c = tableConstraintArray[n2];
                if (c.getName().equals(constraint.getName())) {
                    return c;
                }
                ++n2;
            }
        }
        throw new IllegalArgumentException("no constraint found for given constraint name '" + constraint.getName() + "'");
    }

    private TableColumnKeyUsage getColumnConstraint(TableColumnKeyUsage constraint, TableColumnKeyUsage[] constraints) {
        if (constraints != null) {
            TableColumnKeyUsage[] tableColumnKeyUsageArray = constraints;
            int n = constraints.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumnKeyUsage c = tableColumnKeyUsageArray[n2];
                if (c.getName().equals(constraint.getName())) {
                    return c;
                }
                ++n2;
            }
        }
        throw new IllegalArgumentException("no constraint found for given constraint name '" + constraint.getName() + "'");
    }

    private Table getTableGraph(String schema, String tableName) {
        QTable table = QTable.newQuery();
        QTableColumn tableColumn = QTableColumn.newQuery();
        QTableConstraint tableConstraint = QTableConstraint.newQuery();
        QTableColumnKeyUsage columnKeyUsage = QTableColumnKeyUsage.newQuery();
        QTableColumnConstraint tableColumnConstraint = QTableColumnConstraint.newQuery();
        QView view = QView.newQuery();
        table.select(table.wildcard()).select(table.tableColumn(tableColumn.owner().eq(schema)).wildcard()).select(table.tableConstraint(tableConstraint.owner().eq(schema)).wildcard()).select(table.tableColumnKeyUsage(columnKeyUsage.owner().eq(schema)).wildcard()).select(table.tableColumnConstraint(tableColumnConstraint.owner().eq(schema)).wildcard()).select(table.view(view.owner().eq(schema)).wildcard());
        table.where(table.owner().eq(schema).and(table.tableName().eq(tableName)));
        DataGraph[] results = this.client.find(table);
        return (Table)results[0].getRootObject();
    }

    private List<String> getTableNames(String schema) {
        ArrayList<String> result = new ArrayList<String>();
        QTable query = QTable.newQuery();
        query.select(query.tableName());
        query.where(query.owner().eq(schema));
        DataGraph[] dataGraphArray = this.client.find(query);
        int n = dataGraphArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataGraph graph = dataGraphArray[n2];
            Table tab = (Table)graph.getRootObject();
            result.add(tab.getTableName());
            ++n2;
        }
        return result;
    }

    public Class buildClass(Package pkg, Table table) {
        String tableTypeStr;
        TableType tableType;
        Class clss = new Class();
        clss.setId(UUID.randomUUID().toString());
        clss.setName(NameUtils.firstToUpperCase(NameUtils.toCamelCase(table.getTableName())));
        clss.setUri(pkg.getUri());
        Alias alias = new Alias();
        alias.setPhysicalName(table.getTableName());
        clss.setAlias(alias);
        if (table.getTableComment() != null) {
            Documentation documentation = new Documentation();
            documentation.setType(DocumentationType.DEFINITION);
            Body body = new Body();
            body.setValue(this.filter(table.getTableComment()));
            documentation.setBody(body);
            clss.getDocumentations().add(documentation);
        }
        if ((tableType = TableType.valueOf(tableTypeStr = table.getTableType().replace(' ', '_'))).ordinal() == TableType.VIEW.ordinal()) {
            if (table.getViewCount() == 1) {
                View view = table.getView(0);
                if (view.getViewDefinition() != null && view.getViewDefinition().length() > 0) {
                    Behavior create = new Behavior();
                    create.setLanguage("SQL");
                    create.setType(BehaviorType.CREATE);
                    create.setName(BehaviorType.CREATE.name().toLowerCase());
                    String definition = this.filter(view.getViewDefinition());
                    create.setValue("CREATE OR REPLACE VIEW " + pkg.getAlias().getPhysicalName() + "." + clss.getAlias().getPhysicalName() + " AS " + definition);
                    clss.getBehaviors().add(create);
                }
                Behavior drop = new Behavior();
                drop.setLanguage("SQL");
                drop.setType(BehaviorType.DROP);
                drop.setName(BehaviorType.DROP.name().toLowerCase());
                drop.setValue("DROP VIEW " + pkg.getAlias().getPhysicalName() + "." + clss.getAlias().getPhysicalName() + ";");
                clss.getBehaviors().add(drop);
            } else {
                log.warn((Object)("no view definition found for '" + table.getTableName() + "'"));
            }
        }
        return clss;
    }

    public Property buildProperty(Package pkg, Class clss, TableColumn column, ConstraintInfo[] constraints) {
        String[] literals;
        String condition;
        Property property = new Property();
        property.setId(UUID.randomUUID().toString());
        property.setVisibility(VisibilityType.PUBLIC);
        property.setName(NameUtils.firstToLowerCase(NameUtils.toCamelCase(column.getColumnName())));
        Alias alias = new Alias();
        alias.setPhysicalName(column.getColumnName());
        property.setAlias(alias);
        if ("YES".equalsIgnoreCase(column.getNullable())) {
            property.setNullable(true);
        } else {
            property.setNullable(false);
        }
        SysDataType oracleType = SysDataType.valueOf(column.getDataType().toUpperCase());
        DataType sdoType = this.mapType(oracleType, column.getCharMaxLength(), column.getDataPrecision(), column.getDataScale());
        DataTypeRef dataTypeRef = new DataTypeRef();
        dataTypeRef.setName(sdoType.name());
        dataTypeRef.setUri(PlasmaConfig.getInstance().getSDODataTypesNamespace().getUri());
        property.setType((TypeRef)dataTypeRef);
        ValueConstraint valueConstraint = this.buildValueConstraint(oracleType, column.getCharMaxLength(), column.getDataPrecision(), column.getDataScale());
        if (valueConstraint != null) {
            property.setValueConstraint(valueConstraint);
        }
        if (oracleType.ordinal() == SysDataType.ENUM.ordinal() && (condition = column.getColumnType()) != null && (literals = this.parseLiterals(column, condition)) != null) {
            Enumeration enm = this.buildEnumeration(pkg, clss, property, literals);
            pkg.getEnumerations().add(enm);
            this.enumQualifiedNameMap.put(String.valueOf(enm.getUri()) + "#" + enm.getName(), enm);
            EnumerationRef enumRef = new EnumerationRef();
            enumRef.setName(enm.getName());
            enumRef.setUri(enm.getUri());
            EnumerationConstraint enumConst = new EnumerationConstraint();
            enumConst.setValue(enumRef);
            property.setEnumerationConstraint(enumConst);
        }
        if (column.getColumnKey() != null && column.getColumnKey().trim().length() > 0) {
            ColumnKeyType keyType = ColumnKeyType.valueOf(column.getColumnKey().trim());
            switch (keyType) {
                case PRI: {
                    Key prikey = new Key();
                    prikey.setType(KeyType.PRIMARY);
                    property.setKey(prikey);
                    String constraintName = this.getSyntheticPriKeyConstraintName(pkg, clss, property);
                    String qualifiedName = String.valueOf(clss.getAlias().getPhysicalName()) + "." + constraintName;
                    this.propertyQualifiedPriKeyConstrainatNameMap.put(qualifiedName, property);
                    break;
                }
            }
        }
        ConstraintInfo[] constraintInfoArray = constraints;
        int n = constraints.length;
        int prikey = 0;
        while (prikey < n) {
            ConstraintInfo info = constraintInfoArray[prikey];
            String constraintType = info.getConstraint().getConstraintType().replace(' ', '_');
            ConstraintType consType = ConstraintType.valueOf(constraintType);
            switch (consType) {
                case PRIMARY_KEY: {
                    Key prikey2 = new Key();
                    prikey2.setType(KeyType.PRIMARY);
                    property.setKey(prikey2);
                    String qualifiedName = String.valueOf(clss.getAlias().getPhysicalName()) + "." + info.getConstraint().getName();
                    this.propertyQualifiedPriKeyConstrainatNameMap.put(qualifiedName, property);
                    UniqueConstraint uniqueConstraint = new UniqueConstraint();
                    uniqueConstraint.setGroup(info.getConstraint().getName());
                    property.setUniqueConstraint(uniqueConstraint);
                    break;
                }
                case FOREIGN_KEY: {
                    break;
                }
                case UNIQUE: {
                    UniqueConstraint uniqueConstraint = new UniqueConstraint();
                    uniqueConstraint.setGroup(info.getConstraint().getName());
                    property.setUniqueConstraint(uniqueConstraint);
                    break;
                }
            }
            ++prikey;
        }
        if (column.getColumnComment() != null) {
            Documentation documentation = new Documentation();
            documentation.setType(DocumentationType.DEFINITION);
            Body body = new Body();
            body.setValue(this.filter(column.getColumnComment()));
            documentation.setBody(body);
            property.getDocumentations().add(documentation);
        }
        return property;
    }

    private String getSyntheticPriKeyConstraintName(Package pkg, Class clss, Property property) {
        return "pk_" + property.getAlias().getPhysicalName().toLowerCase();
    }

    private Enumeration buildEnumeration(Package pkg, Class clss, Property property, String[] literals) {
        Enumeration enm = new Enumeration();
        enm.setId(UUID.randomUUID().toString());
        String baseName = String.valueOf(NameUtils.firstToUpperCase(property.getName())) + "Values";
        String suffix = this.getNameSequence(clss.getUri(), baseName, this.enumQualifiedNameMap);
        String name = String.valueOf(baseName) + suffix;
        int count = this.countExistingEnumsByName(pkg, name);
        if (count > 0) {
            name = String.valueOf(name) + String.valueOf(count);
        }
        enm.setName(name);
        enm.setUri(clss.getUri());
        Documentation documentation = new Documentation();
        documentation.setType(DocumentationType.DEFINITION);
        Body body = new Body();
        body.setValue("This enumeration was derived from enum column " + clss.getAlias().getPhysicalName() + "." + property.getAlias().getPhysicalName() + " and linked as an SDO enumeration constraint to logical" + " property " + clss.getName() + "." + property.getName() + ".");
        documentation.setBody(body);
        enm.getDocumentations().add(documentation);
        String[] stringArray = literals;
        int n = literals.length;
        int n2 = 0;
        while (n2 < n) {
            String literalStr = stringArray[n2];
            EnumerationLiteral literal = new EnumerationLiteral();
            enm.getEnumerationLiterals().add(literal);
            literal.setName(NameUtils.toCamelCase(literalStr));
            literal.setValue(NameUtils.toCamelCase(literalStr));
            literal.setId(UUID.randomUUID().toString());
            Alias alias = new Alias();
            literal.setAlias(alias);
            alias.setPhysicalName(literalStr);
            ++n2;
        }
        return enm;
    }

    private int countExistingEnumsByName(Package pkg, String name) {
        int i = 0;
        for (Enumeration enm : pkg.getEnumerations()) {
            if (!enm.getName().startsWith(name)) continue;
            ++i;
        }
        return i;
    }

    private String getNameSequence(String uri, String baseName, Map<String, ? extends Object> map) {
        String qualifiedName = String.valueOf(uri) + "#" + baseName;
        int num = 0;
        while (map.get(qualifiedName) != null) {
            qualifiedName = String.valueOf(uri) + "#" + baseName + String.valueOf(num);
            ++num;
        }
        if (num > 0) {
            return String.valueOf(num);
        }
        return "";
    }

    private String[] parseLiterals(TableColumn column, String condition) {
        String[] literals = null;
        int rightIndex = condition.indexOf("(");
        int leftIndex = condition.indexOf(")");
        if (rightIndex >= 0 && leftIndex > 0 && leftIndex > rightIndex) {
            String rawTokens = condition.substring(rightIndex, leftIndex);
            literals = rawTokens.split(",");
            int i = 0;
            while (i < literals.length) {
                int rightAposIndex = literals[i].indexOf("'");
                int leftAposIndex = literals[i].lastIndexOf("'");
                if (rightAposIndex >= 0 && leftAposIndex > 0) {
                    literals[i] = literals[i].substring(rightAposIndex + 1, leftAposIndex);
                }
                literals[i] = literals[i].trim();
                ++i;
            }
        }
        return literals;
    }

    private boolean findTokenIgnoreCase(String value, String[] tokens) {
        String[] stringArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            if (token.equalsIgnoreCase(value)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private ValueConstraint buildValueConstraint(SysDataType rdbType, int dataLength, int dataPrecision, int dataScale) {
        ValueConstraint constraint = null;
        switch (rdbType) {
            case TINYTEXT: 
            case TEXT: 
            case MEDIUMTEXT: 
            case LONGTEXT: 
            case ENUM: 
            case SET: 
            case CHAR: 
            case VARCHAR: {
                if (dataLength <= 0) break;
                constraint = new ValueConstraint();
                constraint.setMaxLength(String.valueOf(dataLength));
                break;
            }
            case BINARY: 
            case VARBINARY: 
            case TINYBLOB: 
            case BLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: {
                if (dataLength <= 0) break;
                constraint = new ValueConstraint();
                constraint.setMaxLength(String.valueOf(dataLength));
                break;
            }
            case DECIMAL: 
            case DEC: 
            case NUMERIC: 
            case FIXED: 
            case FLOAT: 
            case DOUBLE: 
            case DOUBLE__PRECISION: {
                if (dataPrecision <= 0) break;
                constraint = new ValueConstraint();
                constraint.setTotalDigits(String.valueOf(dataPrecision));
                if (dataScale <= 0) break;
                constraint.setFractionDigits(String.valueOf(dataScale));
            }
        }
        return constraint;
    }

    private DataType mapType(SysDataType rdbType, int dataLength, int dataPrecision, int dataScale) {
        switch (rdbType) {
            case TINYTEXT: 
            case TEXT: 
            case MEDIUMTEXT: 
            case LONGTEXT: 
            case ENUM: 
            case SET: 
            case CHAR: 
            case VARCHAR: {
                return DataType.String;
            }
            case BIT: {
                if (dataLength == 1) {
                    return DataType.Boolean;
                }
                return DataType.Bytes;
            }
            case TINYINT: {
                if (dataLength == 1) {
                    return DataType.Boolean;
                }
                return DataType.Short;
            }
            case BOOL: {
                return DataType.Boolean;
            }
            case BOOLEAN: {
                return DataType.Boolean;
            }
            case SMALLINT: {
                return DataType.Short;
            }
            case MEDIUMINT: {
                return DataType.Int;
            }
            case INT: {
                return DataType.Int;
            }
            case INTEGER: {
                return DataType.Int;
            }
            case BIGINT: {
                return DataType.Integer;
            }
            case DECIMAL: 
            case DEC: 
            case NUMERIC: 
            case FIXED: {
                return DataType.Decimal;
            }
            case FLOAT: {
                return DataType.Float;
            }
            case DOUBLE: 
            case DOUBLE__PRECISION: {
                return DataType.Double;
            }
            case DATE: {
                return DataType.Date;
            }
            case DATETIME: {
                return DataType.DateTime;
            }
            case TIMESTAMP: {
                return DataType.DateTime;
            }
            case TIME: {
                return DataType.Time;
            }
            case YEAR: {
                return DataType.Year;
            }
            case BINARY: 
            case VARBINARY: 
            case TINYBLOB: 
            case BLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: {
                return DataType.Bytes;
            }
        }
        log.warn((Object)("unknown datatype '" + rdbType.name() + "' - using String"));
        return DataType.String;
    }

    private DataType mapIntegralType(int dataPrecision) {
        if (dataPrecision == 1) {
            return DataType.Boolean;
        }
        if (dataPrecision <= 5) {
            return DataType.Short;
        }
        if (dataPrecision <= 10) {
            return DataType.Int;
        }
        if (dataPrecision <= 19) {
            return DataType.Long;
        }
        return DataType.Integer;
    }

    private DataType mapFloatingPointType(int dataPrecision, int dataScale) {
        if (dataPrecision <= 19) {
            return DataType.Float;
        }
        if (dataPrecision <= 35) {
            return DataType.Double;
        }
        return DataType.Decimal;
    }

    private String serializeGraph(DataGraph graph) throws IOException {
        DefaultOptions options = new DefaultOptions(graph.getRootObject().getType().getURI());
        options.setRootNamespacePrefix("dump");
        XMLDocument doc = PlasmaXMLHelper.INSTANCE.createDocument(graph.getRootObject(), graph.getRootObject().getType().getURI(), null);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PlasmaXMLHelper.INSTANCE.save(doc, os, (Object)options);
        os.flush();
        os.close();
        String xml = new String(os.toByteArray());
        return xml;
    }

    class ConstraintInfo {
        private TableConstraint constraint;
        private TableColumnKeyUsage columnConstraint;

        public ConstraintInfo(TableConstraint constraint, TableColumnKeyUsage columnConstraint) {
            this.constraint = constraint;
            this.columnConstraint = columnConstraint;
        }

        public TableConstraint getConstraint() {
            return this.constraint;
        }

        public TableColumnKeyUsage getTableColumnConstraint() {
            return this.columnConstraint;
        }
    }
}

