/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.provisioning.rdb;

import commonj.sdo.DataGraph;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.provisioning.ProvisioningException;
import org.plasma.provisioning.rdb.OracleVersion;
import org.plasma.provisioning.rdb.oracle.any.sys.Version;
import org.plasma.provisioning.rdb.oracle.any.sys.query.QVersion;
import org.plasma.sdo.access.client.JDBCPojoDataAccessClient;

public class OracleVersionFinder {
    private static Log log = LogFactory.getLog(OracleVersionFinder.class);
    protected JDBCPojoDataAccessClient client = new JDBCPojoDataAccessClient();

    public OracleVersion findVersion() {
        Version vers;
        QVersion version = QVersion.newQuery();
        version.select(version.wildcard());
        version.where(version.banner().like("Oracle Database*"));
        DataGraph[] results = this.client.find(version);
        if (results == null || results.length == 0) {
            throw new ProvisioningException("no Oracle version information found");
        }
        if (results.length > 1) {
            log.warn((Object)"found multiple version rows - ignoring");
        }
        if ((vers = (Version)results[0].getRootObject()).getBanner().contains("11g")) {
            return OracleVersion._11g;
        }
        if (vers.getBanner().contains("10g")) {
            return OracleVersion._10g;
        }
        if (vers.getBanner().contains("91")) {
            return OracleVersion._9i;
        }
        return OracleVersion._unknown;
    }
}

