/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.query.model;

import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import org.plasma.query.Operator;
import org.plasma.query.QueryException;
import org.plasma.query.model.RelationalOperatorValues;
import org.plasma.query.visitor.QueryVisitor;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="RelationalOperator", propOrder={"value"})
@XmlRootElement(name="RelationalOperator")
public class RelationalOperator
implements Operator {
    private static Map<String, RelationalOperatorValues> operMap = new HashMap<String, RelationalOperatorValues>();
    @XmlValue
    protected RelationalOperatorValues value;

    static {
        operMap.put("=", RelationalOperatorValues.EQUALS);
        operMap.put("!=", RelationalOperatorValues.NOT_EQUALS);
        operMap.put(">", RelationalOperatorValues.GREATER_THAN);
        operMap.put(">=", RelationalOperatorValues.GREATER_THAN_EQUALS);
        operMap.put("<", RelationalOperatorValues.LESS_THAN);
        operMap.put("<=", RelationalOperatorValues.LESS_THAN_EQUALS);
    }

    public RelationalOperator() {
    }

    public RelationalOperator(String content) {
        this();
        this.setValue(RelationalOperatorValues.valueOf(content));
    }

    public RelationalOperator(RelationalOperatorValues content) {
        this();
        this.setValue(content);
    }

    public static RelationalOperator valueOf(String value) {
        RelationalOperatorValues oper = operMap.get(value);
        if (oper != null) {
            return new RelationalOperator(oper);
        }
        throw new QueryException("invalid operator '" + value + "'");
    }

    public RelationalOperatorValues getValue() {
        return this.value;
    }

    public void setValue(RelationalOperatorValues value) {
        this.value = value;
    }

    public void accept(QueryVisitor visitor) {
        visitor.start(this);
        visitor.end(this);
    }
}

