/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.query.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.plasma.query.model.Entity;
import org.plasma.query.model.Expression;
import org.plasma.query.visitor.QueryVisitor;
import org.plasma.query.visitor.Traversal;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Update", propOrder={"entity", "expressions"})
@XmlRootElement(name="Update")
public class Update {
    @XmlElement(name="Entity", required=true)
    protected Entity entity;
    @XmlElement(name="Expression", required=true)
    protected List<Expression> expressions;

    public Update() {
    }

    public Update(Expression expr) {
        this();
        this.getExpressions().add(expr);
    }

    public Update(Expression[] exprs) {
        this();
        this.getExpressions().add(new Expression(exprs));
    }

    public Entity getEntity() {
        return this.entity;
    }

    public void setEntity(Entity value) {
        this.entity = value;
    }

    public void addExpression(Expression e) {
        this.getExpressions().add(e);
    }

    public List<Expression> getExpressions() {
        if (this.expressions == null) {
            this.expressions = new ArrayList<Expression>();
        }
        return this.expressions;
    }

    public int getExpressionCount() {
        return this.getExpressions().size();
    }

    public void accept(QueryVisitor visitor) {
        visitor.start(this);
        if (visitor.getContext().getTraversal().ordinal() == Traversal.CONTINUE.ordinal()) {
            int i = 0;
            while (i < this.getExpressions().size()) {
                this.getExpressions().get(i).accept(visitor);
                ++i;
            }
        }
        visitor.end(this);
    }
}

