/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.access.provider.common;

import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.sdo.AssociationPath;
import org.plasma.sdo.PlasmaChangeSummary;
import org.plasma.sdo.PlasmaDataObject;
import org.plasma.sdo.access.DataAccessException;
import org.plasma.sdo.access.provider.common.SimpleCollector;

public class DeletedObjectCollector
extends SimpleCollector {
    private static Log log = LogFactory.getFactory().getInstance(DeletedObjectCollector.class);
    private PlasmaChangeSummary changeSummary;

    private DeletedObjectCollector() {
    }

    public DeletedObjectCollector(DataGraph dataGraph) {
        this.changeSummary = (PlasmaChangeSummary)dataGraph.getChangeSummary();
        PlasmaDataObject root = (PlasmaDataObject)dataGraph.getRootObject();
        this.collect();
    }

    private void collect() {
        List list = this.changeSummary.getChangedDataObjects();
        for (DataObject changed : list) {
            if (!this.changeSummary.isDeleted(changed)) continue;
            DataObject[] resultArray = super.toArray();
            boolean found = false;
            int i = 0;
            while (i < resultArray.length) {
                if (this.isRelation(changed, resultArray[i], AssociationPath.singular)) {
                    if (super.contains(changed)) {
                        throw new DataAccessException("unexpected changed object: " + changed.getType().getURI() + "#" + changed.getType().getName() + "(" + ((PlasmaDataObject)changed).getUUIDAsString() + ")");
                    }
                    found = true;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("adding changed object: " + changed.getType().getName() + "(" + ((PlasmaDataObject)changed).getUUIDAsString() + ") at position " + i));
                    }
                    super.add(i, (PlasmaDataObject)changed);
                    break;
                }
                ++i;
            }
            if (found) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("appending changed object: " + changed.getType().getURI() + "#" + changed.getType().getName() + "(" + ((PlasmaDataObject)changed).getUUIDAsString() + ")"));
            }
            super.add((PlasmaDataObject)changed);
        }
    }
}

