/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.access.provider.common;

import commonj.sdo.Type;
import java.util.Iterator;
import java.util.List;
import org.plasma.query.QueryException;
import org.plasma.query.model.Expression;
import org.plasma.query.model.GroupOperator;
import org.plasma.query.model.Literal;
import org.plasma.query.model.NullLiteral;
import org.plasma.query.model.Property;
import org.plasma.query.model.Query;
import org.plasma.query.model.QueryConstants;
import org.plasma.query.model.SubqueryOperator;
import org.plasma.query.model.WildcardOperator;
import org.plasma.query.visitor.DefaultQueryVisitor;
import org.plasma.query.visitor.Traversal;
import org.plasma.sdo.access.provider.common.EntityConstants;

public abstract class TextQueryFilterAssembler
extends DefaultQueryVisitor
implements QueryConstants,
EntityConstants {
    protected Type contextType;
    protected commonj.sdo.Property contextProperty;
    protected StringBuilder filter = new StringBuilder();
    protected List<Object> params;

    public String getFilter() {
        return this.filter.toString();
    }

    public Object[] getParams() {
        Object[] result = new Object[this.params.size()];
        Iterator<Object> iter = this.params.iterator();
        int i = 0;
        while (iter.hasNext()) {
            Object param = iter.next();
            result[i] = !(param instanceof NullLiteral) ? param : null;
            ++i;
        }
        return result;
    }

    protected boolean hasWildcard(Expression expression) {
        int i = 0;
        while (i < expression.getTerms().size()) {
            Literal literal;
            if (expression.getTerms().get(i).getWildcardOperator() != null && (literal = expression.getTerms().get(i + 1).getLiteral()).getValue().indexOf("*") >= 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void start(Expression expression) {
        if (this.hasWildcard(expression)) {
            int i = 0;
            while (i < expression.getTerms().size()) {
                WildcardOperator wildcardOper = expression.getTerms().get(i).getWildcardOperator();
                if (wildcardOper != null) {
                    Property property = expression.getTerms().get(i - 1).getProperty();
                    Literal literal = expression.getTerms().get(i + 1).getLiteral();
                    this.processWildcardExpression(property, wildcardOper, literal);
                    i += 2;
                    continue;
                }
                if (expression.getTerms().get(i).getProperty() == null && expression.getTerms().get(i).getWildcardOperator() == null && expression.getTerms().get(i).getLiteral() == null) {
                    expression.getTerms().get(i).accept(this);
                }
                ++i;
            }
            this.getContext().setTraversal(Traversal.ABORT);
        }
        super.start(expression);
    }

    protected abstract void processWildcardExpression(Property var1, WildcardOperator var2, Literal var3);

    protected abstract void assembleSubquery(Property var1, SubqueryOperator var2, Query var3);

    protected String[] filterTokens(String[] tokens) {
        int count = 0;
        int i = 0;
        while (i < tokens.length) {
            if (tokens[i].length() > 0) {
                ++count;
            }
            ++i;
        }
        String[] result = new String[count];
        int j = 0;
        int i2 = 0;
        while (i2 < tokens.length) {
            if (tokens[i2].length() > 0) {
                result[j] = tokens[i2];
                ++j;
            }
            ++i2;
        }
        return result;
    }

    @Override
    public void start(GroupOperator operator) {
        if (this.filter.length() > 0) {
            this.filter.append(" ");
        }
        switch (operator.getValue()) {
            case LP_1: {
                this.filter.append(")");
                break;
            }
            case LP_2: {
                this.filter.append("))");
                break;
            }
            case LP_3: {
                this.filter.append(")))");
                break;
            }
            case RP_1: {
                this.filter.append("(");
                break;
            }
            case RP_2: {
                this.filter.append("((");
                break;
            }
            case RP_3: {
                this.filter.append("(((");
                break;
            }
            default: {
                throw new QueryException("unknown group operator, " + operator.getValue().name());
            }
        }
        super.start(operator);
    }
}

