/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.core;

import commonj.sdo.ChangeSummary;
import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Sequence;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.sdo.Change;
import org.plasma.sdo.ChangeType;
import org.plasma.sdo.PlasmaChangeSummary;
import org.plasma.sdo.PlasmaDataGraph;
import org.plasma.sdo.PlasmaNode;
import org.plasma.sdo.PlasmaSetting;
import org.plasma.sdo.core.CoreChange;
import org.plasma.sdo.core.CoreChangeComparator;

public class CoreChangeSummary
implements PlasmaChangeSummary,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getFactory().getInstance(CoreChangeSummary.class);
    private Map<UUID, CoreChange> changedDataObjects;
    private PlasmaDataGraph dataGraph;
    private long loggingBeganMillis = -1L;
    private long loggingEndedMillis;

    private CoreChangeSummary() {
    }

    public CoreChangeSummary(PlasmaDataGraph dataGraph) {
        this.dataGraph = dataGraph;
    }

    @Override
    public void created(DataObject dataObject) {
        PlasmaNode dataNode;
        UUID hashKey;
        CoreChange dataObjectSettings;
        if (!this.isLogging()) {
            return;
        }
        if (this.changedDataObjects == null) {
            this.changedDataObjects = new HashMap<UUID, CoreChange>();
        }
        if ((dataObjectSettings = this.changedDataObjects.get(hashKey = (dataNode = (PlasmaNode)dataObject).getUUID())) == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("created: " + dataObject.getType().getURI() + "#" + dataObject.getType().getName() + "(" + hashKey + ")"));
            }
        } else {
            throw new IllegalStateException("attempt to set data object to 'created' where existing settings found");
        }
        dataObjectSettings = new CoreChange(dataObject, ChangeType.CREATED, this.changedDataObjects);
        this.changedDataObjects.put(hashKey, dataObjectSettings);
    }

    @Override
    public void deleted(DataObject dataObject) {
        if (!this.isLogging()) {
            return;
        }
        if (this.changedDataObjects == null) {
            this.changedDataObjects = new HashMap<UUID, CoreChange>();
        }
        PlasmaNode dataNode = (PlasmaNode)dataObject;
        UUID hashKey = dataNode.getUUID();
        CoreChange dataObjectSettings = this.changedDataObjects.get(dataNode.getUUID());
        if (dataObjectSettings == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("deleted: " + dataObject.getType().getURI() + "#" + dataObject.getType().getName() + "(" + hashKey + ")"));
            }
            dataObjectSettings = new CoreChange(dataObject, ChangeType.DELETED, this.changedDataObjects);
            this.changedDataObjects.put(hashKey, dataObjectSettings);
        } else if (ChangeType.MODIFIED.ordinal() == dataObjectSettings.getChangeType().ordinal()) {
            List<ChangeSummary.Setting> settings = dataObjectSettings.getAllSettings();
            for (ChangeSummary.Setting setting : settings) {
                if (!setting.getProperty().getType().isDataType()) continue;
                throw new IllegalArgumentException("found unexpected modified property '" + setting.getProperty().getName() + "' for delete operation on data-object (" + dataNode.getUUIDAsString() + ") of type " + dataObject.getType().getURI() + "#" + dataObject.getType().getName());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("deleted: " + dataObject.getType().getURI() + "#" + dataObject.getType().getName() + "(" + hashKey + ")"));
            }
            dataObjectSettings = new CoreChange(dataObject, ChangeType.DELETED, this.changedDataObjects);
            this.changedDataObjects.put(hashKey, dataObjectSettings);
        } else {
            throw new IllegalArgumentException("found unexpected " + dataObjectSettings.getChangeType().toString() + " data-object (" + hashKey + ") of type " + dataObject.getType().getURI() + "#" + dataObject.getType().getName());
        }
    }

    @Override
    public void modified(DataObject dataObject, Property property, Object value) {
        if (!this.isLogging()) {
            return;
        }
        if (this.changedDataObjects == null) {
            this.changedDataObjects = new HashMap<UUID, CoreChange>();
        }
        PlasmaNode dataNode = (PlasmaNode)dataObject;
        UUID hashKey = dataNode.getUUID();
        if (this.isCreated(dataObject)) {
            Change dataObjectSettings = this.changedDataObjects.get(hashKey);
            if (dataObjectSettings == null) {
                throw new IllegalArgumentException("expected created data-object");
            }
            return;
        }
        CoreChange dataObjectSettings = this.changedDataObjects.get(hashKey);
        if (dataObjectSettings == null) {
            dataObjectSettings = new CoreChange(dataObject, ChangeType.MODIFIED, this.changedDataObjects);
            this.changedDataObjects.put(hashKey, dataObjectSettings);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("modified: " + dataObject.getType().getURI() + "#" + dataObject.getType().getName() + "." + property.getName() + "(" + hashKey + ")"));
        }
        dataObjectSettings.add(property, value);
    }

    @Override
    public void clear(DataObject dataObject) {
        if (!this.isLogging()) {
            return;
        }
        if (this.changedDataObjects == null) {
            return;
        }
        PlasmaNode dataNode = (PlasmaNode)dataObject;
        UUID hashKey = dataNode.getUUID();
        this.changedDataObjects.remove(hashKey);
        if (log.isDebugEnabled()) {
            log.debug((Object)("clear: " + dataObject.getType().getURI() + "#" + dataObject.getType().getName() + "(" + hashKey + ")"));
        }
    }

    public void beginLogging() {
        if (this.loggingBeganMillis > 0L) {
            throw new IllegalStateException("logging already active - first call endLogging()");
        }
        if (this.changedDataObjects != null) {
            this.changedDataObjects.clear();
        }
        this.loggingBeganMillis = System.currentTimeMillis();
    }

    public void endLogging() {
        this.loggingBeganMillis = -1L;
        this.loggingEndedMillis = System.currentTimeMillis();
    }

    public List<DataObject> getChangedDataObjects() {
        ArrayList<DataObject> result = new ArrayList<DataObject>();
        if (this.changedDataObjects != null) {
            Collection<CoreChange> coll = this.changedDataObjects.values();
            CoreChange[] changes = new CoreChange[coll.size()];
            coll.toArray(changes);
            Arrays.sort(changes, new CoreChangeComparator());
            CoreChange[] coreChangeArray = changes;
            int n = changes.length;
            int n2 = 0;
            while (n2 < n) {
                CoreChange change = coreChangeArray[n2];
                result.add(change.getDataObject());
                ++n2;
            }
        }
        return result;
    }

    public DataGraph getDataGraph() {
        return this.dataGraph;
    }

    public DataObject getOldContainer(DataObject dataObject) {
        return null;
    }

    public Property getOldContainmentProperty(DataObject dataObject) {
        return null;
    }

    public Sequence getOldSequence(DataObject dataObject) {
        return null;
    }

    public ChangeSummary.Setting getOldValue(DataObject dataObject, Property property) {
        if (dataObject == null) {
            throw new IllegalArgumentException("expected data-object arg");
        }
        if (property == null) {
            throw new IllegalArgumentException("expected property arg");
        }
        PlasmaNode dataNode = (PlasmaNode)dataObject;
        if (this.changedDataObjects == null) {
            return null;
        }
        Change dataObjectSettings = this.changedDataObjects.get(dataNode.getUUID());
        if (dataObjectSettings == null) {
            return null;
        }
        List<ChangeSummary.Setting> propertySettings = dataObjectSettings.getSettings(property.getName());
        if (propertySettings == null) {
            return null;
        }
        if (propertySettings.size() == 0) {
            throw new IllegalStateException("expected settings list with at least 1 member");
        }
        return propertySettings.get(0);
    }

    public List<ChangeSummary.Setting> getOldValues(DataObject dataObject) {
        ArrayList<ChangeSummary.Setting> result = new ArrayList<ChangeSummary.Setting>();
        PlasmaNode dataNode = (PlasmaNode)dataObject;
        Change dataObjectSettings = this.changedDataObjects.get(dataNode.getUUID());
        if (dataObjectSettings == null) {
            return result;
        }
        return dataObjectSettings.getAllSettings();
    }

    public DataObject getRootObject() {
        return this.dataGraph.getRootObject();
    }

    public boolean isCreated(DataObject dataObject) {
        if (dataObject == null) {
            throw new IllegalArgumentException("expected non-null data-object argument");
        }
        PlasmaNode dataNode = (PlasmaNode)dataObject;
        if (this.changedDataObjects != null) {
            Change info = this.changedDataObjects.get(dataNode.getUUID());
            return info != null && info.getChangeType() == ChangeType.CREATED;
        }
        return false;
    }

    public boolean isModified(DataObject dataObject) {
        if (dataObject == null) {
            throw new IllegalArgumentException("expected non-null data-object argument");
        }
        PlasmaNode dataNode = (PlasmaNode)dataObject;
        if (this.changedDataObjects != null) {
            Change info = this.changedDataObjects.get(dataNode.getUUID());
            return info != null && info.getChangeType() == ChangeType.MODIFIED;
        }
        return false;
    }

    public boolean isDeleted(DataObject dataObject) {
        if (dataObject == null) {
            throw new IllegalArgumentException("expected non-null data-object argument");
        }
        PlasmaNode dataNode = (PlasmaNode)dataObject;
        if (this.changedDataObjects != null) {
            Change info = this.changedDataObjects.get(dataNode.getUUID());
            return info != null && info.getChangeType() == ChangeType.DELETED;
        }
        return false;
    }

    @Override
    public int getPathDepth(DataObject dataObject) {
        if (dataObject == null) {
            throw new IllegalArgumentException("expected non-null data-object argument");
        }
        PlasmaNode dataNode = (PlasmaNode)dataObject;
        Change info = this.changedDataObjects.get(dataNode.getUUID());
        if (info == null) {
            throw new IllegalArgumentException("given data-object (" + dataNode.getUUIDAsString() + ") not registed in change summary");
        }
        return info.getPathDepthFromRoot();
    }

    public boolean isLogging() {
        return this.loggingBeganMillis > 0L;
    }

    public void undoChanges() {
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("\n\r");
        result.append("<ChangeSummary logging=\"" + String.valueOf(this.isLogging()) + ">");
        List<DataObject> changedObjects = this.getChangedDataObjects();
        for (DataObject dataObject : changedObjects) {
            PlasmaNode dataNode = (PlasmaNode)dataObject;
            Change info = this.changedDataObjects.get(dataNode.getUUID());
            List<ChangeSummary.Setting> settings = info.getAllSettings();
            result.append("\n\t<" + info.getChangeType().toString().toLowerCase() + " type=\"" + dataObject.getType().getName() + "\"" + " path=\"" + info.getPathFromRoot() + "\"" + " id=\"" + ((PlasmaNode)dataObject).getUUIDAsString() + "\"");
            if (settings.size() == 0) {
                result.append("\\>");
            } else {
                result.append(">");
            }
            if (settings != null) {
                for (ChangeSummary.Setting setting : settings) {
                    PlasmaSetting plasmaSetting = (PlasmaSetting)setting;
                    result.append("\n\t\t<property name=\"" + setting.getProperty().getName() + "\"");
                    result.append(" isSet=\"" + setting.isSet() + "\"");
                    if (setting.getProperty().getType().isDataType()) {
                        result.append(" value=\"" + String.valueOf(setting.getValue()) + "\"");
                    } else {
                        result.append(" value=\"" + plasmaSetting.getValuePath() + "\"");
                    }
                    result.append(" timestamp=\"" + String.valueOf(((PlasmaSetting)setting).getCreatedMillis()) + "\"");
                    result.append("</property>");
                }
            }
            if (settings.size() <= 0) continue;
            result.append("<\\" + info.getChangeType().toString().toLowerCase() + ">");
        }
        result.append("\n</ChangeSummary>");
        return result.toString();
    }
}

