/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.repository;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.config.PlasmaConfig;
import org.plasma.sdo.repository.Class_;
import org.plasma.sdo.repository.Classifier;
import org.plasma.sdo.repository.Namespace;
import org.plasma.sdo.repository.RelationCache;
import org.plasma.sdo.repository.Repository;
import org.plasma.sdo.repository.RepositoryException;
import org.plasma.sdo.repository.fuml.FumlRepository;

public class PlasmaRepository
implements Repository {
    private static Log log = LogFactory.getLog(PlasmaRepository.class);
    private static volatile Repository instance;
    private List<Repository> delegates = new ArrayList<Repository>();

    private PlasmaRepository() {
        for (org.plasma.config.Repository repoConfig : PlasmaConfig.getInstance().getRepositories()) {
            if (repoConfig.getRepositoryClassName() == null) continue;
            try {
                Class<?> interfaceImplClass = Class.forName(repoConfig.getRepositoryClassName());
                Method method = interfaceImplClass.getMethod("getInstance", new Class[0]);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("initializing repository for class: " + repoConfig.getRepositoryClassName()));
                }
                Repository repo = (Repository)method.invoke(null, new Object[0]);
                this.delegates.add(repo);
            }
            catch (ClassNotFoundException e) {
                throw new RepositoryException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RepositoryException(e);
            }
            catch (SecurityException e) {
                throw new RepositoryException(e);
            }
            catch (IllegalAccessException e) {
                throw new RepositoryException(e);
            }
            catch (IllegalArgumentException e) {
                throw new RepositoryException(e);
            }
            catch (InvocationTargetException e) {
                throw new RepositoryException(e);
            }
        }
        if (this.delegates.size() == 0) {
            this.delegates.add(FumlRepository.getInstance());
        }
    }

    public static Repository getInstance() throws RepositoryException {
        if (instance == null) {
            PlasmaRepository.initializeInstance();
        }
        return instance;
    }

    private static synchronized void initializeInstance() throws RepositoryException {
        if (instance == null) {
            instance = new PlasmaRepository();
        }
    }

    public synchronized void addRepository(Repository repo) {
        this.delegates.add(repo);
    }

    @Override
    public List<String> getAllNamespaceUris() {
        ArrayList<String> results = new ArrayList<String>();
        for (Repository repo : this.delegates) {
            results.addAll(repo.getAllNamespaceUris());
        }
        return results;
    }

    @Override
    public List<Namespace> getAllNamespaces() {
        ArrayList<Namespace> results = new ArrayList<Namespace>();
        for (Repository repo : this.delegates) {
            results.addAll(repo.getAllNamespaces());
        }
        return results;
    }

    @Override
    public Namespace getNamespaceForUri(String uri) {
        Namespace result = null;
        for (Repository repo : this.delegates) {
            result = repo.getNamespaceForUri(uri);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public List<Classifier> getClassifiers(String uri) {
        ArrayList<Classifier> results = new ArrayList<Classifier>();
        for (Repository repo : this.delegates) {
            results.addAll(repo.getClassifiers(uri));
        }
        return results;
    }

    @Override
    public Classifier getClassifier(String name) {
        Classifier result = null;
        for (Repository repo : this.delegates) {
            result = repo.findClassifier(name);
            if (result == null) continue;
            return result;
        }
        throw new RepositoryException("no classifier found for name, " + name);
    }

    @Override
    public Classifier findClassifier(String name) {
        Classifier result = null;
        for (Repository repo : this.delegates) {
            result = repo.findClassifier(name);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public RelationCache getRelationCache() {
        RelationCache result = null;
        for (Repository repo : this.delegates) {
            result = repo.getRelationCache();
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public Class_ getClassById(String id) {
        Class_ result = null;
        for (Repository repo : this.delegates) {
            result = repo.getClassById(id);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

