/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.text.ddl;

import org.plasma.sdo.DataType;
import org.plasma.text.ddl.Column;
import org.plasma.text.ddl.DDLException;
import org.plasma.text.ddl.DDLFactory;
import org.plasma.text.ddl.DefaultDDLFactory;
import org.plasma.text.ddl.Table;

public class OracleFactory
extends DefaultDDLFactory
implements DDLFactory {
    @Override
    public String getType(Table table, Column column) {
        DataType sdoType = DataType.valueOf((String)column.getType());
        switch (sdoType) {
            case String: 
            case Strings: 
            case URI: {
                if (column.getSize() > 0L) {
                    if (column.getSize() > 4000L) {
                        return "CLOB";
                    }
                    return "VARCHAR2(" + column.getSize() + ")";
                }
                return "VARCHAR2(255)";
            }
            case Boolean: 
            case Byte: {
                return "NUMBER(1)";
            }
            case Character: {
                return "VARCHAR2(1)";
            }
            case Decimal: {
                return "NUMBER(22)";
            }
            case Double: {
                return "FLOAT(49)";
            }
            case Float: {
                return "FLOAT(23)";
            }
            case Short: {
                return "NUMBER(6)";
            }
            case Integer: {
                return "NUMBER(24)";
            }
            case Int: 
            case Long: {
                return "NUMBER(10)";
            }
            case Bytes: 
            case Date: 
            case DateTime: 
            case Object: {
                return "DATE";
            }
            case Time: {
                return "TIMESTAMP";
            }
        }
        throw new DDLException("unsupported SDO type, " + sdoType.toString());
    }
}

