/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.text.lang3gl;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.common.io.StreamAssembler;
import org.plasma.provisioning.adapter.ProvisioningModel;
import org.plasma.text.TextProvisioningException;
import org.plasma.text.lang3gl.DefaultLang3GLAssembler;
import org.plasma.text.lang3gl.Lang3GLAssembler;
import org.plasma.text.lang3gl.Lang3GLFactory;
import org.plasma.text.lang3gl.Lang3GLOperation;

public abstract class DefaultStreamAssembler
extends DefaultLang3GLAssembler
implements StreamAssembler,
Lang3GLAssembler {
    private static Log log = LogFactory.getLog(DefaultStreamAssembler.class);
    protected File dest;
    protected boolean indent = false;
    protected static final String LINE_SEP = System.getProperty("line.separator");
    protected static final String FILE_SEP = System.getProperty("file.separator");
    protected int resultInterfacesCount;
    protected int resultClassesCount;
    protected int resultEnumerationsCount;

    public DefaultStreamAssembler(ProvisioningModel provisioningModel, Lang3GLFactory factory, Lang3GLOperation operation, File dest) {
        super(provisioningModel, factory, operation);
        if (this.provisioningModel == null) {
            throw new IllegalArgumentException("expected 'provisioningModel' argument");
        }
        if (this.factory == null) {
            throw new IllegalArgumentException("expected 'factory' argument");
        }
        if (this.operation == null) {
            throw new IllegalArgumentException("expected 'operation' argument");
        }
        this.dest = dest;
        if (this.dest == null) {
            throw new IllegalArgumentException("expected 'dest' argument");
        }
    }

    @Override
    public abstract void createEnumerationClasses() throws IOException;

    @Override
    public abstract void createInterfaceClasses() throws IOException;

    @Override
    public abstract void createInterfacePackageDocs() throws IOException;

    @Override
    public abstract void createImplementationClasses() throws IOException;

    public void start() {
        try {
            switch (this.operation) {
                case create: {
                    this.createEnumerationClasses();
                    this.createInterfaceClasses();
                    this.createInterfacePackageDocs();
                    this.createImplementationClasses();
                }
            }
        }
        catch (IOException e) {
            throw new TextProvisioningException(e);
        }
    }

    public boolean isIndent() {
        return this.indent;
    }

    public void setIndent(boolean indent) {
        this.indent = indent;
    }

    public String getIndentationToken() {
        return "\t";
    }

    public void setIndentationToken(String indentationToken) {
    }

    public int getResultInterfacesCount() {
        return this.resultInterfacesCount;
    }

    public int getResultClassesCount() {
        return this.resultClassesCount;
    }

    public int getResultEnumerationsCount() {
        return this.resultEnumerationsCount;
    }
}

