/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.text.lang3gl.java;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.common.WordWrap;
import org.plasma.metamodel.ClassRef;
import org.plasma.metamodel.DataTypeRef;
import org.plasma.metamodel.Documentation;
import org.plasma.metamodel.EnumerationConstraint;
import org.plasma.metamodel.Package;
import org.plasma.metamodel.Property;
import org.plasma.metamodel.TypeRef;
import org.plasma.metamodel.ValueConstraint;
import org.plasma.provisioning.PropertyNameCollisionException;
import org.plasma.provisioning.adapter.FieldAdapter;
import org.plasma.sdo.DataFlavor;
import org.plasma.sdo.DataType;
import org.plasma.sdo.helper.DataConverter;
import org.plasma.text.TextBuilder;
import org.plasma.text.TextProvisioningException;
import org.plasma.text.lang3gl.ClassNameResolver;
import org.plasma.text.lang3gl.Lang3GLContext;
import org.plasma.text.lang3gl.java.MetaClassInfo;

public abstract class DefaultFactory {
    private static Log log = LogFactory.getLog(DefaultFactory.class);
    protected Lang3GLContext context;
    protected static final String LINE_SEP = System.getProperty("line.separator");
    protected static final String FILE_SEP = System.getProperty("file.separator");
    private Map<Character, String> reservedJavaCharToLiteralMap = new HashMap<Character, String>();

    private DefaultFactory() {
    }

    public DefaultFactory(Lang3GLContext context) {
        this.context = context;
        this.reservedJavaCharToLiteralMap.put(Character.valueOf('+'), "_plus_");
        this.reservedJavaCharToLiteralMap.put(Character.valueOf('-'), "_minus_");
        this.reservedJavaCharToLiteralMap.put(Character.valueOf('/'), "_div_");
        this.reservedJavaCharToLiteralMap.put(Character.valueOf('*'), "_mult_");
        this.reservedJavaCharToLiteralMap.put(Character.valueOf('%'), "_mod_");
        this.reservedJavaCharToLiteralMap.put(Character.valueOf('('), "_rp_");
        this.reservedJavaCharToLiteralMap.put(Character.valueOf(')'), "_lp_");
        this.reservedJavaCharToLiteralMap.put(Character.valueOf('('), "_rb_");
        this.reservedJavaCharToLiteralMap.put(Character.valueOf(')'), "_lb_");
    }

    public Lang3GLContext getContext() {
        return this.context;
    }

    public Class<?> getTypeClass(DataType dataType) {
        return this.getTypeClass(dataType, this.context.usePrimitives());
    }

    public Class<?> getTypeClass(DataType dataType, boolean primitives) {
        if (primitives) {
            return DataConverter.INSTANCE.toPrimitiveJavaClass(dataType);
        }
        return DataConverter.INSTANCE.toWrapperJavaClass(dataType);
    }

    public String getPrimitiveTypeDefault(DataType dataType) {
        switch (dataType) {
            case Boolean: {
                return "false";
            }
            case Byte: 
            case Character: 
            case Decimal: 
            case Double: 
            case Float: 
            case Int: 
            case Integer: 
            case Long: 
            case Short: {
                return "0";
            }
        }
        throw new TextProvisioningException("unknown primitive type, " + dataType.toString());
    }

    @Deprecated
    protected void collectProvisioningClasses(Package pkg, org.plasma.metamodel.Class clss, Map<String, org.plasma.metamodel.Class> classMap) {
        for (Property field : clss.getProperties()) {
            TypeRef type = field.getType();
            if (!(type instanceof ClassRef)) continue;
            ClassRef cref = (ClassRef)type;
            org.plasma.metamodel.Class refClass = this.context.findClass(cref);
            classMap.put(String.valueOf(refClass.getUri()) + "#" + refClass.getName(), refClass);
        }
    }

    @Deprecated
    protected void collectProvisioningClassesDeep(Package pkg, org.plasma.metamodel.Class clss, Map<String, org.plasma.metamodel.Class> classMap) {
        this.collectProvisioningClasses(pkg, clss, classMap);
        if (clss.getSuperClasses() != null && clss.getSuperClasses().size() > 0) {
            for (ClassRef cref : clss.getSuperClasses()) {
                org.plasma.metamodel.Class superClass = this.context.findClass(cref);
                String qualifiedName = String.valueOf(cref.getUri()) + "#" + cref.getName();
                classMap.put(qualifiedName, superClass);
                Package superClassPackage = this.context.findPackage(cref);
                this.collectProvisioningClassesDeep(superClassPackage, superClass, classMap);
            }
        }
    }

    @Deprecated
    protected void collectProvisioningSuperclasses(Package pkg, org.plasma.metamodel.Class clss, Map<String, org.plasma.metamodel.Class> classMap) {
        if (clss.getSuperClasses() != null && clss.getSuperClasses().size() > 0) {
            for (ClassRef cref : clss.getSuperClasses()) {
                org.plasma.metamodel.Class superClass = this.context.findClass(cref);
                classMap.put(String.valueOf(superClass.getUri()) + "#" + superClass.getName(), superClass);
                Package superClassPackage = this.context.findPackage(cref);
                this.collectProvisioningSuperclasses(superClassPackage, superClass, classMap);
            }
        }
    }

    @Deprecated
    protected void collectProvisioningFields(Package targetPkg, org.plasma.metamodel.Class targetClss, Package pkg, org.plasma.metamodel.Class clss, Map<String, FieldAdapter> fields) {
        if (clss.getSuperClasses() != null) {
            for (ClassRef cref : clss.getSuperClasses()) {
                org.plasma.metamodel.Class sclss = this.context.findClass(cref);
                Package spkg = this.context.findPackage(cref);
                this.collectProvisioningFields(targetPkg, targetClss, spkg, sclss, fields);
            }
        }
        for (Property field : clss.getProperties()) {
            FieldAdapter existing = fields.get(field.getName());
            if (existing != null) {
                if (existing.getFieldClass().getName().equals(clss.getName()) && existing.getFieldClass().getUri().equals(clss.getUri())) {
                    log.warn((Object)("Classifier " + targetClss.getUri() + "#" + targetClss.getName() + " inherits multiple identical properties '" + existing.getFieldClass().getUri() + "#" + existing.getFieldClass().getName() + "." + existing.getField().getName() + "'"));
                    continue;
                }
                if (targetClss.getName().equals(clss.getName()) && targetClss.getUri().equals(clss.getUri())) {
                    throw new PropertyNameCollisionException("Classifier " + clss.getUri() + "#" + clss.getName() + " with property '" + field.getName() + "' inherits an identically named property from classifier " + existing.getFieldClass().getUri() + "#" + existing.getFieldClass().getName());
                }
                throw new PropertyNameCollisionException("Classifier " + targetClss.getUri() + "#" + targetClss.getName() + " inherits multiple properties named '" + field.getName() + "' from 2 parent classifiers, " + existing.getFieldClass().getUri() + "#" + existing.getFieldClass().getName() + " and " + clss.getUri() + "#" + clss.getName());
            }
            FieldAdapter adapter = new FieldAdapter(pkg, clss, field);
            fields.put(field.getName(), adapter);
        }
    }

    protected String createImportDeclaration(Package pkg, org.plasma.metamodel.Class clss, String qualifiedname) {
        TextBuilder buf = new TextBuilder(LINE_SEP, this.context.getIndentationToken());
        buf.append("import ");
        buf.append(qualifiedname);
        buf.append(";");
        return buf.toString();
    }

    protected String beginBody() {
        return "{";
    }

    protected String endBody() {
        return "}";
    }

    protected MetaClassInfo getTypeClassName(TypeRef type) {
        MetaClassInfo result = null;
        if (type instanceof DataTypeRef) {
            DataTypeRef dataTypeRef = (DataTypeRef)type;
            DataType sdoType = DataType.valueOf((String)dataTypeRef.getName());
            Class<?> primitiveTypeClass = this.getTypeClass(sdoType, true);
            Class<?> wrapperTypeClass = this.getTypeClass(sdoType, false);
            result = new MetaClassInfo(dataTypeRef, sdoType, primitiveTypeClass, wrapperTypeClass, this.context.usePrimitives());
        } else if (type instanceof ClassRef) {
            result = new MetaClassInfo((ClassRef)type, this.context.usePrimitives());
        }
        return result;
    }

    protected DataFlavor getDataFlavor(DataTypeRef dataTypeRef) {
        DataType sdoType = DataType.valueOf((String)dataTypeRef.getName());
        return DataFlavor.fromDataType((DataType)sdoType);
    }

    @Deprecated
    protected String getTypeClassName(org.plasma.metamodel.Class clss) {
        return clss.getName();
    }

    protected String firstToUpperCase(String name) {
        if (!Character.isUpperCase(name.charAt(0))) {
            return String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1);
        }
        return name;
    }

    protected String toEnumLiteralName(String name) {
        name = this.toConstantName(name);
        TextBuilder buf = new TextBuilder(LINE_SEP, this.context.getIndentationToken());
        char[] array = name.toCharArray();
        int i = 0;
        while (i < array.length) {
            if (i == 0 && Character.isDigit(array[i])) {
                buf.append("_");
            }
            buf.append(array[i]);
            ++i;
        }
        return buf.toString();
    }

    protected String toConstantName(String name) {
        name = name.trim();
        TextBuilder buf = new TextBuilder(LINE_SEP, this.context.getIndentationToken());
        char[] array = name.toCharArray();
        int i = 0;
        while (i < array.length) {
            String lit = this.reservedJavaCharToLiteralMap.get(Character.valueOf(array[i]));
            if (lit != null) {
                buf.append(lit.toUpperCase());
            } else {
                if (i > 0 && Character.isLetter(array[i]) && Character.isUpperCase(array[i]) && !Character.isUpperCase(array[i - 1])) {
                    buf.append("_");
                }
                if (Character.isLetterOrDigit(array[i])) {
                    buf.append(Character.toUpperCase(array[i]));
                } else {
                    buf.append("_");
                }
            }
            ++i;
        }
        return buf.toString();
    }

    protected String toMethodFieldName(String name) {
        return this.firstToUpperCase(name);
    }

    protected String indent(int num) {
        TextBuilder buf = new TextBuilder(LINE_SEP, this.context.getIndentationToken());
        int i = 0;
        while (i < num) {
            buf.append(this.getContext().getIndentationToken());
            ++i;
        }
        return buf.toString();
    }

    protected String newline(int num) {
        TextBuilder buf = new TextBuilder(LINE_SEP, this.context.getIndentationToken());
        buf.append(LINE_SEP);
        int i = 0;
        while (i < num) {
            buf.append(this.getContext().getIndentationToken());
            ++i;
        }
        return buf.toString();
    }

    protected boolean hasOnlySingilarFields(org.plasma.metamodel.Class clss) {
        if (clss.getProperties() != null) {
            for (Property field : clss.getProperties()) {
                if (!field.isMany()) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean hasOnlySingilarFieldsDeep(org.plasma.metamodel.Class clss) {
        Iterator iterator;
        if (!this.hasOnlySingilarFields(clss)) {
            return false;
        }
        if (clss.getSuperClasses() != null && clss.getSuperClasses().size() > 0 && (iterator = clss.getSuperClasses().iterator()).hasNext()) {
            ClassRef cref = (ClassRef)iterator.next();
            org.plasma.metamodel.Class superClass = this.context.findClass(cref);
            return this.hasOnlySingilarFieldsDeep(superClass);
        }
        return true;
    }

    protected void createSingularGetterDeclaration(Package pkg, org.plasma.metamodel.Class clss, Property field, MetaClassInfo typeClassName, TextBuilder buf) {
        buf.appendln(1, "/**");
        buf.appendln(1, " * Returns the value of the <b>");
        buf.append(field.getName());
        buf.append("</b> property.");
        String definition = this.getWrappedDocmentations(field.getDocumentations(), 1);
        if (definition != null && definition.length() > 0) {
            buf.appendln(1, " * <p></p>");
            buf.appendln(1, " * <b>Property Definition: </b>");
            buf.append(definition);
        }
        buf.appendln(1, " * @return the value of the <b>");
        buf.append(field.getName());
        buf.append("</b> property.");
        buf.appendln(1, " */");
        buf.appendln(1, "public ");
        buf.append(typeClassName.getSimpleName());
        buf.append(" get");
        buf.append(this.toMethodFieldName(field.getName()));
        buf.append("()");
    }

    protected void createSingularSetterDeclaration(Package pkg, org.plasma.metamodel.Class clss, Property field, MetaClassInfo typeClassName, TextBuilder buf) {
        buf.appendln(1, "/**");
        buf.appendln(1, " * Sets the value of the <b>");
        buf.append(field.getName());
        buf.append("</b> property to the given value.");
        String definition = this.getWrappedDocmentations(field.getDocumentations(), 1);
        if (definition != null && definition.length() > 0) {
            buf.appendln(1, " * <p></p>");
            buf.appendln(1, " * <b>Property Definition: </b>");
            buf.append(definition);
        }
        if (field.getValueConstraint() != null || field.getEnumerationConstraint() != null) {
            if (field.getValueConstraint() != null) {
                buf.appendln(1, " * <p></p>");
                buf.appendln(1, " * <b>Value Constraints: </b>");
                buf.append("<pre>");
                ValueConstraint vc = field.getValueConstraint();
                if (vc.getMinLength() != null) {
                    buf.appendln(1, " *     minLength: ");
                    buf.append(vc.getMinLength());
                }
                if (vc.getMaxLength() != null) {
                    buf.appendln(1, " *     maxLength: ");
                    buf.append(vc.getMaxLength());
                }
                if (vc.getMinInclusive() != null) {
                    buf.appendln(1, " *     minInclusive: ");
                    buf.append(vc.getMinInclusive());
                }
                if (vc.getMaxInclusive() != null) {
                    buf.appendln(1, " *     maxInclusive: ");
                    buf.append(vc.getMaxInclusive());
                }
                if (vc.getMinExclusive() != null) {
                    buf.appendln(1, " *     minExclusive: ");
                    buf.append(vc.getMinExclusive());
                }
                if (vc.getMaxExclusive() != null) {
                    buf.appendln(1, " *     maxExclusive: ");
                    buf.append(vc.getMaxExclusive());
                }
                if (vc.getFractionDigits() != null) {
                    buf.appendln(1, " *     fractionDigits: ");
                    buf.append(vc.getFractionDigits());
                }
                if (vc.getTotalDigits() != null) {
                    buf.appendln(1, " *     totalDigits: ");
                    buf.append(vc.getTotalDigits());
                }
                if (vc.getPattern() != null) {
                    buf.appendln(1, " *     pattern: ");
                    buf.append(vc.getPattern());
                }
                buf.append("</pre>");
            } else if (field.getEnumerationConstraint() != null) {
                buf.appendln(1, " * <p></p>");
                buf.appendln(1, " * <b>Enumeration Constraints: </b>");
                buf.append("<pre>");
                EnumerationConstraint ec = field.getEnumerationConstraint();
                buf.appendln(1, " *     <b>name:</b> ");
                buf.append(ec.getValue().getName());
                buf.appendln(1, " *     <b>URI:</b>");
                buf.append(ec.getValue().getUri());
                buf.append("</pre>");
            }
        }
        buf.appendln(1, " */");
        buf.appendln(1, "public void set");
        buf.append(this.toMethodFieldName(field.getName()));
        buf.append("(");
        buf.append(typeClassName.getSimpleName());
        buf.append(" value)");
    }

    protected void createUnsetterDeclaration(Package pkg, org.plasma.metamodel.Class clss, Property field, MetaClassInfo typeClassName, TextBuilder buf) {
        buf.appendln(1, "/**");
        buf.appendln(1, " * Unsets the <b>");
        buf.append(field.getName());
        buf.append("</b> property, ");
        if (field.isMany()) {
            buf.append("clearing the underlying collection. ");
        } else {
            buf.append("the value");
            buf.appendln(1, " * of the property of the object being set to the property's");
            buf.appendln(1, " * default value. ");
        }
        buf.append("The property will no longer be");
        buf.appendln(1, " * considered set.");
        String definition = this.getWrappedDocmentations(field.getDocumentations(), 1);
        if (definition != null && definition.length() > 0) {
            this.addPropertyModelDocLinks(clss, field, typeClassName, buf);
        }
        buf.appendln(1, " */");
        buf.appendln(1, "public void unset");
        buf.append(this.toMethodFieldName(field.getName()));
        buf.append("()");
    }

    private void addPropertyModelDocLinks(org.plasma.metamodel.Class clss, Property field, MetaClassInfo typeClassName, TextBuilder buf) {
        buf.appendln(1, " * <p></p>");
        buf.appendln(1, " * <b>Property Definition: </b>");
        buf.appendln(1, " * See {@link #get");
        buf.append(this.toMethodFieldName(field.getName()));
        buf.append("() get");
        buf.append(this.toMethodFieldName(field.getName()));
        buf.append("} or {@link #set");
        buf.append(this.toMethodFieldName(field.getName()));
        if (!field.isMany()) {
            buf.append("(");
            buf.append(typeClassName.getSimpleName());
            buf.append(" value) ");
        } else {
            buf.append("(");
            buf.append(typeClassName.getSimpleName());
            buf.append("[] value) ");
        }
        buf.append("set");
        buf.append(this.toMethodFieldName(field.getName()));
        buf.append("(...)} for a definition of property <b>");
        buf.append(field.getName());
        buf.append("</b>");
    }

    protected void createIsSetDeclaration(Package pkg, org.plasma.metamodel.Class clss, Property field, MetaClassInfo typeClassName, TextBuilder buf) {
        buf.appendln(1, "/**");
        buf.appendln(1, " * Returns true if the <b>");
        buf.append(field.getName());
        buf.append("</b> property is set.");
        String definition = this.getWrappedDocmentations(field.getDocumentations(), 1);
        if (definition != null && definition.length() > 0) {
            this.addPropertyModelDocLinks(clss, field, typeClassName, buf);
        }
        buf.appendln(1, " * @return true if the <b>");
        buf.append(field.getName());
        buf.append("</b> property is set.");
        buf.appendln(1, " */");
        buf.appendln(1, "public boolean isSet");
        buf.append(this.toMethodFieldName(field.getName()));
        buf.append("()");
    }

    protected void createCreatorDeclaration(Package pkg, org.plasma.metamodel.Class clss, Property field, MetaClassInfo typeClassName, TextBuilder buf) {
        buf.appendln(1, "/**");
        buf.appendln(1, " * Creates and returns a new instance of Type {@link ");
        buf.append(typeClassName.getSimpleName());
        buf.append("} automatically establishing a containment relationship ");
        buf.append("through the object's reference property, <b>");
        buf.append(field.getName());
        buf.append("</b>.");
        String definition = this.getWrappedDocmentations(field.getDocumentations(), 1);
        if (definition != null && definition.length() > 0) {
            this.addPropertyModelDocLinks(clss, field, typeClassName, buf);
        }
        buf.appendln(1, " * @return a new instance of Type {@link ");
        buf.append(typeClassName.getSimpleName());
        buf.append("} automatically establishing a containment relationship ");
        buf.append("through the object's reference property <b>");
        buf.append(field.getName());
        buf.append("</b>.");
        buf.appendln(1, " */");
        buf.appendln(1, "public ");
        buf.append(typeClassName.getSimpleName());
        buf.append(" create");
        buf.append(this.toMethodFieldName(field.getName()));
        buf.append("()");
    }

    protected void createCreatorByAbstractClassDeclaration(Package pkg, org.plasma.metamodel.Class clss, Property field, MetaClassInfo typeClassName, TextBuilder buf) {
        buf.appendln(1, "/**");
        buf.appendln(1, " * Creates and returns a new instance of the given subclass Type for abstract base Type {@link ");
        buf.append(typeClassName.getSimpleName());
        buf.append("} automatically establishing a containment relationship ");
        buf.append("through the object's reference property, <b>");
        buf.append(field.getName());
        buf.append("</b>.");
        String definition = this.getWrappedDocmentations(field.getDocumentations(), 1);
        if (definition != null && definition.length() > 0) {
            this.addPropertyModelDocLinks(clss, field, typeClassName, buf);
        }
        buf.appendln(1, " * @param clss the subclass Type");
        buf.appendln(1, " * Returns a new instance of the given subclass Type for abstract base Type {@link ");
        buf.append(typeClassName.getSimpleName());
        buf.append("}.");
        buf.appendln(1, " */");
        buf.appendln(1, "public ");
        buf.append(typeClassName.getSimpleName());
        buf.append(" create");
        buf.append(this.toMethodFieldName(field.getName()));
        buf.append("(Class<? extends ");
        buf.append(typeClassName.getSimpleName());
        buf.append("> clss)");
    }

    protected void createManyGetterDeclaration(Package pkg, org.plasma.metamodel.Class clss, Property field, MetaClassInfo typeClassName, TextBuilder buf) {
        buf.appendln(1, "/**");
        buf.appendln(1, " * Returns an array of <b>");
        buf.append(typeClassName.getSimpleName());
        buf.append("</b> set for the object's multi-valued property <b>");
        buf.append(field.getName());
        buf.append("</b>.");
        String definition = this.getWrappedDocmentations(field.getDocumentations(), 1);
        if (definition != null && definition.length() > 0) {
            buf.appendln(1, " * <p></p>");
            buf.appendln(1, " * <b>Property Definition: </b>");
            buf.append(definition);
        }
        buf.appendln(1, " * @return an array of <b>");
        buf.append(typeClassName.getSimpleName());
        buf.append("</b> set for the object's multi-valued property <b>");
        buf.append(field.getName());
        buf.append("</b>.");
        buf.appendln(1, " */");
        buf.appendln(1, "public ");
        buf.append(typeClassName.getSimpleName());
        buf.append("[] get");
        buf.append(this.toMethodFieldName(field.getName()));
        buf.append("()");
    }

    protected void createManyIndexGetterDeclaration(Package pkg, org.plasma.metamodel.Class clss, Property field, MetaClassInfo typeClassName, TextBuilder buf) {
        buf.appendln(1, "/**");
        buf.appendln(1, " * Returns the <b>");
        buf.append(typeClassName.getSimpleName());
        buf.append("</b> set for the object's multi-valued property <b>");
        buf.append(field.getName());
        buf.append("</b> based on the given index.");
        String definition = this.getWrappedDocmentations(field.getDocumentations(), 1);
        if (definition != null && definition.length() > 0) {
            this.addPropertyModelDocLinks(clss, field, typeClassName, buf);
        }
        buf.appendln(1, " * @param idx the index");
        buf.appendln(1, " * @return the <b>");
        buf.append(typeClassName.getSimpleName());
        buf.append("</b> set for the object's multi-valued property <b>");
        buf.append(field.getName());
        buf.append("</b> based on the given index.");
        buf.appendln(1, " */");
        buf.appendln(1, "public ");
        buf.append(typeClassName.getSimpleName());
        buf.append(" get");
        buf.append(this.toMethodFieldName(field.getName()));
        buf.append("(int idx)");
    }

    protected void createManyCountDeclaration(Package pkg, org.plasma.metamodel.Class clss, Property field, MetaClassInfo typeClassName, TextBuilder buf) {
        buf.appendln(1, "/**");
        buf.appendln(1, " * Returns a count for multi-valued property <b>");
        buf.append(field.getName());
        buf.append("</b>.");
        String definition = this.getWrappedDocmentations(field.getDocumentations(), 1);
        if (definition != null && definition.length() > 0) {
            this.addPropertyModelDocLinks(clss, field, typeClassName, buf);
        }
        buf.appendln(1, " * @return a count for multi-valued property <b>");
        buf.append(field.getName());
        buf.append("</b>.");
        buf.appendln(1, " */");
        buf.appendln(1, "public int get");
        buf.append(this.toMethodFieldName(field.getName()));
        buf.append("Count()");
    }

    protected void createManySetterDeclaration(Package pkg, org.plasma.metamodel.Class clss, Property field, MetaClassInfo typeClassName, TextBuilder buf) {
        buf.appendln(1, "/**");
        buf.appendln(1, " * Sets the given array of Type <b>");
        buf.append(typeClassName.getSimpleName());
        buf.append("</b> for the object's multi-valued property <b>");
        buf.append(field.getName());
        buf.append("</b>.");
        String definition = this.getWrappedDocmentations(field.getDocumentations(), 1);
        if (definition != null && definition.length() > 0) {
            buf.appendln(1, " * <p></p>");
            buf.appendln(1, " * <b>Property Definition: </b>");
            buf.append(definition);
        }
        buf.appendln(1, " * @param value the array value");
        buf.appendln(1, " */");
        buf.appendln(1, "public void set");
        buf.append(this.toMethodFieldName(field.getName()));
        buf.append("(");
        buf.append(typeClassName.getSimpleName());
        buf.append("[] value)");
    }

    protected void createManyAdderDeclaration(Package pkg, org.plasma.metamodel.Class clss, Property field, MetaClassInfo typeClassName, TextBuilder buf) {
        buf.appendln(1, "/**");
        buf.appendln(1, " * Adds the given value of Type <b>");
        buf.append(typeClassName.getSimpleName());
        buf.append("</b> for the object's multi-valued property <b>");
        buf.append(field.getName());
        buf.append("</b>.");
        String definition = this.getWrappedDocmentations(field.getDocumentations(), 1);
        if (definition != null && definition.length() > 0) {
            this.addPropertyModelDocLinks(clss, field, typeClassName, buf);
        }
        buf.appendln(1, " * @param value the value to add");
        buf.appendln(1, " */");
        buf.appendln(1, "public void add");
        buf.append(this.toMethodFieldName(field.getName()));
        buf.append("(");
        buf.append(typeClassName.getSimpleName());
        buf.append(" value)");
    }

    protected void createManyRemoverDeclaration(Package pkg, org.plasma.metamodel.Class clss, Property field, MetaClassInfo typeClassName, TextBuilder buf) {
        buf.appendln(1, "/**");
        buf.appendln(1, " * Removes the given value of Type <b>");
        buf.append(typeClassName.getSimpleName());
        buf.append("</b> for the object's multi-valued property <b>");
        buf.append(field.getName());
        buf.append("</b>.");
        String definition = this.getWrappedDocmentations(field.getDocumentations(), 1);
        if (definition != null && definition.length() > 0) {
            this.addPropertyModelDocLinks(clss, field, typeClassName, buf);
        }
        buf.appendln(1, " * @param value the value to remove");
        buf.appendln(1, " */");
        buf.appendln(1, "public void remove");
        buf.append(this.toMethodFieldName(field.getName()));
        buf.append("(");
        buf.append(typeClassName.getSimpleName());
        buf.append(" value)");
    }

    protected void collectReferenceClassNames(Package pkg, org.plasma.metamodel.Class clss, Map<String, String> nameMap, ClassNameResolver resolver) {
        this.collectReferenceClassNames(pkg, clss, nameMap, resolver, true, -1);
    }

    protected void collectReferenceClassNames(Package pkg, org.plasma.metamodel.Class clss, Map<String, String> nameMap, ClassNameResolver resolver, boolean collectAbstractClasses, int maxLevel) {
        for (Property field : clss.getProperties()) {
            TypeRef type = field.getType();
            if (type instanceof DataTypeRef) continue;
            ClassRef ref = (ClassRef)type;
            String qualifiedName = resolver.getQualifiedName(ref);
            nameMap.put(qualifiedName, qualifiedName);
        }
    }

    protected void collectDataClassNames(Package pkg, org.plasma.metamodel.Class clss, Map<String, String> nameMap, ClassNameResolver resolver) {
        this.collectDataClassNames(pkg, clss, nameMap, resolver, true, -1);
    }

    protected void collectDataClassNames(Package pkg, org.plasma.metamodel.Class clss, Map<String, String> nameMap, ClassNameResolver resolver, boolean collectAbstractClasses, int maxLevel) {
        for (Property field : clss.getProperties()) {
            DataType sdoType;
            Class<?> typeClass;
            TypeRef type = field.getType();
            if (type instanceof ClassRef || (typeClass = this.getTypeClass(sdoType = DataType.valueOf((String)((DataTypeRef)type).getName()))).isPrimitive() || typeClass.isArray()) continue;
            nameMap.put(typeClass.getName(), typeClass.getName());
        }
    }

    protected void collectSuperClassNames(Package pkg, org.plasma.metamodel.Class clss, Map<String, String> nameMap, ClassNameResolver resolver) {
        this.collectSuperClassNames(pkg, clss, nameMap, resolver, true, -1);
    }

    protected void collectSuperClassNames(Package pkg, org.plasma.metamodel.Class clss, Map<String, String> nameMap, ClassNameResolver resolver, boolean collectAbstractClasses, int maxLevel) {
        if (clss.getSuperClasses() != null && clss.getSuperClasses().size() > 0) {
            for (ClassRef cref : clss.getSuperClasses()) {
                org.plasma.metamodel.Class superClass = this.context.findClass(cref);
                if (superClass.isAbstract() && !collectAbstractClasses) continue;
                Package superClassPackage = this.context.findPackage(cref);
                String qualifiedName = resolver.getQualifiedName(superClass, superClassPackage);
                nameMap.put(qualifiedName, qualifiedName);
                this.collectSuperClassNames(superClassPackage, superClass, nameMap, resolver, collectAbstractClasses, maxLevel);
            }
        }
    }

    protected void collectReferenceFieldClassNamesDeep(Package pkg, org.plasma.metamodel.Class clss, Map<String, String> nameMap, ClassNameResolver resolver, boolean collectAbstractClasses, int maxLevel) {
        this.collectReferenceClassNames(pkg, clss, nameMap, resolver);
        if (clss.getSuperClasses() != null && clss.getSuperClasses().size() > 0) {
            for (ClassRef cref : clss.getSuperClasses()) {
                org.plasma.metamodel.Class superClass = this.context.findClass(cref);
                if (superClass.isAbstract() && !collectAbstractClasses) continue;
                Package superClassPackage = this.context.findPackage(cref);
                this.collectReferenceFieldClassNamesDeep(superClassPackage, superClass, nameMap, resolver, collectAbstractClasses, maxLevel);
            }
        }
    }

    protected void collectDataFieldClassNamesDeep(Package pkg, org.plasma.metamodel.Class clss, Map<String, String> nameMap, ClassNameResolver resolver, boolean collectAbstractClasses, int maxLevel) {
        this.collectDataClassNames(pkg, clss, nameMap, resolver);
        if (clss.getSuperClasses() != null && clss.getSuperClasses().size() > 0) {
            for (ClassRef cref : clss.getSuperClasses()) {
                org.plasma.metamodel.Class superClass = this.context.findClass(cref);
                if (superClass.isAbstract() && !collectAbstractClasses) continue;
                Package superClassPackage = this.context.findPackage(cref);
                this.collectDataFieldClassNamesDeep(superClassPackage, superClass, nameMap, resolver, collectAbstractClasses, maxLevel);
            }
        }
    }

    protected void collectSuperclassNames(Package pkg, org.plasma.metamodel.Class clss, Map<String, String> nameMap, ClassNameResolver resolver) {
        if (clss.getSuperClasses() != null && clss.getSuperClasses().size() > 0) {
            for (ClassRef cref : clss.getSuperClasses()) {
                String qualifiedName = resolver.getQualifiedName(cref);
                org.plasma.metamodel.Class superClass = this.context.findClass(cref);
                nameMap.put(qualifiedName, qualifiedName);
                Package superClassPackage = this.context.findPackage(cref);
                this.collectSuperclassNames(superClassPackage, superClass, nameMap, resolver);
            }
        }
    }

    protected Map<String, String> createFieldImportMap(Package pkg, org.plasma.metamodel.Class clss, ClassNameResolver resolver) {
        TreeMap<String, String> nameMap = new TreeMap<String, String>();
        this.collectDataFieldClassNamesDeep(pkg, clss, nameMap, resolver, true, -1);
        this.collectReferenceFieldClassNamesDeep(pkg, clss, nameMap, resolver, true, -1);
        return nameMap;
    }

    protected String createImportDeclarations(Map<String, String> nameMap) {
        TextBuilder buf = new TextBuilder(LINE_SEP, this.context.getIndentationToken());
        for (String name : nameMap.values()) {
            buf.append(LINE_SEP);
            buf.append("import ");
            buf.append(name);
            buf.append(";");
        }
        return buf.toString();
    }

    protected String getWrappedDocmentations(List<Documentation> docs, int indent) {
        TextBuilder docsBuf = new TextBuilder(LINE_SEP, this.context.getIndentationToken());
        if (docs != null) {
            for (Documentation doc : docs) {
                String[] docLines;
                String docText;
                if (doc.getBody() == null || doc.getBody().getValue() == null || (docText = doc.getBody().getValue().trim()).length() == 0) continue;
                String wrappedDoc = WordWrap.wordWrap((String)docText, (int)60, (Locale)Locale.ENGLISH);
                String[] stringArray = docLines = wrappedDoc.split("\n");
                int n = docLines.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    docsBuf.append(this.newline(indent));
                    docsBuf.append(" * ");
                    docsBuf.append(line);
                    ++n2;
                }
            }
        }
        return docsBuf.toString();
    }
}

