/**
 *         PlasmaSDO™ License
 * 
 * This is a community release of PlasmaSDO™, a dual-license 
 * Service Data Object (SDO) 2.1 implementation. 
 * This particular copy of the software is released under the 
 * version 2 of the GNU General Public License. PlasmaSDO™ was developed by 
 * TerraMeta Software, Inc.
 * 
 * Copyright (c) 2013, TerraMeta Software, Inc. All rights reserved.
 * 
 * General License information can be found below.
 * 
 * This distribution may include materials developed by third
 * parties. For license and attribution notices for these
 * materials, please refer to the documentation that accompanies
 * this distribution (see the "Licenses for Third-Party Components"
 * appendix) or view the online documentation at 
 * <http://plasma-sdo.org/licenses/>.
 *  
 */
package org.plasma.text.lang3gl.java;

import org.plasma.text.lang3gl.ClassFactory;
import org.plasma.text.lang3gl.EnumerationFactory;
import org.plasma.text.lang3gl.InterfaceFactory;
import org.plasma.text.lang3gl.Lang3GLContext;
import org.plasma.text.lang3gl.Lang3GLFactory;

public class SDOFactory implements Lang3GLFactory {
	
	private Lang3GLContext context;
	
	public SDOFactory(Lang3GLContext context) {
		this.context = context;
	}

	public ClassFactory getClassFactory() {
		return new SDOClassFactory(this.context);
	}

	public EnumerationFactory getEnumerationFactory() {
		return new SDOEnumerationFactory(this.context);
	}

	public InterfaceFactory getInterfaceFactory() {
		return new SDOInterfaceFactory(this.context);
	}

}
