/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.provisioning.cli;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import javax.xml.bind.JAXBException;
import joptsimple.BuiltinHelpFormatter;
import joptsimple.HelpFormatter;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom2.output.Format;
import org.modeldriven.fuml.Fuml;
import org.modeldriven.fuml.io.ResourceArtifact;
import org.plasma.common.bind.BindingValidationEventHandler;
import org.plasma.common.bind.DefaultValidationEventHandler;
import org.plasma.config.Artifact;
import org.plasma.config.EnumSource;
import org.plasma.config.ImplementationProvisioning;
import org.plasma.config.InterfaceProvisioning;
import org.plasma.config.NamespaceProvisioning;
import org.plasma.config.PlasmaConfig;
import org.plasma.config.PropertyNameStyle;
import org.plasma.config.QueryDSLProvisioning;
import org.plasma.metamodel.Model;
import org.plasma.metamodel.Package;
import org.plasma.provisioning.AnnotationMetamodelAssembler;
import org.plasma.provisioning.MetamodelDataBinding;
import org.plasma.provisioning.adapter.ModelAdapter;
import org.plasma.provisioning.cli.UMLPlatform;
import org.plasma.provisioning.common.NamespaceUtils;
import org.plasma.xml.uml.MDModelAssembler;
import org.plasma.xml.uml.PapyrusModelAssembler;
import org.plasma.xml.uml.UMLModelAssembler;
import org.xml.sax.SAXException;

public abstract class ProvisioningTool {
    private static Log log = LogFactory.getLog(ProvisioningTool.class);

    protected static void printUsage(OptionParser parser, Log theLog) throws IOException {
        BuiltinHelpFormatter helpFormat = new BuiltinHelpFormatter(640, 1);
        parser.formatHelpWith((HelpFormatter)helpFormat);
        ByteArrayOutputStream helpOs = new ByteArrayOutputStream();
        parser.printHelpOn((OutputStream)helpOs);
        theLog.info((Object)("\n" + new String(helpOs.toByteArray())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Model validateStagingModel(File source) throws JAXBException, SAXException, IOException {
        FileInputStream is = new FileInputStream(source);
        MetamodelDataBinding binding = new MetamodelDataBinding((BindingValidationEventHandler)new DefaultValidationEventHandler());
        Model model = null;
        try {
            model = (Model)binding.validate(is);
        }
        finally {
            is.close();
        }
        ModelAdapter validator = new ModelAdapter(model);
        return model;
    }

    protected static boolean regenerate(long lastExecution) {
        boolean stale = false;
        if (PlasmaConfig.getInstance().getConfigFileLastModifiedDate() > lastExecution) {
            stale = true;
            log.debug((Object)("detected stale configuration file '" + PlasmaConfig.getInstance().getConfigFileName() + "' against time: " + String.valueOf(lastExecution)));
        }
        if (!stale) {
            for (Artifact artifact : PlasmaConfig.getInstance().getRepository().getArtifacts()) {
                URL url = PlasmaConfig.class.getResource(artifact.getUrn());
                if (url == null) {
                    url = PlasmaConfig.class.getClassLoader().getResource(artifact.getUrn());
                }
                log.debug((Object)("checking modified state of repository artifact '" + url.getFile() + "' against time: " + String.valueOf(lastExecution)));
                File urlFile = new File(url.getFile());
                if (!urlFile.exists() || urlFile.lastModified() <= lastExecution) continue;
                stale = true;
                log.debug((Object)("detected stale repository artifact '" + url.getFile() + "' against time: " + String.valueOf(lastExecution)));
                break;
            }
        }
        if (!stale) {
            // empty if block
        }
        return stale;
    }

    protected static void loadAnnotationModel(AnnotationMetamodelAssembler annotationAssembler, File destDir, OptionSet options, OptionSpecBuilder silentOpt) throws JAXBException, SAXException, IOException {
        ModelAdapter annotationModelAdapter;
        if (log.isDebugEnabled()) {
            MetamodelDataBinding binding = new MetamodelDataBinding((BindingValidationEventHandler)new DefaultValidationEventHandler());
            String xml = binding.marshal(annotationAssembler.getModel());
            File outFile = new File(destDir, "derived-technical-model.xml");
            FileOutputStream stream = new FileOutputStream(outFile);
            stream.write(xml.getBytes());
            stream.flush();
            stream.close();
            if (!options.has((OptionSpec)silentOpt)) {
                log.debug((Object)("wrote derived model file to: " + outFile.getAbsoluteFile()));
            }
        }
        if (ProvisioningTool.configHasAllNamespaces((annotationModelAdapter = new ModelAdapter(annotationAssembler.getModel())).getLeafPackages())) {
            return;
        }
        String targetNamespaceUri = annotationModelAdapter.getModel().getUri();
        for (Package pkg : annotationModelAdapter.getLeafPackages()) {
            ProvisioningTool.configureNamespace(pkg, targetNamespaceUri);
        }
        UMLModelAssembler umlAssembler = null;
        UMLPlatform platform = UMLPlatform.magicdraw;
        switch (platform) {
            case papyrus: {
                umlAssembler = new PapyrusModelAssembler(annotationModelAdapter.getModel(), targetNamespaceUri, "tns");
                break;
            }
            case magicdraw: {
                umlAssembler = new MDModelAssembler(annotationModelAdapter.getModel(), targetNamespaceUri, "tns");
            }
        }
        umlAssembler.setDerivePackageNamesFromURIs(false);
        String xmi = umlAssembler.getContent(Format.getPrettyFormat());
        if (log.isDebugEnabled()) {
            File xmiDebugFile = new File(destDir, annotationModelAdapter.getModel().getId() + ".uml");
            if (!options.has((OptionSpec)silentOpt)) {
                log.debug((Object)("Writing UML/XMI to: " + xmiDebugFile.getAbsolutePath()));
            }
            try {
                FileOutputStream os = new FileOutputStream(xmiDebugFile);
                umlAssembler.getContent(os, Format.getPrettyFormat());
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        ByteArrayInputStream fumlStream = new ByteArrayInputStream(xmi.getBytes());
        if (log.isDebugEnabled() && !options.has((OptionSpec)silentOpt)) {
            log.debug((Object)"loading UML/XMI model");
        }
        Fuml.load((ResourceArtifact)new ResourceArtifact(targetNamespaceUri, targetNamespaceUri, (InputStream)fumlStream));
    }

    private static boolean configHasAllNamespaces(List<Package> packages) {
        boolean result = true;
        for (Package pkg : packages) {
            if (PlasmaConfig.getInstance().hasSDONamespace(pkg.getUri())) continue;
            result = false;
            break;
        }
        return result;
    }

    private static void configureNamespace(Package pkg, String targetNamespaceUri) {
        if (PlasmaConfig.getInstance().hasSDONamespace(pkg.getUri())) {
            return;
        }
        String pkgName = null;
        pkgName = pkg.getNamespaceProvisioning() != null && pkg.getNamespaceProvisioning().getPackageName() != null && pkg.getNamespaceProvisioning().getPackageName().trim().length() > 0 ? pkg.getNamespaceProvisioning().getPackageName().trim() : NamespaceUtils.toPackageName(pkg.getUri());
        NamespaceProvisioning nsProvConfig = new NamespaceProvisioning();
        nsProvConfig.setPackageName(pkgName);
        InterfaceProvisioning itfProv = new InterfaceProvisioning();
        nsProvConfig.setInterface(itfProv);
        itfProv.setPropertyNameStyle(PropertyNameStyle.ENUMS);
        itfProv.setEnumSource(EnumSource.EXTERNAL);
        ImplementationProvisioning implProv = new ImplementationProvisioning();
        nsProvConfig.setImplementation(implProv);
        QueryDSLProvisioning queryDSL = new QueryDSLProvisioning();
        nsProvConfig.setQueryDSL(queryDSL);
        queryDSL.setGenerate(Boolean.valueOf(true));
        PlasmaConfig.getInstance().addDynamicSDONamespace(pkg.getUri(), targetNamespaceUri, nsProvConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeContent(InputStream is, OutputStream os) throws IOException {
        byte[] buf = new byte[4000];
        int len = -1;
        try {
            while ((len = is.read(buf)) != -1) {
                os.write(buf, 0, len);
            }
        }
        finally {
            is.close();
            os.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readContent(InputStream is) throws IOException {
        byte[] result;
        byte[] buf = new byte[4000];
        ByteArrayOutputStream os = new ByteArrayOutputStream(buf.length);
        int len = -1;
        try {
            while ((len = is.read(buf, 0, buf.length)) != -1) {
                os.write(buf, 0, len);
            }
            result = os.toByteArray();
        }
        finally {
            is.close();
            os.flush();
            os.close();
        }
        return result;
    }
}

