/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.provisioning.cli;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.xml.bind.JAXBException;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.common.bind.BindingValidationEventHandler;
import org.plasma.common.bind.DefaultValidationEventHandler;
import org.plasma.config.PlasmaConfig;
import org.plasma.provisioning.AnnotationMetamodelAssembler;
import org.plasma.provisioning.MetamodelAssembler;
import org.plasma.provisioning.MetamodelDataBinding;
import org.plasma.provisioning.ProvisioningException;
import org.plasma.provisioning.adapter.ModelAdapter;
import org.plasma.provisioning.cli.ProvisioningTool;
import org.plasma.provisioning.cli.ProvisioningToolOption;
import org.plasma.provisioning.cli.SDOToolAction;
import org.plasma.text.lang3gl.DefaultLang3GLContext;
import org.plasma.text.lang3gl.Lang3GLDialect;
import org.plasma.text.lang3gl.Lang3GLOperation;
import org.plasma.text.lang3gl.java.SDOAssembler;
import org.plasma.text.lang3gl.java.SDOFactory;
import org.xml.sax.SAXException;

public class SDOTool
extends ProvisioningTool {
    private static Log log = LogFactory.getLog(SDOTool.class);

    public static void main(String[] args) throws JAXBException, SAXException, IOException {
        OptionParser parser = new OptionParser();
        OptionSpecBuilder verboseOpt = parser.accepts(ProvisioningToolOption.verbose.name(), ProvisioningToolOption.verbose.getDescription());
        OptionSpecBuilder silentOpt = parser.accepts(ProvisioningToolOption.silent.name(), ProvisioningToolOption.silent.getDescription());
        OptionSpecBuilder helpOpt = parser.accepts(ProvisioningToolOption.help.name(), ProvisioningToolOption.help.getDescription());
        OptionSpecBuilder commandOpt = parser.accepts(ProvisioningToolOption.command.name(), ProvisioningToolOption.command.getDescription() + " - one of [" + SDOToolAction.asString() + "] is expected");
        commandOpt.withRequiredArg().ofType(SDOToolAction.class);
        ArgumentAcceptingOptionSpec lastExecutionOpt = parser.accepts(ProvisioningToolOption.lastExecution.name(), ProvisioningToolOption.lastExecution.getDescription()).withRequiredArg().ofType(Long.class);
        ArgumentAcceptingOptionSpec destOpt = parser.accepts(ProvisioningToolOption.dest.name(), ProvisioningToolOption.dest.getDescription()).withOptionalArg().ofType(File.class);
        OptionSet options = parser.parse(args);
        if (options.has((OptionSpec)helpOpt)) {
            SDOTool.printUsage(parser, log);
            return;
        }
        if (!options.has(ProvisioningToolOption.command.name())) {
            if (!options.has((OptionSpec)silentOpt)) {
                SDOTool.printUsage(parser, log);
            }
            throw new IllegalArgumentException("expected option '" + ProvisioningToolOption.command.name() + "'");
        }
        SDOToolAction command = (SDOToolAction)options.valueOf(ProvisioningToolOption.command.name());
        Lang3GLDialect dialect = Lang3GLDialect.java;
        MetamodelAssembler modelAssembler = null;
        File destDir = new File("./target/");
        if (options.has((OptionSpec)destOpt)) {
            destDir = (File)destOpt.value(options);
        }
        if (!destDir.exists()) {
            if (!options.has((OptionSpec)silentOpt)) {
                log.debug((Object)("given destination dir '" + destDir.getName() + "' does not exist"));
            }
            if (!destDir.mkdirs()) {
                throw new IllegalArgumentException("given destination dir '" + destDir.getName() + "' could not be created");
            }
        }
        switch (command) {
            case export: {
                AnnotationMetamodelAssembler annotationAssembler;
                File destFile = new File(destDir, "technical-model.xml");
                if (options.has((OptionSpec)destOpt)) {
                    destFile = (File)destOpt.value(options);
                }
                if (destFile.getParentFile() == null || !destFile.getParentFile().exists()) {
                    log.info((Object)("given destination directory '" + destFile.getParentFile().getAbsolutePath() + "' does not exist, creating"));
                    if (!destFile.getParentFile().mkdirs()) {
                        throw new IllegalArgumentException("given destination directory '" + destFile.getParentFile() + "' could not be created");
                    }
                }
                if (destFile.isDirectory()) {
                    destFile = new File(destFile, "technical-model.xml");
                }
                if (!options.has((OptionSpec)silentOpt)) {
                    log.info((Object)("dest: " + destFile.getAbsoluteFile()));
                }
                if ((annotationAssembler = new AnnotationMetamodelAssembler()).hasAnnotatedClasses()) {
                    SDOTool.loadAnnotationModel(annotationAssembler, destDir, options, silentOpt);
                }
                modelAssembler = new MetamodelAssembler();
                MetamodelDataBinding binding = new MetamodelDataBinding((BindingValidationEventHandler)new DefaultValidationEventHandler());
                String xml = binding.marshal(modelAssembler.getModel());
                FileOutputStream stream = new FileOutputStream(destFile);
                stream.write(xml.getBytes());
                stream.flush();
                stream.close();
                SDOTool.validateStagingModel(destFile);
                if (options.has((OptionSpec)silentOpt)) break;
                log.info((Object)("wrote merged model file to: " + destFile.getAbsoluteFile()));
                break;
            }
            case create: {
                Lang3GLOperation operation = Lang3GLOperation.valueOf(command.name());
                if (!options.has((OptionSpec)silentOpt)) {
                    log.debug((Object)("dest: " + destDir.getName()));
                }
                long lastExecution = 0L;
                if (options.has((OptionSpec)lastExecutionOpt)) {
                    lastExecution = (Long)lastExecutionOpt.value(options);
                }
                if (!SDOTool.regenerate(lastExecution)) {
                    if (!options.has((OptionSpec)silentOpt)) {
                        log.info((Object)"skipping SDO creation - no stale artifacts detected");
                    }
                    return;
                }
                int configuredNamespaceCount = PlasmaConfig.getInstance().getSDONamespaceCount();
                AnnotationMetamodelAssembler annotationAssembler = new AnnotationMetamodelAssembler();
                if (annotationAssembler.hasAnnotatedClasses()) {
                    SDOTool.loadAnnotationModel(annotationAssembler, destDir, options, silentOpt);
                }
                ModelAdapter validator = null;
                MetamodelDataBinding binding = new MetamodelDataBinding((BindingValidationEventHandler)new DefaultValidationEventHandler());
                modelAssembler = new MetamodelAssembler();
                String xml = binding.marshal(modelAssembler.getModel());
                if (log.isDebugEnabled()) {
                    File outFile = new File(destDir, "technical-model.xml");
                    FileOutputStream stream = new FileOutputStream(outFile);
                    stream.write(xml.getBytes());
                    stream.flush();
                    stream.close();
                    if (!options.has((OptionSpec)silentOpt)) {
                        log.debug((Object)("wrote merged model file to: " + outFile.getAbsoluteFile()));
                    }
                }
                validator = new ModelAdapter(modelAssembler.getModel());
                DefaultLang3GLContext factoryContext = new DefaultLang3GLContext(validator);
                SDOFactory factory = null;
                switch (dialect) {
                    case java: {
                        factory = new SDOFactory(factoryContext);
                        break;
                    }
                    default: {
                        throw new ProvisioningException("unknown 3GL language dialect, '" + dialect.name() + "'");
                    }
                }
                SDOAssembler assembler = new SDOAssembler(validator, factory, operation, destDir);
                assembler.start();
                if (options.has((OptionSpec)silentOpt)) break;
                log.info((Object)("generated " + assembler.getResultInterfacesCount() + " interfaces to output to directory: " + destDir.getAbsolutePath()));
                log.info((Object)("generated " + assembler.getResultClassesCount() + " classes to output to directory: " + destDir.getAbsolutePath()));
                log.info((Object)("generated " + assembler.getResultEnumerationsCount() + " enumerations to output to directory: " + destDir.getAbsolutePath()));
                break;
            }
            default: {
                throw new ProvisioningException("unknown command '" + command.toString() + "'");
            }
        }
    }
}

