/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.provisioning.rdb;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.utils.XMLChar;
import org.plasma.metamodel.Class;
import org.plasma.metamodel.Enumeration;
import org.plasma.metamodel.Model;
import org.plasma.metamodel.Property;
import org.plasma.sdo.access.client.JDBCPojoDataAccessClient;

public class ConverterSupport {
    private static Log log = LogFactory.getLog(ConverterSupport.class);
    protected String[] schemaNames;
    protected String[] namespaces;
    protected Model model;
    protected Map<String, Class> classQualifiedNameMap = new HashMap<String, Class>();
    protected Map<String, Enumeration> enumQualifiedNameMap = new HashMap<String, Enumeration>();
    protected Map<String, Property> propertyQualifiedPriKeyConstrainatNameMap = new HashMap<String, Property>();
    protected Map<Class, Map<String, Property>> classPropertyMap = new HashMap<Class, Map<String, Property>>();
    protected JDBCPojoDataAccessClient client = new JDBCPojoDataAccessClient();

    protected String filter(String src) {
        Pattern INVALID_XML_CHARS = Pattern.compile("[\\\\u0]");
        String preCleaned = INVALID_XML_CHARS.matcher(src).replaceAll("");
        char[] chars = preCleaned.toCharArray();
        char[] result = new char[chars.length];
        int i = 0;
        for (char ch : chars) {
            if (XMLChar.isValid((int)ch) && (Character.isDigit(ch) || Character.isLetter(ch) || Character.isWhitespace(ch) || ConverterSupport.isPunctuation(ch) || ConverterSupport.isOtherAllowed(ch))) {
                result[i] = ch;
                ++i;
                continue;
            }
            log.debug((Object)("stripped/ignored illegal XMl character " + ch));
        }
        return new String(result, 0, i);
    }

    protected static boolean isPunctuation(char c) {
        return c == ',' || c == '.' || c == '!' || c == '?' || c == ':' || c == ';';
    }

    protected static boolean isOtherAllowed(char c) {
        return c == '\'' || c == '\"' || c == '@' || c == '#' || c == '$' || c == '%' || c == '*' || c == '&' || c == '(' || c == ')' || c == '-' || c == '+';
    }
}

