/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.provisioning.xsd;

import java.util.HashMap;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.dom.ElementNSImpl;
import org.plasma.metamodel.Alias;
import org.plasma.metamodel.Documentation;
import org.plasma.metamodel.DocumentationType;
import org.plasma.metamodel.Enumeration;
import org.plasma.metamodel.EnumerationLiteral;
import org.plasma.provisioning.xsd.AbstractAssembler;
import org.plasma.provisioning.xsd.ConverterSupport;
import org.plasma.xml.schema.AbstractSimpleType;
import org.plasma.xml.schema.Annotated;
import org.plasma.xml.schema.Restriction;
import org.plasma.xml.schema.SimpleType;

public class EnumerationAssembler
extends AbstractAssembler {
    private static Log log = LogFactory.getLog(EnumerationAssembler.class);

    public EnumerationAssembler(ConverterSupport converterSupport, String destNamespaceURI, String destNamespacePrefix) {
        super(destNamespaceURI, destNamespacePrefix, converterSupport);
    }

    public Enumeration buildEnumeration(AbstractSimpleType simpleType, AbstractSimpleType source) {
        String name = simpleType.getName();
        if (name == null) {
            name = source.getName();
        }
        return this.buildEnumeration(simpleType, name);
    }

    public Enumeration buildEnumeration(SimpleType simpleType) {
        return this.buildEnumeration((AbstractSimpleType)simpleType, simpleType.getName());
    }

    public Enumeration buildEnumeration(AbstractSimpleType simpleType, String name) {
        Enumeration enm = new Enumeration();
        enm.setId(UUID.randomUUID().toString());
        Alias alias = new Alias();
        enm.setAlias(alias);
        alias.setLocalName(name);
        String logicalName = this.formatLocalClassName(name);
        enm.setName(logicalName);
        enm.setUri(this.destNamespaceURI);
        Documentation documentation = this.createDocumentation(DocumentationType.DEFINITION, this.getDocumentationContent((Annotated)simpleType));
        enm.getDocumentations().add(documentation);
        HashMap<String, EnumerationLiteral> literalMap = new HashMap<String, EnumerationLiteral>();
        Restriction restriction = simpleType.getRestriction();
        if (restriction.getMinExclusivesAndMinInclusivesAndMaxExclusives().size() == 0) {
            throw new IllegalStateException("expected collection values");
        }
        for (Object obj : restriction.getMinExclusivesAndMinInclusivesAndMaxExclusives()) {
            if (obj instanceof org.plasma.xml.schema.Enumeration) {
                org.plasma.xml.schema.Enumeration schemaEnum = (org.plasma.xml.schema.Enumeration)obj;
                EnumerationLiteral literal = new EnumerationLiteral();
                enm.getEnumerationLiterals().add(literal);
                String literalName = schemaEnum.getValue();
                literalName = this.support.buildLogicalEnumerationLiteralName(enm, literalName, literalMap);
                literalMap.put(literalName, literal);
                literal.setName(literalName);
                literal.setId(UUID.randomUUID().toString());
                alias = new Alias();
                literal.setAlias(alias);
                alias.setPhysicalName(literalName);
                String value = this.findAppInfoValue(schemaEnum);
                if (value == null) {
                    value = literalName;
                }
                literal.setValue(value);
                this.buildEnumerationLiteralDocumentation(schemaEnum, literal);
                continue;
            }
            log.warn((Object)("unexpected Restriction child class, " + obj.getClass().getName()));
        }
        return enm;
    }

    public void buildEnumerationLiteralDocumentation(org.plasma.xml.schema.Enumeration schemaEnum, EnumerationLiteral literal) {
        if (schemaEnum.getAnnotation() != null) {
            for (Object o2 : schemaEnum.getAnnotation().getAppinfosAndDocumentations()) {
                if (o2 instanceof org.plasma.xml.schema.Documentation) {
                    org.plasma.xml.schema.Documentation doc = (org.plasma.xml.schema.Documentation)o2;
                    if (doc.getContent() == null || doc.getContent().size() <= 0) continue;
                    for (Object content : doc.getContent()) {
                        Documentation documentation;
                        if (content instanceof String) {
                            documentation = this.createDocumentation(DocumentationType.DEFINITION, (String)content);
                            literal.getDocumentations().add(documentation);
                            continue;
                        }
                        if (content instanceof ElementNSImpl) {
                            ElementNSImpl nsElem = (ElementNSImpl)content;
                            Documentation documentation2 = this.createDocumentation(DocumentationType.DEFINITION, this.serializeElement(nsElem));
                            literal.getDocumentations().add(documentation2);
                            continue;
                        }
                        documentation = this.createDocumentation(DocumentationType.DEFINITION, content.toString());
                        literal.getDocumentations().add(documentation);
                    }
                    continue;
                }
                log.warn((Object)("unexpected Enumeration child class, " + o2.getClass().getName()));
            }
        }
    }
}

