/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.query.dsl;

import commonj.sdo.Type;
import org.plasma.query.Expression;
import org.plasma.query.PathProperty;
import org.plasma.query.QueryException;
import org.plasma.query.Wildcard;
import org.plasma.query.dsl.DomainObject;
import org.plasma.query.dsl.WildcardNode;
import org.plasma.query.model.GroupOperator;
import org.plasma.query.model.GroupOperatorValues;
import org.plasma.query.model.Path;
import org.plasma.query.model.Property;
import org.plasma.query.model.Term;
import org.plasma.query.model.WildcardPropertyTypeValues;

public class PathNode
extends DomainObject
implements PathProperty {
    protected Type type;
    protected boolean isRoot;
    protected Expression expr;

    protected PathNode(Type type) {
        super(null, null);
        this.type = type;
    }

    protected PathNode(PathNode source, String sourceProperty) {
        super(source, sourceProperty);
    }

    protected PathNode(PathNode source, String sourceProperty, Expression expr) {
        this(source, sourceProperty);
        this.expr = expr;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    protected PathNode getSource() {
        return this.source;
    }

    protected String getSourceProperty() {
        return this.sourceProperty;
    }

    Expression getPredicate() {
        return this.expr;
    }

    public Wildcard wildcard() {
        return new WildcardNode(this, "*", WildcardPropertyTypeValues.DATA);
    }

    public Wildcard dataWildcard() {
        return new WildcardNode(this, "*", WildcardPropertyTypeValues.DATA);
    }

    public Wildcard referenceWildcard() {
        return new WildcardNode(this, "*", WildcardPropertyTypeValues.REFERENCE);
    }

    public Wildcard subclassDataWildcard() {
        return new WildcardNode(this, "*", WildcardPropertyTypeValues.SUBCLASS___DATA);
    }

    public Expression group(Expression source) {
        org.plasma.query.model.Expression root = (org.plasma.query.model.Expression)source;
        while (root.getParent() != null) {
            root = root.getParent();
        }
        root.getTerms().add(0, new Term(new GroupOperator(GroupOperatorValues.RP_1)));
        root.getTerms().add(new Term(new GroupOperator(GroupOperatorValues.LP_1)));
        return root;
    }

    @Override
    public Expression isNotNull() {
        return this.createProperty().isNotNull();
    }

    @Override
    public Expression isNull() {
        return this.createProperty().isNull();
    }

    private Property createProperty() {
        Property modelProperty = null;
        if (this.source != null) {
            String[] path = this.getPath();
            modelProperty = path != null && path.length > 0 ? new Property(this.sourceProperty, new Path(path)) : new Property(this.sourceProperty);
        } else {
            throw new QueryException("expected path");
        }
        return modelProperty;
    }
}

