/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.access.provider.common;

import commonj.sdo.Property;
import commonj.sdo.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.plasma.config.DataAccessProviderName;
import org.plasma.config.PlasmaConfig;
import org.plasma.sdo.access.DataAccessException;
import org.plasma.sdo.helper.PlasmaTypeHelper;

public class TraversalMap {
    public static String DELIM_PATH = "/";
    public static String WILDCARD = "*";
    private Map<String, String[]> map = new HashMap<String, String[]>();
    private DataAccessProviderName dataAccessProviderName;

    public TraversalMap(DataAccessProviderName providerName) {
        this.dataAccessProviderName = providerName;
    }

    public Iterator<String> iterator() {
        return this.map.keySet().iterator();
    }

    public int calculateDepth() {
        int depth = 0;
        Iterator<String> iter = this.map.keySet().iterator();
        while (iter.hasNext()) {
            String[] path = iter.next().split(DELIM_PATH);
            if (path == null || path.length <= depth) continue;
            depth = path.length;
        }
        return depth;
    }

    public int count(String key) {
        String[] values = this.get(key);
        if (values != null) {
            return values.length;
        }
        return 0;
    }

    public void add(String key, String[] values) {
        String[] oldValues = this.map.get(key);
        if (oldValues == null) {
            this.map.put(key, values);
        } else {
            int newCount = 0;
            String[] newValues = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                boolean found = false;
                for (int j = 0; j < oldValues.length; ++j) {
                    if (!oldValues[j].equals(values[i])) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                newValues[newCount] = values[i];
                ++newCount;
            }
            String[] mergedValues = new String[oldValues.length + newCount];
            System.arraycopy(oldValues, 0, mergedValues, 0, oldValues.length);
            System.arraycopy(newValues, 0, mergedValues, oldValues.length, newCount);
            this.map.put(key, mergedValues);
        }
    }

    public void add(String key, String value) {
        String[] values = this.map.get(key);
        if (values == null) {
            values = new String[]{value};
            this.map.put(key, values);
        } else {
            for (int i = 0; i < values.length; ++i) {
                if (!values[i].equals(value)) continue;
                return;
            }
            String[] oldValues = values;
            values = new String[oldValues.length + 1];
            System.arraycopy(oldValues, 0, values, 0, oldValues.length);
            values[values.length - 1] = value;
            this.map.put(key, values);
        }
    }

    public String[] get(String key) {
        return this.map.get(key);
    }

    public String[] asFieldArray() {
        ArrayList<String> list = new ArrayList<String>();
        for (String key : this.map.keySet()) {
            if (key.startsWith(DELIM_PATH)) continue;
            String[] values = this.map.get(key);
            for (int i = 0; i < values.length; ++i) {
                list.add(key + "." + "" + values[i]);
            }
        }
        String[] result = new String[list.size()];
        list.toArray(result);
        return result;
    }

    public Map<Object, String[]> toClassMap() {
        HashMap<Object, String[]> classMap = new HashMap<Object, String[]>();
        Iterator<String> iter = this.map.keySet().iterator();
        try {
            while (iter.hasNext()) {
                String key = iter.next();
                if (key.startsWith(DELIM_PATH)) continue;
                String[] tokens = key.split("#");
                Type type = PlasmaTypeHelper.INSTANCE.getType(tokens[0], tokens[1]);
                String pkgName = PlasmaConfig.getInstance().getProvisioningByNamespaceURI(this.dataAccessProviderName, type.getURI()).getPackageName();
                String[] values = this.map.get(key);
                String[] fieldValues = new String[values.length];
                for (int i = 0; i < values.length; ++i) {
                    Property property = type.getProperty(values[i]);
                    fieldValues[i] = property.isMany() ? "" + values[i] + "" : "" + values[i];
                }
                classMap.put(Class.forName(pkgName + "." + tokens[1]), fieldValues);
            }
        }
        catch (ClassNotFoundException e) {
            throw new DataAccessException(e);
        }
        return classMap;
    }

    public String dump() {
        StringBuffer buf = new StringBuffer();
        for (String key : this.map.keySet()) {
            buf.append("\n\t");
            buf.append(key + "[");
            String[] values = this.get(key);
            for (int i = 0; i < values.length; ++i) {
                if (i > 0) {
                    buf.append(",");
                }
                buf.append(values[i]);
            }
            buf.append("]");
        }
        return buf.toString();
    }
}

