/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.core;

import commonj.sdo.Property;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.plasma.sdo.access.provider.common.PropertyPair;

public class SnapshotMap
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<UUID, List<PropertyPair>> values = new HashMap<UUID, List<PropertyPair>>();
    private Timestamp snapshotDate;
    private Long snapshotNannoTime;

    public SnapshotMap() {
        this.snapshotDate = new Timestamp(new Date().getTime());
        this.snapshotNannoTime = System.nanoTime();
    }

    public SnapshotMap(Timestamp snapshotDate) {
        this.snapshotDate = snapshotDate;
        this.snapshotNannoTime = System.nanoTime();
    }

    public Timestamp getSnapshotDate() {
        return this.snapshotDate;
    }

    public Long getSnapshotNannoTime() {
        return this.snapshotNannoTime;
    }

    public UUID[] getKeys() {
        Set<UUID> keys = this.values.keySet();
        UUID[] result = new UUID[keys.size()];
        keys.toArray(result);
        return result;
    }

    public void put(UUID key, PropertyPair value) {
        List<PropertyPair> list = this.values.get(key);
        if (list == null) {
            list = new ArrayList<PropertyPair>();
            this.values.put(key, list);
        }
        list.add(value);
    }

    public List<PropertyPair> get(UUID key) {
        return this.values.get(key);
    }

    public PropertyPair get(UUID key, Property prop) {
        List<PropertyPair> list = this.values.get(key);
        if (list != null) {
            for (PropertyPair pair : list) {
                if (!pair.getProp().getName().equals(prop.getName())) continue;
                return pair;
            }
        }
        return null;
    }

    public List<PropertyPair> remove(UUID key) {
        return this.values.remove(key);
    }
}

