/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.helper;

import commonj.sdo.DataObject;
import commonj.sdo.Type;
import commonj.sdo.helper.DataFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.common.exception.PlasmaRuntimeException;
import org.plasma.config.Namespace;
import org.plasma.config.PlasmaConfig;
import org.plasma.sdo.PlasmaDataGraph;
import org.plasma.sdo.core.CoreDataGraph;
import org.plasma.sdo.core.CoreDataObject;
import org.plasma.sdo.helper.PlasmaTypeHelper;

public class PlasmaDataFactory
implements DataFactory {
    private static Log log = LogFactory.getLog(PlasmaDataFactory.class);
    public static volatile PlasmaDataFactory INSTANCE = PlasmaDataFactory.initializeInstance();
    private Map<String, Class<?>> interfaceImplClassMap = new HashMap();

    private PlasmaDataFactory() {
    }

    public static PlasmaDataFactory instance() {
        if (INSTANCE == null) {
            PlasmaDataFactory.initializeInstance();
        }
        return INSTANCE;
    }

    private static synchronized PlasmaDataFactory initializeInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PlasmaDataFactory();
        }
        return INSTANCE;
    }

    public PlasmaDataGraph createDataGraph() {
        return new CoreDataGraph();
    }

    public DataObject create(String uri, String typeName) {
        Type type = PlasmaTypeHelper.INSTANCE.getType(uri, typeName);
        String packageName = PlasmaConfig.getInstance().getSDOImplementationPackageName(uri);
        if (packageName != null) {
            return this.create(type);
        }
        return new CoreDataObject(type);
    }

    public DataObject create(Type type) {
        if (type.isAbstract()) {
            throw new IllegalArgumentException("attempt to create an abstract type '" + type.getURI() + "#" + type.getName() + "'");
        }
        if (type.isDataType()) {
            throw new IllegalArgumentException("attempt to create a type which is a datatype '" + type.getURI() + "#" + type.getName() + "'");
        }
        String qualifiedName = this.createPackageQualifiedClassName(type);
        Class<Object> interfaceImplClass = this.interfaceImplClassMap.get(qualifiedName);
        if (interfaceImplClass == null) {
            try {
                interfaceImplClass = Class.forName(qualifiedName);
            }
            catch (ClassNotFoundException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("no interface class found for qualified name '" + qualifiedName + "' - using generic DataObject"));
                }
                interfaceImplClass = CoreDataObject.class;
            }
            this.interfaceImplClassMap.put(qualifiedName, interfaceImplClass);
        }
        return this.create(interfaceImplClass, type);
    }

    private String createPackageQualifiedClassName(Type type) {
        String packageName = PlasmaConfig.getInstance().getSDOImplementationPackageName(type.getURI());
        String className = PlasmaConfig.getInstance().getSDOImplementationClassName(type.getURI(), type.getName());
        String qualifiedName = packageName + "." + className;
        return qualifiedName;
    }

    public DataObject create(Class interfaceClass) {
        CoreDataObject result = null;
        Namespace sdoNamespace = PlasmaConfig.getInstance().getSDONamespaceByInterfacePackage(interfaceClass.getPackage().getName());
        String packageName = PlasmaConfig.getInstance().getSDOImplementationPackageName(sdoNamespace.getUri());
        String className = PlasmaConfig.getInstance().getSDOImplementationClassName(sdoNamespace.getUri(), interfaceClass.getSimpleName());
        String qualifiedName = packageName + "." + className;
        Class[] types = new Class[]{};
        Object[] args = new Object[]{};
        try {
            Class<?> interfaceImplClass = this.interfaceImplClassMap.get(qualifiedName);
            if (interfaceImplClass == null) {
                interfaceImplClass = Class.forName(qualifiedName);
                this.interfaceImplClassMap.put(qualifiedName, interfaceImplClass);
                log.warn((Object)("cache miss: " + interfaceImplClass.getName()));
            }
            result = this.create(interfaceImplClass, types, args);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    private DataObject create(Class<?> interfaceClass, Type type) {
        Class[] types = new Class[]{Type.class};
        Object[] args = new Object[]{type};
        CoreDataObject result = this.create(interfaceClass, types, args);
        return result;
    }

    private DataObject create(Class<?> interfaceClass, Type type, UUID uuid) {
        Class[] types = new Class[]{Type.class, UUID.class};
        Object[] args = new Object[]{type, uuid};
        CoreDataObject result = this.create(interfaceClass, types, args);
        return result;
    }

    private CoreDataObject create(Class<?> interfaceClass, Class<?>[] types, Object[] args) {
        CoreDataObject result = null;
        try {
            Constructor<?> constructor = interfaceClass.getConstructor(types);
            result = (CoreDataObject)constructor.newInstance(args);
        }
        catch (SecurityException e) {
            throw new PlasmaRuntimeException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new PlasmaRuntimeException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new PlasmaRuntimeException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new PlasmaRuntimeException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new PlasmaRuntimeException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new PlasmaRuntimeException((Throwable)e);
        }
        return result;
    }
}

