/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.helper;

import commonj.sdo.Property;
import commonj.sdo.Type;
import commonj.sdo.helper.DataHelper;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import org.plasma.sdo.helper.DataConverter;

public class PlasmaDataHelper
implements DataHelper {
    public static volatile DataHelper INSTANCE = PlasmaDataHelper.initializeInstance();

    private PlasmaDataHelper() {
    }

    private static DataHelper initializeInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PlasmaDataHelper();
        }
        return INSTANCE;
    }

    public Object convert(Type type, Object value) {
        return DataConverter.INSTANCE.convert(type, value);
    }

    public Object convert(Property property, Object value) {
        return DataConverter.INSTANCE.convert(property.getType(), value);
    }

    public Calendar toCalendar(String dateString) {
        if (dateString == null) {
            return null;
        }
        Date date = this.toDate(dateString);
        if (date == null) {
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return calendar;
    }

    public Calendar toCalendar(String dateString, Locale locale) {
        if (dateString == null || locale == null) {
            return null;
        }
        Date date = this.toDate(dateString);
        if (date == null) {
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar(locale);
        calendar.setTime(date);
        return calendar;
    }

    public Date toDate(String dateString) {
        if (dateString == null) {
            return null;
        }
        DateFormat[] formats = DataConverter.INSTANCE.getDateFormats();
        for (int i = 0; i < formats.length; ++i) {
            try {
                return formats[i].parse(dateString);
            }
            catch (ParseException parseException) {
                continue;
            }
        }
        return null;
    }

    public String toDateTime(Date date) {
        if (date == null) {
            return null;
        }
        return DataConverter.INSTANCE.getDateTimeFormat().format(date);
    }

    public String toDateTime(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return this.toDateTime(calendar.getTime());
    }

    public String toDay(Date date) {
        if (date == null) {
            return null;
        }
        return DataConverter.INSTANCE.getDayFormat().format(date);
    }

    public String toDay(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return this.toDay(calendar.getTime());
    }

    public String toDuration(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat f = new SimpleDateFormat("'P'yyyy'Y' MM'M' dd'D' 'T' HH'H' mm'M' ss'S.'SSS");
        return f.format(date);
    }

    public String toDuration(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return this.toDuration(calendar.getTime());
    }

    public String toMonth(Date date) {
        if (date == null) {
            return null;
        }
        return DataConverter.INSTANCE.getMonthFormat().format(date);
    }

    public String toMonth(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return this.toMonth(calendar.getTime());
    }

    public String toMonthDay(Date date) {
        if (date == null) {
            return null;
        }
        return DataConverter.INSTANCE.getMonthDayFormat().format(date);
    }

    public String toMonthDay(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return this.toMonthDay(calendar.getTime());
    }

    public String toTime(Date date) {
        if (date == null) {
            return null;
        }
        return DataConverter.INSTANCE.getTimeFormat().format(date);
    }

    public String toTime(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return this.toTime(calendar.getTime());
    }

    public String toYear(Date date) {
        if (date == null) {
            return null;
        }
        return DataConverter.INSTANCE.getYearFormat().format(date);
    }

    public String toYear(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return this.toYear(calendar.getTime());
    }

    public String toYearMonth(Date date) {
        if (date == null) {
            return null;
        }
        return DataConverter.INSTANCE.getYearMonthFormat().format(date);
    }

    public String toYearMonth(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return this.toYearMonth(calendar.getTime());
    }

    public String toYearMonthDay(Date date) {
        if (date == null) {
            return null;
        }
        return DataConverter.INSTANCE.getYearMonthDayFormat().format(date);
    }

    public String toYearMonthDay(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return this.toYearMonthDay(calendar.getTime());
    }
}

