/**
 *         PlasmaSDO™ License
 * 
 * This is a community release of PlasmaSDO™, a dual-license 
 * Service Data Object (SDO) 2.1 implementation. 
 * This particular copy of the software is released under the 
 * version 2 of the GNU General Public License. PlasmaSDO™ was developed by 
 * TerraMeta Software, Inc.
 * 
 * Copyright (c) 2013, TerraMeta Software, Inc. All rights reserved.
 * 
 * General License information can be found below.
 * 
 * This distribution may include materials developed by third
 * parties. For license and attribution notices for these
 * materials, please refer to the documentation that accompanies
 * this distribution (see the "Licenses for Third-Party Components"
 * appendix) or view the online documentation at 
 * <http://plasma-sdo.org/licenses/>.
 *  
 */
package org.plasma.query.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;

import org.plasma.query.visitor.QueryVisitor;


/**
 * <p>Java class for ArithmeticOperator complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="ArithmeticOperator">
 *   &lt;simpleContent>
 *     &lt;extension base="&lt;http://www.terrameta.org/plasma/query>ArithmeticOperatorValues">
 *     &lt;/extension>
 *   &lt;/simpleContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ArithmeticOperator", propOrder = {
    "value"
})
@XmlRootElement(name = "ArithmeticOperator")
public class ArithmeticOperator implements org.plasma.query.Operator {

    @XmlValue
    protected ArithmeticOperatorName value;

    public ArithmeticOperator() {
        super();
    } 
    public ArithmeticOperator(String content) {
        this();
        setValue(ArithmeticOperatorName.valueOf(content));
    } 

    public ArithmeticOperator(ArithmeticOperatorName content) {
        this();
        setValue(content);
    } 
    /**
     * Gets the value of the value property.
     * 
     * @return
     *     possible object is
     *     {@link ArithmeticOperatorName }
     *     
     */
    public ArithmeticOperatorName getValue() {
        return value;
    }

    /**
     * Sets the value of the value property.
     * 
     * @param value
     *     allowed object is
     *     {@link ArithmeticOperatorName }
     *     
     */
    public void setValue(ArithmeticOperatorName value) {
        this.value = value;
    }

    public void accept(QueryVisitor visitor)
    {
        visitor.start(this);
    	visitor.end(this);
    }
}
