/**
 *         PlasmaSDO™ License
 * 
 * This is a community release of PlasmaSDO™, a dual-license 
 * Service Data Object (SDO) 2.1 implementation. 
 * This particular copy of the software is released under the 
 * version 2 of the GNU General Public License. PlasmaSDO™ was developed by 
 * TerraMeta Software, Inc.
 * 
 * Copyright (c) 2013, TerraMeta Software, Inc. All rights reserved.
 * 
 * General License information can be found below.
 * 
 * This distribution may include materials developed by third
 * parties. For license and attribution notices for these
 * materials, please refer to the documentation that accompanies
 * this distribution (see the "Licenses for Third-Party Components"
 * appendix) or view the online documentation at 
 * <http://plasma-sdo.org/licenses/>.
 *  
 */
package org.plasma.query.model;

import javax.xml.bind.annotation.XmlRegistry;




/**
 * This object contains factory methods for each 
 * Java content interface and Java element interface 
 * generated in the org.plasma.query.modelxxx package. 
 * <p>An ObjectFactory allows you to programatically 
 * construct new instances of the Java representation 
 * for XML content. The Java representation of XML 
 * content can consist of schema derived interfaces 
 * and classes representing the binding of schema 
 * type definitions, element declarations and model 
 * groups.  Factory methods for each of these are 
 * provided in this class.
 * 
 */
@XmlRegistry
public class ObjectFactory {


    /**
     * Create a new ObjectFactory that can be used to create new instances of schema derived classes for package: org.plasma.query.modelxxx
     * 
     */
    public ObjectFactory() {
    }

    /**
     * Create an instance of {@link From }
     * 
     */
    public From createFrom() {
        return new From();
    }

    /**
     * Create an instance of {@link ParameterDeclaration }
     * 
     */
    public ParameterDeclaration createParameterDeclaration() {
        return new ParameterDeclaration();
    }

    /**
     * Create an instance of {@link Parameter }
     * 
     */
    public Parameter createParameter() {
        return new Parameter();
    }

    /**
     * Create an instance of {@link Delete }
     * 
     */
    public Delete createDelete() {
        return new Delete();
    }

    /**
     * Create an instance of {@link GroupBy }
     * 
     */
    public GroupBy createGroupBy() {
        return new GroupBy();
    }

    /**
     * Create an instance of {@link Query }
     * 
     */
    public Query createQuery() {
        return new Query();
    }

    /**
     * Create an instance of {@link Path }
     * 
     */
    public Path createPath() {
        return new Path();
    }

    /**
     * Create an instance of {@link PredicateOperator }
     * 
     */
    public PredicateOperator createPredicateOperator() {
        return new PredicateOperator();
    }

    /**
     * Create an instance of {@link DecimalParameter }
     * 
     */
    public DecimalParameter createDecimalParameter() {
        return new DecimalParameter();
    }

    /**
     * Create an instance of {@link CollectionParameter }
     * 
     */
    public CollectionParameter createCollectionParameter() {
        return new CollectionParameter();
    }

    /**
     * Create an instance of {@link Term }
     * 
     */
    public Term createTerm() {
        return new Term();
    }

    /**
     * Create an instance of {@link Projection }
     * 
     */
    public Projection createProjection() {
        return new Projection();
    }

    /**
     * Create an instance of {@link StringParameter }
     * 
     */
    public StringParameter createStringParameter() {
        return new StringParameter();
    }

    /**
     * Create an instance of {@link FloatParameter }
     * 
     */
    public FloatParameter createFloatParameter() {
        return new FloatParameter();
    }

    /**
     * Create an instance of {@link NullLiteral }
     * 
     */
    public NullLiteral createNullLiteral() {
        return new NullLiteral();
    }

    /**
     * Create an instance of {@link LogicalOperator }
     * 
     */
    public LogicalOperator createLogicalOperator() {
        return new LogicalOperator();
    }

    /**
     * Create an instance of {@link Where }
     * 
     */
    public Where createWhere() {
        return new Where();
    }

    /**
     * Create an instance of {@link WildcardProperty }
     * 
     */
    public WildcardProperty createWildcardProperty() {
        return new WildcardProperty();
    }

    /**
     * Create an instance of {@link PathElement }
     * 
     */
    public PathElement createPathElement() {
        return new PathElement();
    }

    /**
     * Create an instance of {@link Select }
     * 
     */
    public Select createSelect() {
        return new Select();
    }

    /**
     * Create an instance of {@link Update }
     * 
     */
    public Update createUpdate() {
        return new Update();
    }

    /**
     * Create an instance of {@link IntParameter }
     * 
     */
    public IntParameter createIntParameter() {
        return new IntParameter();
    }

    /**
     * Create an instance of {@link Property }
     * 
     */
    public Property createProperty() {
        return new Property();
    }

    /**
     * Create an instance of {@link Variable }
     * 
     */
    public Variable createVariable() {
        return new Variable();
    }

    /**
     * Create an instance of {@link WildcardPathElement }
     * 
     */
    public WildcardPathElement createWildcardPathElement() {
        return new WildcardPathElement();
    }

    /**
     * Create an instance of {@link OrderBy }
     * 
     */
    public OrderBy createOrderBy() {
        return new OrderBy();
    }

    /**
     * Create an instance of {@link PathNode }
     * 
     */
    public PathNode createPathNode() {
        return new PathNode();
    }

    /**
     * Create an instance of {@link DateParameter }
     * 
     */
    public DateParameter createDateParameter() {
        return new DateParameter();
    }

    /**
     * Create an instance of {@link ImportDeclaration }
     * 
     */
    public ImportDeclaration createImportDeclaration() {
        return new ImportDeclaration();
    }

    /**
     * Create an instance of {@link Literal }
     * 
     */
    public Literal createLiteral() {
        return new Literal();
    }

    /**
     * Create an instance of {@link Clause }
     * 
     */
    public Clause createClause() {
        return new Clause();
    }

    /**
     * Create an instance of {@link RelationalOperator }
     * 
     */
    public RelationalOperator createRelationalOperator() {
        return new RelationalOperator();
    }

    /**
     * Create an instance of {@link FilterId }
     * 
     */
    public FilterId createFilterId() {
        return new FilterId();
    }

    /**
     * Create an instance of {@link VariableDeclaration }
     * 
     */
    public VariableDeclaration createVariableDeclaration() {
        return new VariableDeclaration();
    }

    /**
     * Create an instance of {@link TextContent }
     * 
     */
    public TextContent createTextContent() {
        return new TextContent();
    }

    /**
     * Create an instance of {@link Expression }
     * 
     */
    public Expression createExpression() {
        return new Expression();
    }

    /**
     * Create an instance of {@link Entity }
     * 
     */
    public Entity createEntity() {
        return new Entity();
    }

    /**
     * Create an instance of {@link GroupOperator }
     * 
     */
    public GroupOperator createGroupOperator() {
        return new GroupOperator();
    }

}
