/**
 *         PlasmaSDO™ License
 * 
 * This is a community release of PlasmaSDO™, a dual-license 
 * Service Data Object (SDO) 2.1 implementation. 
 * This particular copy of the software is released under the 
 * version 2 of the GNU General Public License. PlasmaSDO™ was developed by 
 * TerraMeta Software, Inc.
 * 
 * Copyright (c) 2013, TerraMeta Software, Inc. All rights reserved.
 * 
 * General License information can be found below.
 * 
 * This distribution may include materials developed by third
 * parties. For license and attribution notices for these
 * materials, please refer to the documentation that accompanies
 * this distribution (see the "Licenses for Third-Party Components"
 * appendix) or view the online documentation at 
 * <http://plasma-sdo.org/licenses/>.
 *  
 */
package org.plasma.query.model;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for WildcardPropertyTypeValues.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="WildcardPropertyTypeValues">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="all"/>
 *     &lt;enumeration value="reference"/>
 *     &lt;enumeration value="data"/>
 *     &lt;enumeration value="subclass_data"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlType(name = "WildcardPropertyTypeValues")
@XmlEnum
public enum WildcardPropertyType {

    @XmlEnumValue("all")
    ALL("all"),
    @XmlEnumValue("reference")
    REFERENCE("reference"),
    @XmlEnumValue("data")
    DATA("data"),
    @XmlEnumValue("subclass_data")
    SUBCLASS___DATA("subclass_data");
    private final String value;

    WildcardPropertyType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static WildcardPropertyType fromValue(String v) {
        for (WildcardPropertyType c: WildcardPropertyType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
