/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.provisioning.cli;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.xml.bind.JAXBException;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.common.bind.BindingValidationEventHandler;
import org.plasma.common.bind.DefaultValidationEventHandler;
import org.plasma.provisioning.ProvisioningException;
import org.plasma.provisioning.cli.ProvisioningTool;
import org.plasma.provisioning.cli.ProvisioningToolOption;
import org.plasma.provisioning.cli.RDBDialect;
import org.plasma.provisioning.cli.RDBToolAction;
import org.plasma.provisioning.rdb.RDBConstants;
import org.plasma.text.ddl.DDLFactory;
import org.plasma.text.ddl.DDLModelAssembler;
import org.plasma.text.ddl.DDLModelDataBinding;
import org.plasma.text.ddl.DDLOperation;
import org.plasma.text.ddl.DDLStreamAssembler;
import org.plasma.text.ddl.DefaultDDLFactory;
import org.plasma.text.ddl.MySQLFactory;
import org.plasma.text.ddl.OracleFactory;
import org.xml.sax.SAXException;

public class RDBTool
extends ProvisioningTool
implements RDBConstants {
    private static Log log = LogFactory.getLog(RDBTool.class);

    public static void main(String[] args) throws JAXBException, SAXException, IOException {
        OptionParser parser = new OptionParser();
        OptionSpecBuilder verboseOpt = parser.accepts(ProvisioningToolOption.verbose.name(), ProvisioningToolOption.verbose.getDescription());
        OptionSpecBuilder silentOpt = parser.accepts(ProvisioningToolOption.silent.name(), ProvisioningToolOption.silent.getDescription());
        OptionSpecBuilder helpOpt = parser.accepts(ProvisioningToolOption.help.name(), ProvisioningToolOption.help.getDescription());
        OptionSpecBuilder commandOpt = parser.accepts(ProvisioningToolOption.command.name(), String.valueOf(ProvisioningToolOption.command.getDescription()) + " - one of [" + RDBToolAction.asString() + "] is expected");
        commandOpt.withRequiredArg().ofType(RDBToolAction.class);
        OptionSpecBuilder dialectOpt = parser.accepts(ProvisioningToolOption.dialect.name(), String.valueOf(ProvisioningToolOption.dialect.getDescription()) + " - one of [" + RDBDialect.asString() + "] is expected");
        dialectOpt.withRequiredArg().ofType(RDBDialect.class);
        ArgumentAcceptingOptionSpec namespacesOpt = parser.accepts(ProvisioningToolOption.namespaces.name(), ProvisioningToolOption.namespaces.getDescription()).withOptionalArg().ofType(String.class);
        ArgumentAcceptingOptionSpec destOpt = parser.accepts(ProvisioningToolOption.dest.name(), ProvisioningToolOption.dest.getDescription()).withOptionalArg().ofType(File.class);
        OptionSet options = parser.parse(args);
        if (options.has((OptionSpec)helpOpt)) {
            RDBTool.printUsage(parser, log);
            return;
        }
        if (!options.has(ProvisioningToolOption.command.name())) {
            if (!options.has((OptionSpec)silentOpt)) {
                RDBTool.printUsage(parser, log);
            }
            throw new IllegalArgumentException("expected option '" + ProvisioningToolOption.command.name() + "'");
        }
        RDBToolAction command = (RDBToolAction)options.valueOf(ProvisioningToolOption.command.name());
        if (!options.has(ProvisioningToolOption.dialect.name())) {
            if (!options.has((OptionSpec)silentOpt)) {
                RDBTool.printUsage(parser, log);
            }
            throw new IllegalArgumentException("expected option '" + ProvisioningToolOption.dialect.name() + "'");
        }
        RDBDialect dialect = (RDBDialect)options.valueOf(ProvisioningToolOption.dialect.name());
        File dest = new File("./target/" + RDBTool.class.getSimpleName() + ".out");
        if (options.has((OptionSpec)destOpt)) {
            dest = (File)destOpt.value(options);
        }
        if (!dest.getParentFile().exists()) {
            dest.getParentFile().mkdirs();
        }
        String[] namespaces = null;
        if (options.has((OptionSpec)namespacesOpt)) {
            namespaces = ((String)namespacesOpt.value(options)).split(",");
        }
        switch (command) {
            case create: 
            case drop: 
            case truncate: {
                DDLOperation operation = DDLOperation.valueOf(command.name());
                DDLModelAssembler modelAssembler = null;
                modelAssembler = namespaces != null ? new DDLModelAssembler(namespaces) : new DDLModelAssembler();
                DDLModelDataBinding binding = new DDLModelDataBinding((BindingValidationEventHandler)new DefaultValidationEventHandler());
                File file = new File(dest.getParentFile(), "ddl-model.xml");
                try (FileOutputStream fos = new FileOutputStream(file);){
                    binding.marshal(modelAssembler.getSchemas(), fos);
                    fos.flush();
                    if (!options.has((OptionSpec)silentOpt)) {
                        log.info((Object)("marshalled DDL model XML to " + file.getAbsolutePath()));
                    }
                }
                DefaultDDLFactory factory = null;
                switch (dialect) {
                    case oracle: {
                        factory = new OracleFactory();
                        break;
                    }
                    case mysql: {
                        factory = new MySQLFactory();
                        break;
                    }
                    default: {
                        throw new ProvisioningException("unknown dialect, '" + dialect.name() + "'");
                    }
                }
                FileOutputStream stream = new FileOutputStream(dest);
                DDLStreamAssembler ddlAssembler = new DDLStreamAssembler(modelAssembler.getSchemas(), (DDLFactory)((Object)factory), operation, stream);
                ddlAssembler.start();
                stream.flush();
                if (options.has((OptionSpec)silentOpt)) break;
                log.info((Object)("wrote DDL model to " + dest.getAbsolutePath()));
                break;
            }
            default: {
                throw new ProvisioningException("unknown command '" + command.toString() + "'");
            }
        }
    }
}

