/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.provisioning.rdb;

import commonj.sdo.DataGraph;
import commonj.sdo.helper.XMLDocument;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.config.PlasmaConfig;
import org.plasma.metamodel.Alias;
import org.plasma.metamodel.Behavior;
import org.plasma.metamodel.BehaviorType;
import org.plasma.metamodel.Body;
import org.plasma.metamodel.Class;
import org.plasma.metamodel.ClassRef;
import org.plasma.metamodel.DataTypeRef;
import org.plasma.metamodel.Documentation;
import org.plasma.metamodel.DocumentationType;
import org.plasma.metamodel.Enumeration;
import org.plasma.metamodel.EnumerationConstraint;
import org.plasma.metamodel.EnumerationLiteral;
import org.plasma.metamodel.EnumerationRef;
import org.plasma.metamodel.Key;
import org.plasma.metamodel.KeyType;
import org.plasma.metamodel.Model;
import org.plasma.metamodel.Package;
import org.plasma.metamodel.Property;
import org.plasma.metamodel.TypeRef;
import org.plasma.metamodel.UniqueConstraint;
import org.plasma.metamodel.ValueConstraint;
import org.plasma.metamodel.VisibilityType;
import org.plasma.provisioning.ProvisioningException;
import org.plasma.provisioning.SchemaConverter;
import org.plasma.provisioning.common.NameUtils;
import org.plasma.provisioning.rdb.ConverterSupport;
import org.plasma.provisioning.rdb.oracle.g11.sys.Constraint;
import org.plasma.provisioning.rdb.oracle.g11.sys.ConstraintType;
import org.plasma.provisioning.rdb.oracle.g11.sys.SysDataType;
import org.plasma.provisioning.rdb.oracle.g11.sys.Table;
import org.plasma.provisioning.rdb.oracle.g11.sys.TableColumn;
import org.plasma.provisioning.rdb.oracle.g11.sys.TableColumnComment;
import org.plasma.provisioning.rdb.oracle.g11.sys.TableColumnConstraint;
import org.plasma.provisioning.rdb.oracle.g11.sys.TableComment;
import org.plasma.provisioning.rdb.oracle.g11.sys.View;
import org.plasma.provisioning.rdb.oracle.g11.sys.ViewColumn;
import org.plasma.provisioning.rdb.oracle.g11.sys.ViewColumnComment;
import org.plasma.provisioning.rdb.oracle.g11.sys.ViewComment;
import org.plasma.provisioning.rdb.oracle.g11.sys.query.QTable;
import org.plasma.provisioning.rdb.oracle.g11.sys.query.QView;
import org.plasma.sdo.DataType;
import org.plasma.sdo.access.client.JDBCPojoDataAccessClient;
import org.plasma.sdo.helper.PlasmaXMLHelper;
import org.plasma.sdo.xml.DefaultOptions;

public class Oracle11GConverter
extends ConverterSupport
implements SchemaConverter {
    private static Log log = LogFactory.getLog(Oracle11GConverter.class);
    protected Map<String, Class> classQualifiedPriKeyConstrainatNameMap = new HashMap<String, Class>();
    protected Map<String, Property> propertyQualifiedPriKeyConstrainatNameMap = new HashMap<String, Property>();
    protected Map<Class, Map<String, Property>> classPropertyMap = new HashMap<Class, Map<String, Property>>();
    protected JDBCPojoDataAccessClient client = new JDBCPojoDataAccessClient();
    protected Map<Property, ConstraintInfo[]> constraintMap = new HashMap<Property, ConstraintInfo[]>();

    public Oracle11GConverter(String[] schemaNames, String[] namespaces) {
        this.schemaNames = schemaNames;
        this.namespaces = namespaces;
    }

    @Override
    public Model buildModel() {
        this.model = new Model();
        this.model.setId(UUID.randomUUID().toString());
        if (this.schemaNames.length == 1) {
            this.model.setUri(this.namespaces[0]);
            Alias alias = new Alias();
            alias.setPhysicalName(this.schemaNames[0]);
            this.model.setAlias(alias);
            this.model.setName(this.schemaNames[0]);
        } else {
            this.model.setName("model");
        }
        int i = 0;
        while (i < this.schemaNames.length) {
            log.info((Object)("loading schema '" + this.schemaNames[i] + "'"));
            Package pkg = this.findPackage(this.schemaNames[i], this.namespaces[i]);
            this.loadTables(pkg, this.schemaNames[i]);
            this.loadViews(pkg, this.schemaNames[i]);
            ++i;
        }
        for (Class clss : this.classQualifiedNameMap.values()) {
            Property[] props = new Property[clss.getProperties().size()];
            clss.getProperties().toArray(props);
            Property[] propertyArray = props;
            int n = props.length;
            int n2 = 0;
            while (n2 < n) {
                Property prop = propertyArray[n2];
                ConstraintInfo[] infos = this.constraintMap.get(prop);
                if (infos != null) {
                    ConstraintInfo[] constraintInfoArray = infos;
                    int n3 = infos.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ConstraintInfo info = constraintInfoArray[n4];
                        ConstraintType consType = ConstraintType.valueOf(info.getConstraint().getConstraintType());
                        switch (consType) {
                            case R: {
                                String qualifiedName = String.valueOf(info.getConstraint().getRefOwner()) + "." + info.getConstraint().getRefConstraintName();
                                Class targetClass = this.classQualifiedPriKeyConstrainatNameMap.get(qualifiedName);
                                if (targetClass == null) {
                                    throw new ProvisioningException("no target class found for, " + qualifiedName);
                                }
                                String name = NameUtils.firstToLowerCase(targetClass.getName());
                                int count = this.countPropertiesByLogicalNamePrefix(clss, name);
                                if (count > 0) {
                                    name = String.valueOf(name) + String.valueOf(count);
                                }
                                prop.setName(name);
                                ClassRef typeRef = new ClassRef();
                                typeRef.setName(targetClass.getName());
                                typeRef.setUri(targetClass.getUri());
                                prop.setType((TypeRef)typeRef);
                                Property targetPkProp = this.propertyQualifiedPriKeyConstrainatNameMap.get(qualifiedName);
                                String oppositeName = NameUtils.firstToLowerCase(clss.getName());
                                count = this.countPropertiesByLogicalNamePrefix(targetClass, oppositeName);
                                if (count > 0) {
                                    oppositeName = String.valueOf(oppositeName) + String.valueOf(count);
                                }
                                prop.setOpposite(oppositeName);
                                Property derived = this.createDerivedPropertyOpposite(clss, prop);
                                targetClass.getProperties().add(derived);
                                break;
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return this.model;
    }

    private int countPropertiesByLogicalNamePrefix(Class clss, String namePrefix) {
        int result = 0;
        for (Property prop : clss.getProperties()) {
            if (!prop.getName().endsWith(namePrefix)) continue;
            ++result;
        }
        return result;
    }

    private Property createDerivedPropertyOpposite(Class clss, Property sourceProperty) {
        Property derived = new Property();
        derived.setId(UUID.randomUUID().toString());
        derived.setName(sourceProperty.getOpposite());
        Documentation documentation = new Documentation();
        documentation.setType(DocumentationType.DEFINITION);
        Body docBody = new Body();
        documentation.setBody(docBody);
        docBody.setValue("private derived opposite for, " + clss.getUri() + "#" + clss.getName() + "." + sourceProperty.getName());
        derived.getDocumentations().add(documentation);
        derived.setVisibility(VisibilityType.PRIVATE);
        derived.setNullable(true);
        derived.setMany(true);
        derived.setDerived(Boolean.valueOf(true));
        derived.setContainment(Boolean.valueOf(false));
        derived.setOpposite(sourceProperty.getName());
        ClassRef targetClassRef = new ClassRef();
        targetClassRef.setName(clss.getName());
        targetClassRef.setUri(clss.getUri());
        derived.setType((TypeRef)targetClassRef);
        return derived;
    }

    private void loadTables(Package pkg, String schema) {
        for (String tableName : this.getTableNames(schema)) {
            log.info((Object)("loading table '" + tableName + "'"));
            Table table = this.getTableGraph(schema, tableName);
            if (log.isDebugEnabled()) {
                try {
                    log.debug((Object)this.serializeGraph(table.getDataGraph()));
                }
                catch (IOException e) {
                    log.error((Object)e.getMessage());
                }
            }
            Class clss = this.buildClass(pkg, table);
            pkg.getClazzs().add(clss);
            String key = String.valueOf(pkg.getUri()) + "#" + clss.getName();
            this.classQualifiedNameMap.put(key, clss);
            TableColumn[] tableColumnArray = table.getTableColumn();
            int n = tableColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn column = tableColumnArray[n2];
                log.debug((Object)("\tloading column '" + column.getColumnName() + "'"));
                ConstraintInfo[] constraints = this.findConstraints(column, table);
                TableColumnComment[] comments = this.findComments(column, table);
                Property prop = this.buildProperty(pkg, clss, column, constraints, comments);
                clss.getProperties().add(prop);
                this.constraintMap.put(prop, constraints);
                ++n2;
            }
        }
    }

    private void loadViews(Package pkg, String schema) {
        for (String viewName : this.getViewNames(schema)) {
            log.info((Object)("loading view '" + viewName + "'"));
            View view = this.getViewGraph(schema, viewName);
            if (log.isDebugEnabled()) {
                try {
                    log.debug((Object)this.serializeGraph(view.getDataGraph()));
                }
                catch (IOException e) {
                    log.error((Object)e.getMessage());
                }
            }
            Class clss = this.buildClass(pkg, view);
            pkg.getClazzs().add(clss);
            String key = String.valueOf(pkg.getUri()) + "#" + clss.getName();
            this.classQualifiedNameMap.put(key, clss);
            Behavior behavior = new Behavior();
            behavior.setName(String.valueOf(view.getViewName()) + "_create");
            behavior.setLanguage("SQL");
            behavior.setType(BehaviorType.CREATE);
            behavior.setValue(view.getText());
            clss.getBehaviors().add(behavior);
            ViewColumn[] viewColumnArray = view.getViewColumn();
            int n = viewColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                ViewColumn column = viewColumnArray[n2];
                log.debug((Object)("\tloading column '" + column.getColumnName() + "'"));
                ViewColumnComment[] comments = this.findComments(column, view);
                Property prop = this.buildProperty(pkg, clss, column, comments);
                clss.getProperties().add(prop);
                ++n2;
            }
        }
    }

    private Package findPackage(String schema, String namespace) {
        Model pkg = null;
        if (this.schemaNames.length > 1) {
            pkg = new Package();
            pkg.setName(schema.toLowerCase());
            pkg.setId(UUID.randomUUID().toString());
            pkg.setUri(namespace);
            Alias alias = new Alias();
            alias.setPhysicalName(schema);
            pkg.setAlias(alias);
            this.model.getPackages().add(pkg);
        } else {
            pkg = this.model;
        }
        return pkg;
    }

    private TableColumnComment[] findComments(TableColumn column, Table table) {
        TableColumnComment[] result = new TableColumnComment[]{};
        if (table.getTableColumnComment() != null) {
            ArrayList<TableColumnComment> list = new ArrayList<TableColumnComment>();
            TableColumnComment[] tableColumnCommentArray = table.getTableColumnComment();
            int n = tableColumnCommentArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumnComment comment = tableColumnCommentArray[n2];
                if (comment.getColumnName().equalsIgnoreCase(column.getColumnName())) {
                    list.add(comment);
                }
                ++n2;
            }
            if (list.size() > 0) {
                result = new TableColumnComment[list.size()];
                list.toArray(result);
            }
        }
        return result;
    }

    private ViewColumnComment[] findComments(ViewColumn column, View view) {
        ViewColumnComment[] result = new ViewColumnComment[]{};
        if (view.getViewColumnComment() != null) {
            ArrayList<ViewColumnComment> list = new ArrayList<ViewColumnComment>();
            ViewColumnComment[] viewColumnCommentArray = view.getViewColumnComment();
            int n = viewColumnCommentArray.length;
            int n2 = 0;
            while (n2 < n) {
                ViewColumnComment comment = viewColumnCommentArray[n2];
                if (comment.getColumnName().equalsIgnoreCase(column.getColumnName())) {
                    list.add(comment);
                }
                ++n2;
            }
            if (list.size() > 0) {
                result = new ViewColumnComment[list.size()];
                list.toArray(result);
            }
        }
        return result;
    }

    private ConstraintInfo[] findConstraints(TableColumn column, Table table) {
        return this.findConstraints(column, table.getConstraint(), table.getTableColumnConstraint());
    }

    private ConstraintInfo[] findConstraints(TableColumn column, Constraint[] constraints, TableColumnConstraint[] columnConstraints) {
        ArrayList<ConstraintInfo> list = new ArrayList<ConstraintInfo>();
        if (columnConstraints != null && constraints != null) {
            TableColumnConstraint[] tableColumnConstraintArray = columnConstraints;
            int n = columnConstraints.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumnConstraint colConst = tableColumnConstraintArray[n2];
                if (colConst.getColumnName().equals(column.getColumnName())) {
                    list.add(new ConstraintInfo(this.getConstraint(colConst, constraints), colConst));
                }
                ++n2;
            }
        }
        ConstraintInfo[] result = new ConstraintInfo[list.size()];
        list.toArray(result);
        return result;
    }

    private Constraint getConstraint(TableColumnConstraint constraint, Constraint[] constraints) {
        if (constraints != null) {
            Constraint[] constraintArray = constraints;
            int n = constraints.length;
            int n2 = 0;
            while (n2 < n) {
                Constraint c = constraintArray[n2];
                if (c.getConstraintName().equals(constraint.getConstraintName())) {
                    return c;
                }
                ++n2;
            }
        }
        throw new IllegalArgumentException("no constraint found for given constraint name '" + constraint.getConstraintName() + "'");
    }

    private Table getTableGraph(String schema, String tableName) {
        QTable table = QTable.newQuery();
        table.select(table.wildcard());
        table.select(table.tableColumn().wildcard());
        table.select(table.tableComment().wildcard());
        table.select(table.tableColumnComment().wildcard());
        table.select(table.constraint().wildcard());
        table.select(table.tableColumnConstraint().wildcard());
        table.where(table.owner().eq(schema).and(table.tableName().eq(tableName)));
        DataGraph[] results = this.client.find(table);
        return (Table)results[0].getRootObject();
    }

    private List<String> getTableNames(String schema) {
        ArrayList<String> result = new ArrayList<String>();
        QTable query = QTable.newQuery();
        query.select(query.tableName());
        query.where(query.owner().eq(schema));
        DataGraph[] dataGraphArray = this.client.find(query);
        int n = dataGraphArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataGraph graph = dataGraphArray[n2];
            Table tab = (Table)graph.getRootObject();
            result.add(tab.getTableName());
            ++n2;
        }
        return result;
    }

    private View getViewGraph(String schema, String viewName) {
        QView view = QView.newQuery();
        view.select(view.wildcard()).select(view.viewColumn().wildcard()).select(view.viewComment().wildcard()).select(view.viewColumnComment().wildcard());
        view.where(view.owner().eq(schema).and(view.viewName().eq(viewName)));
        DataGraph[] results = this.client.find(view);
        return (View)results[0].getRootObject();
    }

    private List<String> getViewNames(String schema) {
        ArrayList<String> result = new ArrayList<String>();
        QView query = QView.newQuery();
        query.select(query.viewName());
        query.where(query.owner().eq(schema));
        DataGraph[] dataGraphArray = this.client.find(query);
        int n = dataGraphArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataGraph graph = dataGraphArray[n2];
            View view = (View)graph.getRootObject();
            result.add(view.getViewName());
            ++n2;
        }
        return result;
    }

    public Class buildClass(Package pkg, Table table) {
        Class clss = new Class();
        clss.setId(UUID.randomUUID().toString());
        clss.setName(NameUtils.firstToUpperCase(NameUtils.toCamelCase(table.getTableName())));
        clss.setUri(pkg.getUri());
        Alias alias = new Alias();
        alias.setPhysicalName(table.getTableName());
        clss.setAlias(alias);
        if (table.getTableComment() != null) {
            TableComment[] tableCommentArray = table.getTableComment();
            int n = tableCommentArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableComment comment = tableCommentArray[n2];
                if (comment.getComments() != null && comment.getComments().trim().length() != 0) {
                    Documentation documentation = new Documentation();
                    documentation.setType(DocumentationType.DEFINITION);
                    Body body = new Body();
                    body.setValue(this.filter(comment.getComments()));
                    documentation.setBody(body);
                    clss.getDocumentations().add(documentation);
                }
                ++n2;
            }
        }
        return clss;
    }

    public Class buildClass(Package pkg, View view) {
        Class clss = new Class();
        clss.setId(UUID.randomUUID().toString());
        clss.setName(NameUtils.firstToUpperCase(NameUtils.toCamelCase(view.getViewName())));
        clss.setUri(pkg.getUri());
        Alias alias = new Alias();
        alias.setPhysicalName(view.getViewName());
        clss.setAlias(alias);
        if (view.getViewComment() != null) {
            ViewComment[] viewCommentArray = view.getViewComment();
            int n = viewCommentArray.length;
            int n2 = 0;
            while (n2 < n) {
                ViewComment comment = viewCommentArray[n2];
                if (comment.getComments() != null && comment.getComments().trim().length() != 0) {
                    Documentation documentation = new Documentation();
                    documentation.setType(DocumentationType.DEFINITION);
                    Body body = new Body();
                    body.setValue(this.filter(comment.getComments()));
                    documentation.setBody(body);
                    clss.getDocumentations().add(documentation);
                }
                ++n2;
            }
        }
        if (view.getText() != null && view.getText().length() > 0) {
            Behavior create = new Behavior();
            create.setLanguage("SQL");
            create.setType(BehaviorType.CREATE);
            create.setName(BehaviorType.CREATE.name().toLowerCase());
            create.setValue(this.filter(view.getText()));
            clss.getBehaviors().add(create);
        }
        Behavior drop = new Behavior();
        drop.setLanguage("SQL");
        drop.setType(BehaviorType.DROP);
        drop.setName(BehaviorType.DROP.name().toLowerCase());
        drop.setValue("DROP VIEW " + pkg.getAlias().getPhysicalName() + "." + clss.getAlias().getPhysicalName() + ";");
        clss.getBehaviors().add(drop);
        return clss;
    }

    public Property buildProperty(Package pkg, Class clss, TableColumn column, ConstraintInfo[] constraints, TableColumnComment[] comments) {
        Property property = new Property();
        property.setId(UUID.randomUUID().toString());
        property.setVisibility(VisibilityType.PUBLIC);
        property.setName(NameUtils.firstToLowerCase(NameUtils.toCamelCase(column.getColumnName())));
        Alias alias = new Alias();
        alias.setPhysicalName(column.getColumnName());
        property.setAlias(alias);
        if ("Y".equalsIgnoreCase(column.getNullable())) {
            property.setNullable(true);
        } else {
            property.setNullable(false);
        }
        SysDataType oracleType = SysDataType.valueOf(column.getDataType());
        DataType sdoType = this.mapType(oracleType, column.getDataLength(), column.getDataPrecision(), column.getDataScale());
        DataTypeRef dataTypeRef = new DataTypeRef();
        dataTypeRef.setName(sdoType.name());
        dataTypeRef.setUri(PlasmaConfig.getInstance().getSDODataTypesNamespace().getUri());
        property.setType((TypeRef)dataTypeRef);
        ValueConstraint valueConstraint = this.buildValueConstraint(oracleType, column.getDataLength(), column.getDataPrecision(), column.getDataScale());
        if (valueConstraint != null) {
            property.setValueConstraint(valueConstraint);
        }
        Object[] objectArray = constraints;
        int n = constraints.length;
        int n2 = 0;
        while (n2 < n) {
            ConstraintInfo info = objectArray[n2];
            ConstraintType consType = ConstraintType.valueOf(info.getConstraint().getConstraintType());
            switch (consType) {
                case P: {
                    Key prikey = new Key();
                    prikey.setType(KeyType.PRIMARY);
                    property.setKey(prikey);
                    String qualifiedName = String.valueOf(pkg.getAlias().getPhysicalName()) + "." + info.getConstraint().getConstraintName();
                    this.classQualifiedPriKeyConstrainatNameMap.put(qualifiedName, clss);
                    this.propertyQualifiedPriKeyConstrainatNameMap.put(qualifiedName, property);
                    UniqueConstraint uniqueConstraint = new UniqueConstraint();
                    uniqueConstraint.setGroup(info.getConstraint().getConstraintName());
                    property.setUniqueConstraint(uniqueConstraint);
                    break;
                }
                case R: {
                    break;
                }
                case U: {
                    UniqueConstraint uniqueConstraint = new UniqueConstraint();
                    uniqueConstraint.setGroup(info.getConstraint().getConstraintName());
                    property.setUniqueConstraint(uniqueConstraint);
                    break;
                }
                case C: {
                    String[] literals;
                    String condition = info.getConstraint().getSearchCondition();
                    if (condition == null || (literals = this.parseLiterals(column, condition)) == null) break;
                    Enumeration enm = this.buildEnumeration(pkg, clss, property, literals);
                    pkg.getEnumerations().add(enm);
                    this.enumQualifiedNameMap.put(String.valueOf(enm.getUri()) + "#" + enm.getName(), enm);
                    EnumerationRef enumRef = new EnumerationRef();
                    enumRef.setName(enm.getName());
                    enumRef.setUri(enm.getUri());
                    EnumerationConstraint enumConst = new EnumerationConstraint();
                    enumConst.setValue(enumRef);
                    property.setEnumerationConstraint(enumConst);
                    break;
                }
            }
            ++n2;
        }
        objectArray = comments;
        n = comments.length;
        n2 = 0;
        while (n2 < n) {
            Object comment = objectArray[n2];
            if (comment.getComments() != null && comment.getComments().trim().length() != 0) {
                Documentation documentation = new Documentation();
                documentation.setType(DocumentationType.DEFINITION);
                Body body = new Body();
                body.setValue(this.filter(comment.getComments()));
                documentation.setBody(body);
                property.getDocumentations().add(documentation);
            }
            ++n2;
        }
        return property;
    }

    public Property buildProperty(Package pkg, Class clss, ViewColumn column, ViewColumnComment[] comments) {
        Property property = new Property();
        property.setId(UUID.randomUUID().toString());
        property.setVisibility(VisibilityType.PUBLIC);
        property.setName(NameUtils.firstToLowerCase(NameUtils.toCamelCase(column.getColumnName())));
        Alias alias = new Alias();
        alias.setPhysicalName(column.getColumnName());
        property.setAlias(alias);
        if ("Y".equalsIgnoreCase(column.getNullable())) {
            property.setNullable(true);
        } else {
            property.setNullable(false);
        }
        SysDataType oracleType = SysDataType.valueOf(column.getDataType());
        DataType sdoType = this.mapType(oracleType, column.getDataLength(), column.getDataPrecision(), column.getDataScale());
        DataTypeRef dataTypeRef = new DataTypeRef();
        dataTypeRef.setName(sdoType.name());
        dataTypeRef.setUri(PlasmaConfig.getInstance().getSDODataTypesNamespace().getUri());
        property.setType((TypeRef)dataTypeRef);
        ValueConstraint valueConstraint = this.buildValueConstraint(oracleType, column.getDataLength(), column.getDataPrecision(), column.getDataScale());
        if (valueConstraint != null) {
            property.setValueConstraint(valueConstraint);
        }
        ViewColumnComment[] viewColumnCommentArray = comments;
        int n = comments.length;
        int n2 = 0;
        while (n2 < n) {
            ViewColumnComment comment = viewColumnCommentArray[n2];
            if (comment.getComments() != null && comment.getComments().trim().length() != 0) {
                Documentation documentation = new Documentation();
                documentation.setType(DocumentationType.DEFINITION);
                Body body = new Body();
                body.setValue(this.filter(comment.getComments()));
                documentation.setBody(body);
                property.getDocumentations().add(documentation);
            }
            ++n2;
        }
        return property;
    }

    private Enumeration buildEnumeration(Package pkg, Class clss, Property property, String[] literals) {
        Enumeration enm = new Enumeration();
        enm.setId(UUID.randomUUID().toString());
        String baseName = String.valueOf(NameUtils.firstToUpperCase(property.getName())) + "Values";
        String suffix = this.getNameSequence(clss.getUri(), baseName, this.enumQualifiedNameMap);
        String name = String.valueOf(baseName) + suffix;
        int count = this.countExistingEnumsByName(pkg, name);
        if (count > 0) {
            name = String.valueOf(name) + String.valueOf(count);
        }
        enm.setName(name);
        enm.setUri(clss.getUri());
        Documentation documentation = new Documentation();
        documentation.setType(DocumentationType.DEFINITION);
        Body body = new Body();
        body.setValue("This enumeration was derived from a check constraint on column " + clss.getAlias().getPhysicalName() + "." + property.getAlias().getPhysicalName() + " and linked as an SDO enumeration constraint to logical" + " property " + clss.getName() + "." + property.getName() + ".");
        documentation.setBody(body);
        enm.getDocumentations().add(documentation);
        String[] stringArray = literals;
        int n = literals.length;
        int n2 = 0;
        while (n2 < n) {
            String literalStr = stringArray[n2];
            EnumerationLiteral literal = new EnumerationLiteral();
            enm.getEnumerationLiterals().add(literal);
            literal.setName(NameUtils.toCamelCase(literalStr));
            literal.setValue(NameUtils.toCamelCase(literalStr));
            literal.setId(UUID.randomUUID().toString());
            Alias alias = new Alias();
            literal.setAlias(alias);
            alias.setPhysicalName(literalStr);
            ++n2;
        }
        return enm;
    }

    private int countExistingEnumsByName(Package pkg, String name) {
        int i = 0;
        for (Enumeration enm : pkg.getEnumerations()) {
            if (!enm.getName().startsWith(name)) continue;
            ++i;
        }
        return i;
    }

    private String getNameSequence(String uri, String baseName, Map<String, ? extends Object> map) {
        String qualifiedName = String.valueOf(uri) + "#" + baseName;
        int num = 0;
        while (map.get(qualifiedName) != null) {
            qualifiedName = String.valueOf(uri) + "#" + baseName + String.valueOf(num);
            ++num;
        }
        if (num > 0) {
            return String.valueOf(num);
        }
        return "";
    }

    private String[] parseLiterals(TableColumn column, String condition) {
        String[] literals = null;
        int rightIndex = condition.indexOf("(");
        int leftIndex = condition.indexOf(")");
        if (rightIndex >= 0 && leftIndex > 0 && leftIndex > rightIndex) {
            String[] conditionTokens = condition.split(" ");
            if (this.findTokenIgnoreCase(column.getColumnName(), conditionTokens) && this.findTokenIgnoreCase("IN", conditionTokens)) {
                String literalSubstr = condition.substring(rightIndex, leftIndex);
                literals = literalSubstr.split(",");
                int i = 0;
                while (i < literals.length) {
                    int rightAposIndex = literals[i].indexOf("'");
                    int leftAposIndex = literals[i].lastIndexOf("'");
                    if (rightAposIndex >= 0 && leftAposIndex > 0) {
                        literals[i] = literals[i].substring(rightAposIndex + 1, leftAposIndex);
                    }
                    literals[i] = literals[i].trim();
                    ++i;
                }
            } else {
                log.warn((Object)("expected constraint search condition on column, " + column.getColumnName()));
            }
        }
        return literals;
    }

    private boolean findTokenIgnoreCase(String value, String[] tokens) {
        String[] stringArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            if (token.equalsIgnoreCase(value)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private ValueConstraint buildValueConstraint(SysDataType oracleType, int dataLength, int dataPrecision, int dataScale) {
        ValueConstraint constraint = null;
        switch (oracleType) {
            case CHAR: 
            case VARCHAR2: 
            case VARCHAR: 
            case NCHAR: 
            case NVARCHAR2: 
            case CLOB: 
            case NCLOB: {
                if (dataLength <= 0) break;
                constraint = new ValueConstraint();
                constraint.setMaxLength(String.valueOf(dataLength));
                break;
            }
            case NUMBER: {
                if (dataPrecision <= 0) break;
                constraint = new ValueConstraint();
                constraint.setTotalDigits(String.valueOf(dataPrecision));
                if (dataScale <= 0) break;
                constraint.setFractionDigits(String.valueOf(dataScale));
                break;
            }
            case LONG: 
            case BINARY__FLOAT: 
            case BINARY__DOUBLE: 
            case DATE: 
            case TIMESTAMP: 
            case BLOB: 
            case BFILE: 
            case RAW: 
            case ROWID: 
            case UROWID: {
                if (dataPrecision > 0) {
                    log.warn((Object)("ignoring precision for datatype '" + oracleType + "' when creating valud constraints"));
                }
                if (dataScale <= 0) break;
                log.warn((Object)("ignoring scale for datatype '" + oracleType + "' when creating valud constraints"));
                break;
            }
            default: {
                throw new ProvisioningException("unknown datatype, " + oracleType.name());
            }
        }
        return constraint;
    }

    private DataType mapType(SysDataType oracleType, int dataLength, int dataPrecision, int dataScale) {
        switch (oracleType) {
            case CHAR: {
                return DataType.Character;
            }
            case VARCHAR2: 
            case VARCHAR: 
            case NCHAR: 
            case NVARCHAR2: 
            case LONG: 
            case CLOB: 
            case NCLOB: {
                return DataType.String;
            }
            case NUMBER: {
                if (dataPrecision > 0) {
                    if (dataScale == 0) {
                        return this.mapIntegralType(dataPrecision);
                    }
                    return this.mapFloatingPointType(dataPrecision, dataScale);
                }
                return DataType.Long;
            }
            case BINARY__FLOAT: 
            case BINARY__DOUBLE: 
            case BLOB: 
            case BFILE: 
            case RAW: 
            case ROWID: 
            case UROWID: {
                return DataType.Bytes;
            }
            case DATE: {
                return DataType.Date;
            }
            case TIMESTAMP: {
                return DataType.DateTime;
            }
        }
        log.warn((Object)("unknown datatype '" + oracleType.name() + "' - using String"));
        return DataType.String;
    }

    private DataType mapIntegralType(int dataPrecision) {
        if (dataPrecision == 1) {
            return DataType.Boolean;
        }
        if (dataPrecision <= 5) {
            return DataType.Short;
        }
        if (dataPrecision <= 10) {
            return DataType.Int;
        }
        if (dataPrecision <= 19) {
            return DataType.Long;
        }
        return DataType.Integer;
    }

    private DataType mapFloatingPointType(int dataPrecision, int dataScale) {
        if (dataPrecision <= 19) {
            return DataType.Float;
        }
        if (dataPrecision <= 35) {
            return DataType.Double;
        }
        return DataType.Decimal;
    }

    private String serializeGraph(DataGraph graph) throws IOException {
        DefaultOptions options = new DefaultOptions(graph.getRootObject().getType().getURI());
        options.setRootNamespacePrefix("dump");
        XMLDocument doc = PlasmaXMLHelper.INSTANCE.createDocument(graph.getRootObject(), graph.getRootObject().getType().getURI(), null);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PlasmaXMLHelper.INSTANCE.save(doc, os, (Object)options);
        os.flush();
        os.close();
        String xml = new String(os.toByteArray());
        return xml;
    }

    class ConstraintInfo {
        private Constraint constraint;
        private TableColumnConstraint columnConstraint;

        public ConstraintInfo(Constraint constraint, TableColumnConstraint columnConstraint) {
            this.constraint = constraint;
            this.columnConstraint = columnConstraint;
        }

        public Constraint getConstraint() {
            return this.constraint;
        }

        public TableColumnConstraint getTableColumnConstraint() {
            return this.columnConstraint;
        }
    }
}

