/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.provisioning.xsd;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.metamodel.Class;
import org.plasma.metamodel.ClassRef;
import org.plasma.metamodel.DataTypeRef;
import org.plasma.metamodel.Documentation;
import org.plasma.metamodel.DocumentationType;
import org.plasma.metamodel.Enumeration;
import org.plasma.metamodel.Model;
import org.plasma.metamodel.Property;
import org.plasma.provisioning.SchemaConverter;
import org.plasma.provisioning.xsd.ClassAssembler;
import org.plasma.provisioning.xsd.ClassVisitor;
import org.plasma.provisioning.xsd.ConverterSupport;
import org.plasma.provisioning.xsd.EnumerationAssembler;
import org.plasma.provisioning.xsd.EnumerationCollector;
import org.plasma.provisioning.xsd.PropertyAssembler;
import org.plasma.xml.schema.AbstractComplexType;
import org.plasma.xml.schema.Annotated;
import org.plasma.xml.schema.Annotation;
import org.plasma.xml.schema.Any;
import org.plasma.xml.schema.Attribute;
import org.plasma.xml.schema.AttributeGroup;
import org.plasma.xml.schema.AttributeGroupRef;
import org.plasma.xml.schema.ComplexRestrictionType;
import org.plasma.xml.schema.ComplexType;
import org.plasma.xml.schema.Element;
import org.plasma.xml.schema.ExplicitGroup;
import org.plasma.xml.schema.ExtensionType;
import org.plasma.xml.schema.LocalElement;
import org.plasma.xml.schema.OpenAttrs;
import org.plasma.xml.schema.Schema;
import org.plasma.xml.schema.SchemaUtil;
import org.plasma.xml.schema.SimpleExtensionType;
import org.plasma.xml.schema.SimpleType;
import org.plasma.xml.schema.SimpleTypeVisitor;

public class XSDSchemaConverter
implements SchemaConverter {
    private static Log log = LogFactory.getLog(XSDSchemaConverter.class);
    private ConverterSupport support;
    private QName appNamespaceQName;
    protected String destNamespaceURI;
    protected String destNamespacePrefix;
    protected PropertyAssembler propertyAssembler;
    protected ClassAssembler classAssembler;

    public XSDSchemaConverter(Schema schema, String destNamespaceURI, String destNamespacePrefix) {
        this.destNamespaceURI = destNamespaceURI;
        this.destNamespacePrefix = destNamespacePrefix;
        this.support = new ConverterSupport(schema, destNamespaceURI, destNamespacePrefix);
        this.appNamespaceQName = this.support.findOpenAttributeQNameByValue(this.support.getSchema().getTargetNamespace(), (OpenAttrs)this.support.getSchema());
        this.propertyAssembler = new PropertyAssembler(this.support, this.appNamespaceQName);
        this.classAssembler = new ClassAssembler(this.support, this.destNamespaceURI, this.destNamespacePrefix);
    }

    @Override
    public Model buildModel() {
        Model model = new Model();
        model.setName(this.support.getSchema().getId());
        model.setId(UUID.randomUUID().toString());
        model.setUri(this.support.getDestNamespaceURI());
        for (OpenAttrs attrs : this.support.getSchema().getIncludesAndImportsAndRedefines()) {
            String doc;
            if (!(attrs instanceof Annotation) || (doc = this.support.getDocumentationContent((Annotation)attrs)) == null || doc.length() <= 0) continue;
            Documentation documentation = this.support.createDocumentation(DocumentationType.DEFINITION, doc);
            model.getDocumentations().add(documentation);
        }
        for (Annotated annotated : this.support.getSchema().getSimpleTypesAndComplexTypesAndGroups()) {
            if (annotated instanceof ComplexType) {
                ComplexType complexType = (ComplexType)annotated;
                if (complexType.getName().equals(SchemaUtil.getSerializationBaseTypeName())) continue;
                this.support.getComplexTypeMap().put(complexType.getName(), complexType);
                continue;
            }
            if (annotated instanceof SimpleType) {
                SimpleType simpleType = (SimpleType)annotated;
                if (simpleType.getName() == null || simpleType.getName().trim().length() == 0) {
                    throw new IllegalStateException("expected name for top level simple type");
                }
                this.support.getSimpleTypeMap().put(simpleType.getName(), simpleType);
                continue;
            }
            if (annotated instanceof Element) {
                Element element = (Element)annotated;
                if (element.getName() == null || element.getName().trim().length() == 0) {
                    throw new IllegalStateException("expected name for top level element");
                }
                this.support.getElementMap().put(element.getName(), element);
                continue;
            }
            if (annotated instanceof AttributeGroup) {
                AttributeGroup attrGroup = (AttributeGroup)annotated;
                this.support.getAttributeGroupMap().put(attrGroup.getName(), attrGroup);
                this.support.getAttributeGroupMap().put(attrGroup.getId(), attrGroup);
                continue;
            }
            log.warn((Object)("unknown annotated class, " + annotated.getClass().getName()));
        }
        EnumerationAssembler enumerationAssembler = new EnumerationAssembler(this.support, this.destNamespaceURI, this.destNamespacePrefix);
        for (Annotated annotated : this.support.getSchema().getSimpleTypesAndComplexTypesAndGroups()) {
            if (!(annotated instanceof SimpleType)) continue;
            SimpleType simpleType = (SimpleType)annotated;
            EnumerationCollector collector = new EnumerationCollector(this.support.getSchema(), this.support.getSimpleTypeMap(), enumerationAssembler);
            simpleType.accept((SimpleTypeVisitor)collector);
            for (Enumeration enumeration : collector.getResult()) {
                model.getEnumerations().add(enumeration);
            }
        }
        if (this.support.getElementMap().size() > 0) {
            for (Element element : this.support.getElementMap().values()) {
                Class cls;
                ComplexType complexType = this.support.getComplexTypeMap().get(element.getName());
                if (complexType != null) {
                    cls = this.classAssembler.buildClass(complexType);
                    model.getClazzs().add(cls);
                    this.support.getClassQualifiedNameMap().put(String.valueOf(this.destNamespaceURI) + "#" + cls.getName(), cls);
                    this.support.getClassLocalNameMap().put(cls.getAlias().getLocalName(), cls);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("created class, " + cls.getName()));
                    continue;
                }
                cls = this.classAssembler.buildClass(element);
                model.getClazzs().add(cls);
                this.support.getClassQualifiedNameMap().put(String.valueOf(this.destNamespaceURI) + "#" + cls.getName(), cls);
                this.support.getClassLocalNameMap().put(cls.getAlias().getLocalName(), cls);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("created class, " + cls.getName()));
            }
        } else {
            for (ComplexType complexType : this.support.getComplexTypeMap().values()) {
                Class cls = this.classAssembler.buildClass(complexType);
                model.getClazzs().add(cls);
                this.support.getClassQualifiedNameMap().put(String.valueOf(this.destNamespaceURI) + "#" + cls.getName(), cls);
                this.support.getClassLocalNameMap().put(cls.getAlias().getLocalName(), cls);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("created class, " + cls.getName()));
            }
        }
        this.support.collectSubclasses();
        ClassVisitor visitor = new ClassVisitor(){

            @Override
            public void visit(Class target, Class source) {
                String localName;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("creating properties for class, " + target.getName()));
                }
                if ((localName = target.getAlias().getLocalName()) == null || localName.trim().length() == 0) {
                    throw new IllegalStateException("expected local name apias for class, " + target.getName());
                }
                ComplexType complexType = XSDSchemaConverter.this.support.getComplexTypeMap().get(localName);
                if (complexType != null) {
                    XSDSchemaConverter.this.buildProperties(target, (AbstractComplexType)complexType);
                } else {
                    Element element = XSDSchemaConverter.this.support.getElementMap().get(localName);
                    if (element != null) {
                        XSDSchemaConverter.this.buildProperties(target, element);
                    } else {
                        throw new IllegalStateException("expected top level conplex type or element for local name, " + localName);
                    }
                }
            }
        };
        for (Class root : this.support.getRootClasses()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("traversing 'root' class, " + root.getName()));
            }
            this.support.accept(root, visitor);
        }
        for (Class cls : this.support.getClassQualifiedNameMap().values()) {
            Property[] props = new Property[cls.getProperties().size()];
            cls.getProperties().toArray(props);
            Property[] propertyArray = props;
            int n = props.length;
            int n2 = 0;
            while (n2 < n) {
                Property prop = propertyArray[n2];
                if (prop.getType() == null) {
                    throw new IllegalStateException("property " + cls.getName() + "." + prop.getName() + " has no datatype");
                }
                if (!(prop.getType() instanceof DataTypeRef)) {
                    ClassRef classRef = (ClassRef)prop.getType();
                    String qualifiedName = String.valueOf(classRef.getUri()) + "#" + classRef.getName();
                    Class targetClass = this.support.getClassQualifiedNameMap().get(qualifiedName);
                    if (targetClass == null) {
                        throw new IllegalStateException("no class definition found for qualified name '" + qualifiedName + "'");
                    }
                    Property targetProperty = null;
                    Property[] pdefs2 = new Property[targetClass.getProperties().size()];
                    targetClass.getProperties().toArray(pdefs2);
                    Property[] propertyArray2 = pdefs2;
                    int n3 = pdefs2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Property pdef2 = propertyArray2[n4];
                        if (pdef2.getName().equals(prop.getOpposite())) {
                            targetProperty = pdef2;
                            break;
                        }
                        ++n4;
                    }
                    if (targetProperty == null && prop.getOpposite() != null) {
                        targetProperty = this.propertyAssembler.createDerivedPropertyOpposite(cls, prop);
                        targetClass.getProperties().add(targetProperty);
                    }
                }
                ++n2;
            }
        }
        return model;
    }

    private boolean hasBase(ComplexType complexType) {
        if (complexType.getComplexContent() != null) {
            QName base;
            QName base2;
            ExtensionType extension = complexType.getComplexContent().getExtension();
            if (extension != null && (base2 = extension.getBase()) != null && !base2.getLocalPart().equals(SchemaUtil.getSerializationBaseTypeName())) {
                return true;
            }
            ComplexRestrictionType restriction = complexType.getComplexContent().getRestriction();
            if (restriction != null && (base = restriction.getBase()) != null && !base.getLocalPart().equals(SchemaUtil.getSerializationBaseTypeName())) {
                return true;
            }
        }
        return false;
    }

    private boolean hasBase(Element element) {
        QName base;
        QName base2;
        ExtensionType baseType;
        return element.getComplexType() != null && element.getComplexType().getComplexContent() != null ? (baseType = element.getComplexType().getComplexContent().getExtension()) != null && !(base2 = baseType.getBase()).getLocalPart().equals(SchemaUtil.getSerializationBaseTypeName()) : element.getSubstitutionGroup() != null && !(base = element.getSubstitutionGroup()).getLocalPart().equals(SchemaUtil.getSerializationBaseTypeName());
    }

    private void buildProperties(Class cls, Element element) {
        if (element.getComplexType() != null) {
            this.buildProperties(cls, (AbstractComplexType)element.getComplexType());
        } else {
            log.warn((Object)("ignoring element w/o local complex type, " + element.getName()));
        }
    }

    private void buildProperties(Class cls, AbstractComplexType complexType) {
        List annotatedList = null;
        if (complexType.getComplexContent() == null) {
            if (complexType.getSimpleContent() == null) {
                annotatedList = complexType.getAttributesAndAttributeGroups();
            } else if (complexType.getSimpleContent().getExtension() != null) {
                SimpleExtensionType extension = complexType.getSimpleContent().getExtension();
                annotatedList = extension.getAttributesAndAttributeGroups();
                QName base = extension.getBase();
                if (base != null) {
                    if (base.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
                        Property property = this.propertyAssembler.buildElementContentDatatypeProperty(cls, base);
                        cls.getProperties().add(property);
                        Map<String, Property> classProps = this.support.getClassPropertyMap().get(cls);
                        if (classProps == null) {
                            classProps = new HashMap<String, Property>();
                            this.support.getClassPropertyMap().put(cls, classProps);
                        }
                        classProps.put(property.getName(), property);
                    } else {
                        log.warn((Object)"expected XML Schema namespace http://www.w3.org/2001/XMLSchema as extension base for simple type - ignoring");
                    }
                }
            }
        } else if (complexType.getComplexContent().getExtension() != null) {
            annotatedList = complexType.getComplexContent().getExtension().getAttributesAndAttributeGroups();
        } else if (complexType.getComplexContent().getRestriction() != null) {
            annotatedList = complexType.getComplexContent().getRestriction().getAttributesAndAttributeGroups();
        }
        if (annotatedList != null) {
            this.buildProperties(cls, complexType, annotatedList);
        }
        ExplicitGroup sequence = null;
        if (complexType.getComplexContent() == null) {
            sequence = complexType.getSequence();
        } else if (complexType.getComplexContent().getExtension() != null) {
            sequence = complexType.getComplexContent().getExtension().getSequence();
        } else if (complexType.getComplexContent().getRestriction() != null) {
            sequence = complexType.getComplexContent().getRestriction().getSequence();
        }
        if (sequence != null) {
            this.buildProperties(cls, complexType, sequence);
        }
        ExplicitGroup choice = null;
        if (complexType.getComplexContent() == null) {
            choice = complexType.getChoice();
        } else if (complexType.getComplexContent().getExtension() != null) {
            choice = complexType.getComplexContent().getExtension().getChoice();
        } else if (complexType.getComplexContent().getRestriction() != null) {
            choice = complexType.getComplexContent().getRestriction().getChoice();
        }
        if (choice != null) {
            this.buildProperties(cls, complexType, choice);
        }
    }

    private void buildProperties(Class cls, AbstractComplexType complexType, ExplicitGroup explicitGroup) {
        int i = 0;
        while (i < explicitGroup.getElementsAndGroupsAndAlls().size()) {
            Object obj = explicitGroup.getElementsAndGroupsAndAlls().get(i);
            if (obj instanceof JAXBElement) {
                JAXBElement element = (JAXBElement)obj;
                if (element.getValue() instanceof LocalElement) {
                    LocalElement localElement = (LocalElement)element.getValue();
                    Property property = this.propertyAssembler.buildProperty(cls, complexType, explicitGroup, null, localElement, i);
                    cls.getProperties().add(property);
                    Map<String, Property> classProps = this.support.getClassPropertyMap().get(cls);
                    if (classProps == null) {
                        classProps = new HashMap<String, Property>();
                        this.support.getClassPropertyMap().put(cls, classProps);
                    }
                    classProps.put(property.getName(), property);
                } else if (element.getValue() instanceof ExplicitGroup) {
                    ExplicitGroup childGroup = (ExplicitGroup)element.getValue();
                    int j = 0;
                    while (j < childGroup.getElementsAndGroupsAndAlls().size()) {
                        Object obj2 = childGroup.getElementsAndGroupsAndAlls().get(j);
                        if (obj2 instanceof JAXBElement) {
                            JAXBElement element2 = (JAXBElement)obj2;
                            if (element2.getValue() instanceof LocalElement) {
                                LocalElement localElement = (LocalElement)element2.getValue();
                                Property property = this.propertyAssembler.buildProperty(cls, complexType, explicitGroup, childGroup, localElement, j);
                                cls.getProperties().add(property);
                                Map<String, Property> classProps = this.support.getClassPropertyMap().get(cls);
                                if (classProps == null) {
                                    classProps = new HashMap<String, Property>();
                                    this.support.getClassPropertyMap().put(cls, classProps);
                                }
                                classProps.put(property.getName(), property);
                            } else if (element2.getValue() instanceof ExplicitGroup) {
                                ExplicitGroup grandChildGroup = (ExplicitGroup)element2.getValue();
                                int k = 0;
                                while (k < grandChildGroup.getElementsAndGroupsAndAlls().size()) {
                                    Object obj3 = grandChildGroup.getElementsAndGroupsAndAlls().get(k);
                                    if (obj3 instanceof JAXBElement) {
                                        JAXBElement element3 = (JAXBElement)obj3;
                                        if (element3.getValue() instanceof LocalElement) {
                                            LocalElement localElement = (LocalElement)element3.getValue();
                                            Property property = this.propertyAssembler.buildProperty(cls, complexType, childGroup, grandChildGroup, localElement, k);
                                            cls.getProperties().add(property);
                                            Map<String, Property> classProps = this.support.getClassPropertyMap().get(cls);
                                            if (classProps == null) {
                                                classProps = new HashMap<String, Property>();
                                                this.support.getClassPropertyMap().put(cls, classProps);
                                            }
                                            classProps.put(property.getName(), property);
                                        } else {
                                            log.warn((Object)("unexpected sequence/choice great-grandchild JAXBElement value class, " + element3.getValue().getClass().getName()));
                                        }
                                    }
                                    ++k;
                                }
                            } else {
                                log.warn((Object)("unexpected sequence/choice grandchild JAXBElement value class, " + element2.getValue().getClass().getName()));
                            }
                        }
                        ++j;
                    }
                } else {
                    log.warn((Object)("unexpected choice child JAXBElement value class, " + element.getValue().getClass().getName()));
                }
            } else if (obj instanceof Any) {
                log.debug((Object)("ignoring sequence/choice child class, " + obj.getClass().getName()));
            } else {
                log.warn((Object)("unexpected child class, " + obj.getClass().getName()));
            }
            ++i;
        }
    }

    private void buildProperties(Class cls, AbstractComplexType complexType, List<Annotated> annotatedList) {
        for (Annotated annot : annotatedList) {
            if (annot instanceof Attribute) {
                Attribute attribute = (Attribute)annot;
                Property property = this.propertyAssembler.buildDatatypeProperty(cls, complexType, attribute);
                cls.getProperties().add(property);
                Map<String, Property> classProps = this.support.getClassPropertyMap().get(cls);
                if (classProps == null) {
                    classProps = new HashMap<String, Property>();
                    this.support.getClassPropertyMap().put(cls, classProps);
                }
                classProps.put(property.getName(), property);
                continue;
            }
            if (annot instanceof AttributeGroupRef) {
                AttributeGroupRef ref = (AttributeGroupRef)annot;
                AttributeGroup attrGroup = this.support.getAttributeGroupMap().get(ref.getRef().getLocalPart());
                if (attrGroup == null) {
                    throw new IllegalStateException("no top level attribute group found for, " + ref.getRef().getLocalPart());
                }
                for (Annotated annot2 : attrGroup.getAttributesAndAttributeGroups()) {
                    if (annot2 instanceof Attribute) {
                        Attribute attribute = (Attribute)annot2;
                        Property property = this.propertyAssembler.buildDatatypeProperty(cls, complexType, attribute);
                        cls.getProperties().add(property);
                        Map<String, Property> classProps = this.support.getClassPropertyMap().get(cls);
                        if (classProps == null) {
                            classProps = new HashMap<String, Property>();
                            this.support.getClassPropertyMap().put(cls, classProps);
                        }
                        classProps.put(property.getName(), property);
                        continue;
                    }
                    throw new IllegalStateException("unexpected AttributeGroup child class, " + annot2.getClass().getName());
                }
                continue;
            }
            throw new IllegalStateException("unexpected ComplexType child class, " + annot.getClass().getName());
        }
    }
}

