/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.access.provider.common;

import commonj.sdo.Type;
import org.plasma.query.model.Path;
import org.plasma.query.model.Property;
import org.plasma.query.model.Select;
import org.plasma.query.visitor.DefaultQueryVisitor;
import org.plasma.sdo.PlasmaDataObject;
import org.plasma.sdo.access.DataAccessException;

public class DataObjectHashKeyAssembler
extends DefaultQueryVisitor {
    private Select select;
    private PlasmaDataObject root;
    private Type rootType;
    private StringBuffer hashKey = new StringBuffer("24");

    private DataObjectHashKeyAssembler() {
    }

    public DataObjectHashKeyAssembler(Select select, Type rootType) {
        this.select = select;
        this.rootType = rootType;
    }

    public String getHashKey(PlasmaDataObject v) {
        this.reset();
        this.root = v;
        this.select.accept(this);
        return this.hashKey.toString();
    }

    public void reset() {
        this.hashKey = new StringBuffer("24");
    }

    @Override
    public void start(Property property) {
        Type contextType = this.rootType;
        PlasmaDataObject contextValueObject = this.root;
        if (property.getPath() != null) {
            Path path = property.getPath();
            int i = 0;
            while (i < path.getPathNodes().size()) {
                commonj.sdo.Property contextProp = contextType.getProperty(path.getPathNodes().get(i).getPathElement().getValue());
                if (contextProp.isMany()) {
                    throw new DataAccessException("traversal of milti-valued properties not supported");
                }
                contextType = contextProp.getOpposite().getContainingType();
                if ((contextValueObject = (PlasmaDataObject)contextValueObject.get(contextProp.getName())) == null) break;
                ++i;
            }
        }
        commonj.sdo.Property endpointPDef = contextType.getProperty(property.getName());
        if (contextValueObject != null) {
            Object endpoint = contextValueObject.get(endpointPDef.getName());
            this.hashKey.append(String.valueOf(endpoint));
        }
        super.start(property);
    }
}

