/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.text.lang3gl.java;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.config.Namespace;
import org.plasma.config.PlasmaConfig;
import org.plasma.metamodel.Class;
import org.plasma.metamodel.ClassRef;
import org.plasma.metamodel.Package;
import org.plasma.text.lang3gl.ClassNameResolver;
import org.plasma.text.lang3gl.java.DefaultNameResolver;

public class SDOEnumerationNameResolver
extends DefaultNameResolver
implements ClassNameResolver {
    private static Log log = LogFactory.getLog(SDOEnumerationNameResolver.class);

    @Override
    public String getName(Class clss) {
        if (clss.getAlias() != null && clss.getAlias().getLocalName() != null) {
            return clss.getAlias().getLocalName();
        }
        return clss.getName();
    }

    @Override
    public String getQualifiedName(Class clss, Package pkg) {
        String className = null;
        className = clss.getAlias() != null && clss.getAlias().getLocalName() != null ? clss.getAlias().getLocalName() : clss.getName();
        String pkgName = null;
        pkgName = pkg.getAlias() != null && pkg.getAlias().getLocalName() != null ? pkg.getAlias().getLocalName() : pkg.getName();
        StringBuilder qualifiedName = new StringBuilder();
        qualifiedName.append(pkgName);
        qualifiedName.append(".");
        qualifiedName.append(className);
        String result = qualifiedName.toString();
        return result;
    }

    @Override
    public String getQualifiedName(ClassRef clssRef) {
        Namespace sdoNamespace = PlasmaConfig.getInstance().getSDONamespaceByURI(clssRef.getUri());
        String packageName = sdoNamespace.getProvisioning().getPackageName();
        StringBuilder qualifiedName = new StringBuilder();
        qualifiedName.append(packageName);
        qualifiedName.append(".");
        qualifiedName.append(clssRef.getName());
        return qualifiedName.toString();
    }
}

