/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.text.lang3gl.java;

import java.util.TreeMap;
import org.plasma.config.InterfaceProvisioning;
import org.plasma.config.Namespace;
import org.plasma.config.PlasmaConfig;
import org.plasma.metamodel.Class;
import org.plasma.metamodel.ClassRef;
import org.plasma.metamodel.Package;
import org.plasma.metamodel.Property;
import org.plasma.sdo.PlasmaDataObject;
import org.plasma.text.TextBuilder;
import org.plasma.text.TextProvisioningException;
import org.plasma.text.lang3gl.InterfaceFactory;
import org.plasma.text.lang3gl.Lang3GLContext;
import org.plasma.text.lang3gl.java.MetaClassInfo;
import org.plasma.text.lang3gl.java.SDODefaultFactory;
import org.plasma.text.lang3gl.java.SDOInterfaceNameResolver;

public class SDOInterfaceFactory
extends SDODefaultFactory
implements InterfaceFactory {
    public SDOInterfaceFactory(Lang3GLContext context) {
        super(context);
    }

    @Override
    public String createContent(Package pkg, Class clss) {
        TextBuilder buf = new TextBuilder(LINE_SEP, this.context.getIndentationToken());
        buf.append(this.createPackageDeclaration(pkg));
        buf.append(LINE_SEP);
        buf.append(this.createThirdPartyImportDeclarations(pkg, clss));
        buf.append(LINE_SEP);
        buf.append(this.createSDOInterfaceReferenceImportDeclarations(pkg, clss));
        buf.append(LINE_SEP);
        buf.append(LINE_SEP);
        buf.append(this.createTypeDeclaration(pkg, clss));
        buf.append(LINE_SEP);
        buf.append(this.beginBody());
        buf.append(LINE_SEP);
        buf.append(this.createStaticFieldDeclarations(pkg, clss));
        buf.append(LINE_SEP);
        buf.append(this.createMethodDeclarations(clss));
        for (Property field : clss.getProperties()) {
            buf.append(LINE_SEP);
            buf.append(this.createMethodDeclarations(clss, field));
        }
        buf.append(LINE_SEP);
        buf.append(this.endBody());
        return buf.toString();
    }

    protected String createThirdPartyImportDeclarations(Package pkg, Class clss) {
        TextBuilder buf = new TextBuilder(LINE_SEP, this.context.getIndentationToken());
        return buf.toString();
    }

    protected String createTypeDeclaration(Package pkg, Class clss) {
        TextBuilder buf = new TextBuilder(LINE_SEP, this.context.getIndentationToken());
        String javadoc = this.createTypeDeclarationJavadoc(pkg, clss);
        buf.append(javadoc);
        SDOInterfaceNameResolver interfaceResolver = new SDOInterfaceNameResolver();
        buf.append(LINE_SEP);
        buf.append("public interface ");
        buf.append(interfaceResolver.getName(clss));
        buf.append(" extends ");
        if (clss.getSuperClasses() != null && clss.getSuperClasses().size() > 0) {
            int i = 0;
            for (ClassRef ref : clss.getSuperClasses()) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(ref.getName());
                ++i;
            }
        } else {
            buf.append(PlasmaDataObject.class.getSimpleName());
        }
        return buf.toString();
    }

    private String createTypeDeclarationJavadoc(Package pkg, Class clss) {
        TextBuilder buf = new TextBuilder(LINE_SEP, this.context.getIndentationToken());
        buf.append("/**");
        String docs = this.getWrappedDocmentations(clss.getDocumentations(), 0);
        if (docs.trim().length() > 0) {
            buf.append(docs);
            buf.append(this.newline(0));
            buf.append(" * <p></p>");
        }
        buf.append(this.newline(0));
        buf.append(" * Generated interface representing the domain model entity <b>");
        buf.append(clss.getName());
        buf.append("</b>. This <a href=\"http://plasma-sdo.org\">SDO</a> interface directly reflects the");
        buf.append(this.newline(0));
        buf.append(" * class (single or multiple) inheritance lattice of the source domain model(s) ");
        buf.append(" and is part of namespace <b>");
        buf.append(clss.getUri());
        buf.append("</b> defined within the <a href=\"http://docs.plasma-sdo.org/api/org/plasma/config/package-summary.html\">Configuration</a>.");
        if (clss.getAlias() != null && clss.getAlias().getPhysicalName() != null) {
            buf.append(this.newline(0));
            buf.append(" *");
            buf.append(this.newline(0));
            buf.append(" * <p></p>");
            buf.append(this.newline(0));
            buf.append(" * <b>Data Store Mapping:</b>");
            buf.append(this.newline(0));
            buf.append(" * Corresponds to the physical data store entity <b>");
            buf.append(clss.getAlias().getPhysicalName());
            buf.append("</b>.");
            buf.append(this.newline(0));
            buf.append(" * <p></p>");
            buf.append(this.newline(0));
            buf.append(" *");
        }
        TreeMap<String, Class> classMap = new TreeMap<String, Class>();
        if (clss.getSuperClasses() != null && clss.getSuperClasses().size() > 0) {
            this.collectProvisioningSuperclasses(pkg, clss, classMap);
        }
        this.collectProvisioningClasses(pkg, clss, classMap);
        for (Class refClass : classMap.values()) {
            Namespace sdoNamespace = PlasmaConfig.getInstance().getSDONamespaceByURI(refClass.getUri());
            String packageName = sdoNamespace.getProvisioning().getPackageName();
            String packageQualifiedName = String.valueOf(packageName) + "." + refClass.getName();
            buf.append(this.newline(0));
            buf.append(" * @see ");
            buf.append(packageQualifiedName);
            buf.append(" ");
            buf.append(refClass.getName());
        }
        buf.append(this.newline(0));
        buf.append(" */");
        return buf.toString();
    }

    protected String createStaticFieldDeclarations(Package pkg, Class clss) {
        InterfaceProvisioning interfaceProvisioning = PlasmaConfig.getInstance().getSDOInterfaceProvisioning(pkg.getUri());
        if (interfaceProvisioning == null) {
            interfaceProvisioning = this.globalInterfaceProvisioning;
        }
        TextBuilder buf = new TextBuilder(LINE_SEP, this.context.getIndentationToken());
        buf.appendln(1, "/** The <a href=\"http://plasma-sdo.org\">SDO</a> namespace URI associated with the <a href=\"http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html\">Type</a> for this class. */");
        buf.appendln(1, "public static final String NAMESPACE_URI = \"");
        buf.append(clss.getUri());
        buf.append("\";");
        buf.append(LINE_SEP);
        buf.appendln(1, "/** The entity or <a href=\"http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html\">Type</a> logical name associated with this class. */");
        buf.appendln(1, "public static final String TYPE_NAME_");
        buf.append(this.toConstantName(clss.getName()));
        buf.append(" = \"");
        buf.append(clss.getName());
        buf.append("\";");
        buf.appendln(1, "");
        block0 : switch (interfaceProvisioning.getPropertyNameStyle()) {
            case ENUMS: {
                switch (interfaceProvisioning.getEnumSource()) {
                    case DERIVED: {
                        buf.appendln(1, "/** The declared logical property names for this <a href=\"http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html\">Type</a>. */");
                        buf.appendln(1, "public static enum PROPERTY {");
                        int enumCount = 0;
                        for (Property field : clss.getProperties()) {
                            if (enumCount > 0) {
                                buf.append(",");
                            }
                            buf.append(this.newline(2));
                            String javadoc = this.createStaticFieldDeclarationJavadoc(clss, field, 2);
                            buf.append(javadoc);
                            buf.append(this.newline(2));
                            buf.append(field.getName());
                            ++enumCount;
                        }
                        buf.appendln(1, "}");
                        break block0;
                    }
                    case EXTERNAL: {
                        break block0;
                    }
                }
                throw new TextProvisioningException("unexpected enum source, " + interfaceProvisioning.getEnumSource());
            }
            case CONSTANTS: {
                buf.appendln(1, "");
                for (Property field : clss.getProperties()) {
                    String javadoc = this.createStaticFieldDeclarationJavadoc(clss, field, 1);
                    buf.appendln(1, javadoc);
                    buf.appendln(1, "public static final String ");
                    buf.append(this.toConstantName(field.getName()));
                    buf.append(" = \"");
                    buf.append(field.getName());
                    buf.append("\";");
                }
                buf.appendln(1, "");
            }
        }
        return buf.toString();
    }

    private String createStaticFieldDeclarationJavadoc(Class clss, Property field, int indent) {
        TextBuilder buf = new TextBuilder(LINE_SEP, this.context.getIndentationToken());
        buf.append(this.newline(indent));
        buf.append("/**");
        String docs = this.getWrappedDocmentations(field.getDocumentations(), indent);
        if (docs.trim().length() > 0) {
            buf.append(docs);
            buf.append(this.newline(indent));
            buf.append(" * <p></p>");
            buf.append(this.newline(indent));
            buf.append(" *");
        }
        buf.append(this.newline(indent));
        buf.append(" * Represents the logical <a href=\"http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaProperty.html\">Property</a> <b>");
        buf.append(field.getName());
        buf.append("</b> which is part of the <a href=\"http://docs.plasma-sdo.org/api/org/plasma/sdo/PlasmaType.html\">Type</a> <b>");
        buf.append(clss.getName());
        buf.append("</b>.");
        if (clss.getAlias() != null && clss.getAlias().getPhysicalName() != null && field.getAlias() != null && field.getAlias().getPhysicalName() != null) {
            buf.append(this.newline(indent));
            buf.append(" *");
            buf.append(this.newline(indent));
            buf.append(" * <p></p>");
            buf.append(this.newline(indent));
            buf.append(" * <b>Data Store Mapping:</b>");
            buf.append(this.newline(indent));
            buf.append(" * Corresponds to the physical data store element <b>");
            buf.append(String.valueOf(clss.getAlias().getPhysicalName()) + "." + field.getAlias().getPhysicalName());
            buf.append("</b>.");
        }
        buf.append(this.newline(indent));
        buf.append(" */");
        return buf.toString();
    }

    protected String createMethodDeclarations(Class clss) {
        return "";
    }

    protected String createMethodDeclarations(Class clss, Property field) {
        TextBuilder buf = new TextBuilder(LINE_SEP, this.context.getIndentationToken());
        MetaClassInfo typeClassName = this.getTypeClassName(field.getType());
        buf.append(LINE_SEP);
        this.createIsSetDeclaration(null, clss, field, typeClassName, buf);
        buf.append(";");
        buf.append(LINE_SEP);
        this.createUnsetterDeclaration(null, clss, field, typeClassName, buf);
        buf.append(";");
        if (field.getType() instanceof ClassRef) {
            Class targetClass = this.context.findClass((ClassRef)field.getType());
            if (!targetClass.isAbstract()) {
                buf.append(LINE_SEP);
                this.createCreatorDeclaration(null, clss, field, typeClassName, buf);
                buf.append(";");
            } else {
                buf.append(LINE_SEP);
                this.createCreatorByAbstractClassDeclaration(null, clss, field, typeClassName, buf);
                buf.append(";");
            }
        }
        if (!field.isMany()) {
            buf.append(LINE_SEP);
            this.createSingularGetterDeclaration(null, clss, field, typeClassName, buf);
            buf.append(";");
            buf.append(LINE_SEP);
            this.createSingularSetterDeclaration(null, clss, field, typeClassName, buf);
            buf.append(";");
        } else {
            buf.append(LINE_SEP);
            this.createManyGetterDeclaration(null, clss, field, typeClassName, buf);
            buf.append(";");
            buf.append(LINE_SEP);
            this.createManyIndexGetterDeclaration(null, clss, field, typeClassName, buf);
            buf.append(";");
            buf.append(LINE_SEP);
            this.createManyCountDeclaration(null, clss, field, typeClassName, buf);
            buf.append(";");
            buf.append(LINE_SEP);
            this.createManySetterDeclaration(null, clss, field, typeClassName, buf);
            buf.append(";");
            buf.append(LINE_SEP);
            this.createManyAdderDeclaration(null, clss, field, typeClassName, buf);
            buf.append(";");
            buf.append(LINE_SEP);
            this.createManyRemoverDeclaration(null, clss, field, typeClassName, buf);
            buf.append(";");
        }
        return buf.toString();
    }

    @Override
    public String createFileName(Class clss, Package pkg) {
        SDOInterfaceNameResolver interfaceResolver = new SDOInterfaceNameResolver();
        TextBuilder buf = new TextBuilder(LINE_SEP, this.context.getIndentationToken());
        buf.append(interfaceResolver.getName(clss));
        buf.append(".java");
        return buf.toString();
    }

    @Override
    protected String createSDOInterfaceReferenceImportDeclarations(Package pkg, Class clss) {
        TextBuilder buf = new TextBuilder(LINE_SEP, this.context.getIndentationToken());
        SDOInterfaceNameResolver resolver = new SDOInterfaceNameResolver();
        TreeMap<String, String> nameMap = new TreeMap<String, String>();
        if (clss.getSuperClasses() != null && clss.getSuperClasses().size() > 0) {
            this.collectSuperclassNames(pkg, clss, nameMap, resolver);
        } else {
            nameMap.put(PlasmaDataObject.class.getName(), PlasmaDataObject.class.getName());
        }
        this.collectDataClassNames(pkg, clss, nameMap, resolver);
        this.collectReferenceClassNames(pkg, clss, nameMap, resolver);
        for (String name : nameMap.values()) {
            if (name.startsWith("java.lang.")) continue;
            buf.append(LINE_SEP);
            buf.append("import ");
            buf.append(name);
            buf.append(";");
        }
        return buf.toString();
    }
}

