/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.provisioning.common;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;

public class NamespaceUtils {
    public static String[] toPackageTokens(String uri) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            URL url = new URL(uri);
            String[] authority = url.getAuthority().split("\\.");
            int i = authority.length - 1;
            while (i >= 0) {
                if (authority[i] != null && authority[i].trim().length() > 0) {
                    list.add(authority[i]);
                }
                --i;
            }
            if (url.getPath() != null) {
                String[] path = url.getPath().split("\\/");
                int i2 = 0;
                while (i2 < path.length) {
                    if (path[i2] != null && path[i2].trim().length() > 0) {
                        list.add(path[i2]);
                    }
                    ++i2;
                }
            }
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        String[] result = new String[list.size()];
        list.toArray(result);
        return result;
    }

    public static String toPackageName(String uri) {
        String[] tokens = NamespaceUtils.toPackageTokens(uri);
        StringBuilder buf = new StringBuilder();
        int i = tokens.length - 1;
        while (i >= 0) {
            if (i < tokens.length - 1) {
                buf.append(".");
            }
            buf.append(tokens[i]);
            --i;
        }
        return buf.toString();
    }
}

