/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.helper;

import commonj.sdo.Property;
import commonj.sdo.Type;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.Duration;
import org.joda.time.format.ISOPeriodFormat;
import org.joda.time.format.PeriodFormatter;
import org.plasma.sdo.DataType;
import org.plasma.sdo.PlasmaDataObjectException;
import org.plasma.sdo.helper.InvalidDataConversionException;
import org.plasma.sdo.helper.InvalidDataFormatException;

public class DataConverter {
    private static Log log = LogFactory.getFactory().getInstance(DataConverter.class);
    public static volatile DataConverter INSTANCE = DataConverter.initializeInstance();
    public static final String FORMAT_PATTERN_TIME = "HH:mm:ss'.'SSS'Z'";
    public static final String FORMAT_PATTERN_DATE = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String FORMAT_PATTERN_DATETIME = "yyyy-MM-dd'T'HH:mm:ss'.'SSS'Z'";
    public static final String FORMAT_PATTERN_DAY = "dd";
    public static final String FORMAT_PATTERN_MONTH = "MM";
    public static final String FORMAT_PATTERN_MONTHDAY = "MM-dd";
    public static final String FORMAT_PATTERN_YEAR = "yyyy";
    public static final String FORMAT_PATTERN_YEARMONTH = "yyyy-MM";
    public static final String FORMAT_PATTERN_YEARMONTHDAY = "yyyy-MM-dd";
    private static Map<Class<?>, Map<String, DataType>> javaClassToAllowableTypesMap;
    private static Map<Class<?>, Method> javaClassToConverterFromMethodMap;

    private DataConverter() {
        if (javaClassToAllowableTypesMap == null) {
            javaClassToAllowableTypesMap = new HashMap();
            int i = 0;
            while (i < DataType.values().length) {
                DataType dataTypeEnum = DataType.values()[i];
                Class<?> javaClass = this.toPrimitiveJavaClass(dataTypeEnum);
                HashMap<String, DataType> allowableMap = new HashMap<String, DataType>();
                List<DataType> list = this.getAllowableTargetTypes(dataTypeEnum);
                for (DataType allowableType : list) {
                    allowableMap.put(allowableType.toString(), allowableType);
                }
                javaClassToAllowableTypesMap.put(javaClass, allowableMap);
                ++i;
            }
        }
        if (javaClassToConverterFromMethodMap == null) {
            javaClassToConverterFromMethodMap = new HashMap();
            Map<Class<?>, Method> map = javaClassToConverterFromMethodMap;
            try {
                Method method = this.getClass().getMethod("fromBoolean", Type.class, Boolean.TYPE);
                map.put(Boolean.class, method);
                map.put(Boolean.TYPE, method);
                method = this.getClass().getMethod("fromByte", Type.class, Byte.TYPE);
                map.put(Byte.class, method);
                map.put(Byte.TYPE, method);
                method = this.getClass().getMethod("fromBytes", Type.class, byte[].class);
                map.put(Byte[].class, method);
                map.put(byte[].class, method);
                method = this.getClass().getMethod("fromCharacter", Type.class, Character.TYPE);
                map.put(Character.class, method);
                map.put(Character.TYPE, method);
                method = this.getClass().getMethod("fromDate", Type.class, Date.class);
                map.put(Date.class, method);
                method = this.getClass().getMethod("fromDecimal", Type.class, BigDecimal.class);
                map.put(BigDecimal.class, method);
                method = this.getClass().getMethod("fromDouble", Type.class, Double.TYPE);
                map.put(Double.class, method);
                map.put(Double.TYPE, method);
                method = this.getClass().getMethod("fromFloat", Type.class, Float.TYPE);
                map.put(Float.class, method);
                map.put(Float.TYPE, method);
                method = this.getClass().getMethod("fromInt", Type.class, Integer.TYPE);
                map.put(Integer.TYPE, method);
                map.put(Integer.class, method);
                method = this.getClass().getMethod("fromInteger", Type.class, BigInteger.class);
                map.put(BigInteger.class, method);
                method = this.getClass().getMethod("fromLong", Type.class, Long.TYPE);
                map.put(Long.class, method);
                map.put(Long.TYPE, method);
                method = this.getClass().getMethod("fromShort", Type.class, Short.TYPE);
                map.put(Short.class, method);
                map.put(Short.TYPE, method);
                method = this.getClass().getMethod("fromString", Type.class, String.class);
                map.put(String.class, method);
                method = this.getClass().getMethod("fromStrings", Type.class, List.class);
                map.put(List.class, method);
            }
            catch (NoSuchMethodException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public DateFormat[] getDateFormats() {
        DateFormat[] result = new DateFormat[]{DateFormatMap.get(FORMAT_PATTERN_TIME), DateFormatMap.get(FORMAT_PATTERN_DATE), DateFormatMap.get(FORMAT_PATTERN_DATETIME), DateFormatMap.get(FORMAT_PATTERN_DAY), DateFormatMap.get(FORMAT_PATTERN_MONTH), DateFormatMap.get(FORMAT_PATTERN_MONTHDAY), DateFormatMap.get(FORMAT_PATTERN_YEAR), DateFormatMap.get(FORMAT_PATTERN_YEARMONTH), DateFormatMap.get(FORMAT_PATTERN_YEARMONTHDAY)};
        return result;
    }

    private static synchronized DataConverter initializeInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DataConverter();
        }
        return INSTANCE;
    }

    public DateFormat getDateTimeFormat() {
        return DateFormatMap.get(FORMAT_PATTERN_DATETIME);
    }

    public DateFormat getTimeFormat() {
        return DateFormatMap.get(FORMAT_PATTERN_TIME);
    }

    public DateFormat getDateFormat() {
        return DateFormatMap.get(FORMAT_PATTERN_DATE);
    }

    public PeriodFormatter getDurationFormat() {
        return ISOPeriodFormat.standard();
    }

    public DateFormat getDayFormat() {
        return DateFormatMap.get(FORMAT_PATTERN_DAY);
    }

    public DateFormat getMonthFormat() {
        return DateFormatMap.get(FORMAT_PATTERN_MONTH);
    }

    public DateFormat getMonthDayFormat() {
        return DateFormatMap.get(FORMAT_PATTERN_MONTHDAY);
    }

    public DateFormat getYearFormat() {
        return DateFormatMap.get(FORMAT_PATTERN_YEAR);
    }

    public DateFormat getYearMonthFormat() {
        return DateFormatMap.get(FORMAT_PATTERN_YEARMONTH);
    }

    public DateFormat getYearMonthDayFormat() {
        return DateFormatMap.get(FORMAT_PATTERN_DAY);
    }

    public Object convert(Type targetType, Object value) {
        if (!targetType.isDataType()) {
            throw new IllegalArgumentException("type " + targetType.getURI() + "#" + targetType.getName() + " is not a data-type");
        }
        Method method = javaClassToConverterFromMethodMap.get(value.getClass());
        try {
            return method.invoke((Object)this, targetType, value);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof InvalidDataConversionException) {
                throw (InvalidDataConversionException)e.getTargetException();
            }
            throw new RuntimeException(e.getTargetException());
        }
    }

    public Object convert(Type targetType, Type sourceType, Object value) {
        if (!targetType.isDataType()) {
            throw new IllegalArgumentException("type " + targetType.getURI() + "#" + targetType.getName() + " is not a data-type");
        }
        if (!sourceType.isDataType()) {
            throw new IllegalArgumentException("type " + sourceType.getURI() + "#" + sourceType.getName() + " is not a data-type");
        }
        DataType targetDataType = DataType.valueOf((String)targetType.getName());
        DataType sourceDataType = DataType.valueOf((String)sourceType.getName());
        switch (targetDataType) {
            case Boolean: {
                return this.toBoolean(sourceType, value);
            }
            case Byte: {
                return this.toByte(sourceType, value);
            }
            case Bytes: {
                return this.toBytes(sourceType, value);
            }
            case Character: {
                return Character.valueOf(this.toCharacter(sourceType, value));
            }
            case Decimal: {
                return this.toDecimal(sourceType, value);
            }
            case Double: {
                return this.toDouble(sourceType, value);
            }
            case Float: {
                return Float.valueOf(this.toFloat(sourceType, value));
            }
            case Int: {
                return this.toInt(sourceType, value);
            }
            case Integer: {
                return this.toInteger(sourceType, value);
            }
            case Long: {
                return this.toLong(sourceType, value);
            }
            case Short: {
                return this.toShort(sourceType, value);
            }
            case String: {
                return this.toString(sourceType, value);
            }
            case Strings: {
                return this.toStrings(sourceType, value);
            }
            case Date: {
                return this.toDate(sourceType, value);
            }
            case DateTime: 
            case Day: 
            case Duration: 
            case Month: 
            case MonthDay: 
            case Time: 
            case Year: 
            case YearMonth: 
            case YearMonthDay: {
                return this.toTemporalDataType(targetType, sourceType, value);
            }
        }
        throw new InvalidDataConversionException(targetDataType, sourceDataType, value);
    }

    public boolean toBoolean(Type sourceType, Object value) {
        DataType sourceDataType = DataType.valueOf((String)sourceType.getName());
        switch (sourceDataType) {
            case Boolean: {
                return (Boolean)value;
            }
            case String: {
                return Boolean.parseBoolean(value.toString());
            }
        }
        throw new InvalidDataConversionException(DataType.Boolean, sourceDataType, value);
    }

    public Object fromBoolean(Type targetType, boolean value) {
        DataType targetDataType = DataType.valueOf((String)targetType.getName());
        switch (targetDataType) {
            case Boolean: {
                return value;
            }
            case String: {
                return String.valueOf(value);
            }
        }
        throw new InvalidDataConversionException(targetDataType, DataType.Boolean, value);
    }

    public byte toByte(Type sourceType, Object value) {
        DataType sourceDataType = DataType.valueOf((String)sourceType.getName());
        switch (sourceDataType) {
            case Byte: {
                return (Byte)value;
            }
            case Double: {
                return ((Double)value).byteValue();
            }
            case Float: {
                return ((Float)value).byteValue();
            }
            case Int: {
                return ((Integer)value).byteValue();
            }
            case Long: {
                return ((Long)value).byteValue();
            }
            case Short: {
                return ((Short)value).byteValue();
            }
            case String: {
                return Integer.valueOf((String)value).byteValue();
            }
        }
        throw new InvalidDataConversionException(DataType.Byte, sourceDataType, value);
    }

    public Object fromByte(Type targetType, byte value) {
        DataType targetDataType = DataType.valueOf((String)targetType.getName());
        switch (targetDataType) {
            case Byte: {
                return value;
            }
            case Double: {
                return (double)(value & 0xFF);
            }
            case Float: {
                return Float.valueOf(value & 0xFF);
            }
            case Int: {
                return value & 0xFF;
            }
            case Long: {
                return (long)(value & 0xFF);
            }
            case Short: {
                return new Short(Integer.valueOf(value & 0xFF).shortValue());
            }
            case String: {
                return Integer.valueOf(value & 0xFF).toString();
            }
        }
        throw new InvalidDataConversionException(targetDataType, DataType.Byte, value);
    }

    public byte[] toBytes(Type sourceType, Object value) {
        DataType sourceDataType = DataType.valueOf((String)sourceType.getName());
        switch (sourceDataType) {
            case Bytes: {
                return (byte[])value;
            }
            case String: {
                return ((String)value).getBytes();
            }
            case Integer: {
                return ((BigInteger)value).toByteArray();
            }
        }
        throw new InvalidDataConversionException(DataType.Bytes, sourceDataType, value);
    }

    public Object fromBytes(Type targetType, byte[] value) {
        DataType targetDataType = DataType.valueOf((String)targetType.getName());
        switch (targetDataType) {
            case Bytes: {
                return value;
            }
            case String: {
                return this.toHexString(value);
            }
            case Integer: {
                return new BigInteger(value);
            }
        }
        throw new InvalidDataConversionException(targetDataType, DataType.Bytes, value);
    }

    public char toCharacter(Type sourceType, Object value) {
        DataType sourceDataType = DataType.valueOf((String)sourceType.getName());
        switch (sourceDataType) {
            case Character: {
                return ((Character)value).charValue();
            }
            case String: {
                return ((String)value).charAt(0);
            }
        }
        throw new InvalidDataConversionException(DataType.Character, sourceDataType, value);
    }

    public Object fromCharacter(Type targetType, char value) {
        DataType targetDataType = DataType.valueOf((String)targetType.getName());
        switch (targetDataType) {
            case Character: {
                return Character.valueOf(value);
            }
            case String: {
                return String.valueOf(value);
            }
        }
        throw new InvalidDataConversionException(targetDataType, DataType.Character, Character.valueOf(value));
    }

    public BigDecimal toDecimal(Type sourceType, Object value) {
        DataType sourceDataType = DataType.valueOf((String)sourceType.getName());
        switch (sourceDataType) {
            case Decimal: {
                return (BigDecimal)value;
            }
            case Double: 
            case Float: 
            case Int: 
            case Integer: 
            case Long: {
                return new BigDecimal(((Number)value).doubleValue());
            }
            case String: {
                return new BigDecimal((String)value);
            }
        }
        throw new InvalidDataConversionException(DataType.Decimal, sourceDataType, value);
    }

    public Object fromDecimal(Type targetType, BigDecimal value) {
        DataType targetDataType = DataType.valueOf((String)targetType.getName());
        switch (targetDataType) {
            case Decimal: {
                return value;
            }
            case Double: {
                return new Double(value.doubleValue());
            }
            case Float: {
                return new Float(value.floatValue());
            }
            case Int: {
                return new Integer(value.intValue());
            }
            case Long: {
                return new Long(value.longValue());
            }
            case Integer: {
                return value.toBigInteger();
            }
            case String: {
                return value.toString();
            }
        }
        throw new InvalidDataConversionException(targetDataType, DataType.Decimal, value);
    }

    public double toDouble(Type sourceType, Object value) {
        DataType sourceDataType = DataType.valueOf((String)sourceType.getName());
        switch (sourceDataType) {
            case Double: {
                return (Double)value;
            }
            case Byte: {
                return ((Byte)value).doubleValue();
            }
            case Float: {
                return ((Float)value).doubleValue();
            }
            case Int: {
                return ((Integer)value).doubleValue();
            }
            case Long: {
                return ((Long)value).doubleValue();
            }
            case Short: {
                return ((Short)value).doubleValue();
            }
            case Integer: {
                return ((BigInteger)value).doubleValue();
            }
            case Decimal: {
                return ((BigDecimal)value).doubleValue();
            }
            case String: {
                return Double.parseDouble((String)value);
            }
        }
        throw new InvalidDataConversionException(DataType.Double, sourceDataType, value);
    }

    public Object fromDouble(Type targetType, double value) {
        DataType targetDataType = DataType.valueOf((String)targetType.getName());
        switch (targetDataType) {
            case Double: {
                return value;
            }
            case Byte: {
                return new Byte(Double.valueOf(value).byteValue());
            }
            case Float: {
                return new Float(Double.valueOf(value).floatValue());
            }
            case Int: {
                return new Integer(Double.valueOf(value).intValue());
            }
            case Long: {
                return new Long(Double.valueOf(value).longValue());
            }
            case Short: {
                return new Short(Double.valueOf(value).shortValue());
            }
            case Integer: {
                return BigInteger.valueOf(Double.valueOf(value).longValue());
            }
            case Decimal: {
                return BigDecimal.valueOf(value);
            }
            case String: {
                return Double.toString(value);
            }
        }
        throw new InvalidDataConversionException(targetDataType, DataType.Double, value);
    }

    public float toFloat(Type sourceType, Object value) {
        DataType sourceDataType = DataType.valueOf((String)sourceType.getName());
        switch (sourceDataType) {
            case Float: {
                return ((Float)value).floatValue();
            }
            case Byte: {
                return ((Byte)value).floatValue();
            }
            case Double: {
                return ((Double)value).floatValue();
            }
            case Int: {
                return ((Integer)value).floatValue();
            }
            case Long: {
                return ((Long)value).floatValue();
            }
            case Short: {
                return ((Short)value).floatValue();
            }
            case Decimal: {
                return ((BigDecimal)value).floatValue();
            }
            case Integer: {
                return ((BigInteger)value).floatValue();
            }
            case String: {
                return Float.valueOf((String)value).floatValue();
            }
        }
        throw new InvalidDataConversionException(DataType.Float, sourceDataType, value);
    }

    public Object fromFloat(Type targetType, float value) {
        DataType targetDataType = DataType.valueOf((String)targetType.getName());
        switch (targetDataType) {
            case Float: {
                return Float.valueOf(value);
            }
            case Byte: {
                return new Byte(Float.valueOf(value).byteValue());
            }
            case Double: {
                return new Double(Float.valueOf(value).doubleValue());
            }
            case Int: {
                return new Integer(Float.valueOf(value).intValue());
            }
            case Long: {
                return new Long(Float.valueOf(value).longValue());
            }
            case Short: {
                return new Short(Float.valueOf(value).shortValue());
            }
            case Decimal: {
                return BigDecimal.valueOf(value);
            }
            case Integer: {
                return BigInteger.valueOf(Double.valueOf(value).longValue());
            }
            case String: {
                return Float.toString(value);
            }
        }
        throw new InvalidDataConversionException(targetDataType, DataType.Float, Float.valueOf(value));
    }

    public int toInt(Type sourceType, Object value) {
        DataType sourceDataType = DataType.valueOf((String)sourceType.getName());
        switch (sourceDataType) {
            case Int: {
                return (Integer)value;
            }
            case Byte: {
                return ((Byte)value).intValue();
            }
            case Double: {
                return ((Double)value).intValue();
            }
            case Float: {
                return ((Float)value).intValue();
            }
            case Long: {
                return ((Long)value).intValue();
            }
            case Short: {
                return ((Short)value).intValue();
            }
            case Decimal: {
                return ((BigDecimal)value).intValue();
            }
            case Integer: {
                return ((BigInteger)value).intValue();
            }
            case String: {
                return Integer.parseInt((String)value);
            }
        }
        throw new InvalidDataConversionException(DataType.Int, sourceDataType, value);
    }

    public Object fromInt(Type targetType, int value) {
        DataType targetDataType = DataType.valueOf((String)targetType.getName());
        switch (targetDataType) {
            case Int: {
                return value;
            }
            case Byte: {
                return new Byte(Integer.valueOf(value).byteValue());
            }
            case Double: {
                return new Double(Integer.valueOf(value).doubleValue());
            }
            case Float: {
                return new Float(Integer.valueOf(value).floatValue());
            }
            case Long: {
                return new Long(Integer.valueOf(value).longValue());
            }
            case Short: {
                return new Short(Integer.valueOf(value).shortValue());
            }
            case Decimal: {
                return BigDecimal.valueOf(value);
            }
            case Integer: {
                return BigInteger.valueOf(Integer.valueOf(value).longValue());
            }
            case String: {
                return Integer.toString(value);
            }
        }
        throw new InvalidDataConversionException(targetDataType, DataType.Int, value);
    }

    public BigInteger toInteger(Type sourceType, Object value) {
        DataType sourceDataType = DataType.valueOf((String)sourceType.getName());
        switch (sourceDataType) {
            case Integer: {
                return (BigInteger)value;
            }
            case Double: {
                return BigInteger.valueOf(((Double)value).longValue());
            }
            case Float: {
                return BigInteger.valueOf(((Float)value).longValue());
            }
            case Int: {
                return BigInteger.valueOf(((Integer)value).longValue());
            }
            case Long: {
                return BigInteger.valueOf((Long)value);
            }
            case Decimal: {
                return BigInteger.valueOf(((BigDecimal)value).longValue());
            }
            case Bytes: {
                return new BigInteger((byte[])value);
            }
            case String: {
                return new BigInteger((String)value);
            }
        }
        throw new InvalidDataConversionException(DataType.Integer, sourceDataType, value);
    }

    public Object fromInteger(Type targetType, BigInteger value) {
        DataType targetDataType = DataType.valueOf((String)targetType.getName());
        switch (targetDataType) {
            case Integer: {
                return value;
            }
            case Double: {
                return new Double(value.doubleValue());
            }
            case Float: {
                return new Float(value.floatValue());
            }
            case Int: {
                return new Integer(value.intValue());
            }
            case Long: {
                return new Long(value.longValue());
            }
            case Decimal: {
                return new BigDecimal(value.doubleValue());
            }
            case Bytes: {
                return value.toByteArray();
            }
            case String: {
                return value.toString();
            }
        }
        throw new InvalidDataConversionException(targetDataType, DataType.Integer, value);
    }

    public long toLong(Type sourceType, Object value) {
        DataType sourceDataType = DataType.valueOf((String)sourceType.getName());
        switch (sourceDataType) {
            case Long: {
                return (Long)value;
            }
            case Byte: {
                return ((Byte)value).longValue();
            }
            case Double: {
                return ((Double)value).longValue();
            }
            case Float: {
                return ((Float)value).longValue();
            }
            case Int: {
                return ((Integer)value).longValue();
            }
            case Short: {
                return ((Short)value).longValue();
            }
            case Decimal: {
                return ((BigDecimal)value).longValue();
            }
            case Integer: {
                return ((BigInteger)value).longValue();
            }
            case Date: {
                return ((Date)value).getTime();
            }
            case String: {
                return Long.parseLong((String)value);
            }
        }
        throw new InvalidDataConversionException(DataType.Long, sourceDataType, value);
    }

    public Object fromLong(Type targetType, long value) {
        DataType targetDataType = DataType.valueOf((String)targetType.getName());
        switch (targetDataType) {
            case Long: {
                return value;
            }
            case Byte: {
                return new Byte(Long.valueOf(value).byteValue());
            }
            case Double: {
                return new Double(Long.valueOf(value).doubleValue());
            }
            case Float: {
                return new Float(Long.valueOf(value).floatValue());
            }
            case Int: {
                return new Integer(Long.valueOf(value).intValue());
            }
            case Short: {
                return new Short(Long.valueOf(value).shortValue());
            }
            case Decimal: {
                return new BigDecimal(value);
            }
            case Integer: {
                return BigInteger.valueOf(value);
            }
            case Date: {
                return new Date(value);
            }
            case String: {
                return Long.toString(value);
            }
        }
        throw new InvalidDataConversionException(targetDataType, DataType.Long, value);
    }

    public short toShort(Type sourceType, Object value) {
        DataType sourceDataType = DataType.valueOf((String)sourceType.getName());
        switch (sourceDataType) {
            case Short: {
                return (Short)value;
            }
            case Byte: {
                return ((Byte)value).shortValue();
            }
            case Double: {
                return ((Double)value).shortValue();
            }
            case Float: {
                return ((Float)value).shortValue();
            }
            case Int: {
                return ((Integer)value).shortValue();
            }
            case Long: {
                return ((Long)value).shortValue();
            }
            case String: {
                return Short.parseShort((String)value);
            }
        }
        throw new InvalidDataConversionException(DataType.Short, sourceDataType, value);
    }

    public Object fromShort(Type targetType, short value) {
        DataType targetDataType = DataType.valueOf((String)targetType.getName());
        switch (targetDataType) {
            case Short: {
                return value;
            }
            case Byte: {
                return new Byte(Short.valueOf(value).byteValue());
            }
            case Double: {
                return new Double(Short.valueOf(value).doubleValue());
            }
            case Float: {
                return new Float(Short.valueOf(value).floatValue());
            }
            case Int: {
                return new Integer(Short.valueOf(value).intValue());
            }
            case Long: {
                return new Long(Short.valueOf(value).longValue());
            }
            case String: {
                return Short.valueOf(value).toString();
            }
        }
        throw new InvalidDataConversionException(targetDataType, DataType.Short, value);
    }

    public String toString(Type sourceType, Object value) {
        DataType sourceDataType = DataType.valueOf((String)sourceType.getName());
        switch (sourceDataType) {
            case DateTime: 
            case Day: 
            case Duration: 
            case Month: 
            case MonthDay: 
            case String: 
            case Time: 
            case URI: 
            case Year: 
            case YearMonth: 
            case YearMonthDay: {
                if (value instanceof String) {
                    return (String)value;
                }
                if (value instanceof List) {
                    List list = (List)value;
                    for (Object listValue : (List)value) {
                        if (listValue instanceof String) continue;
                        this.throwExpectedInstance(sourceDataType, String.class, listValue.getClass());
                    }
                    return Arrays.toString(list.toArray());
                }
                this.throwExpectedInstance(sourceDataType, String.class, value.getClass());
            }
            case Decimal: {
                if (value instanceof BigDecimal) {
                    return ((BigDecimal)value).toString();
                }
                if (value instanceof List) {
                    List list = (List)value;
                    for (Object listValue : (List)value) {
                        if (listValue instanceof BigDecimal) continue;
                        this.throwExpectedInstance(sourceDataType, BigDecimal.class, listValue.getClass());
                    }
                    return Arrays.toString(list.toArray());
                }
                this.throwExpectedInstance(sourceDataType, BigDecimal.class, value.getClass());
            }
            case Bytes: {
                if (value instanceof byte[]) {
                    return this.toHexString((byte[])value);
                }
                if (value instanceof List) {
                    ArrayList<String> result = new ArrayList<String>();
                    List list = (List)value;
                    for (Object listValue : list) {
                        if (!(listValue instanceof byte[])) {
                            this.throwExpectedInstance(sourceDataType, byte[].class, listValue.getClass());
                        }
                        result.add(this.toHexString((byte[])listValue));
                    }
                    return Arrays.toString(result.toArray());
                }
                this.throwExpectedInstance(sourceDataType, byte[].class, value.getClass());
            }
            case Byte: {
                if (value instanceof Byte) {
                    return Integer.valueOf((Byte)value & 0xFF).toString();
                }
                if (value instanceof List) {
                    ArrayList<String> result = new ArrayList<String>();
                    List list = (List)value;
                    for (Object listValue : list) {
                        if (!(listValue instanceof Byte)) {
                            this.throwExpectedInstance(sourceDataType, Byte.class, listValue.getClass());
                        }
                        result.add(Integer.valueOf((Byte)listValue & 0xFF).toString());
                    }
                    return Arrays.toString(result.toArray());
                }
                this.throwExpectedInstance(sourceDataType, Byte.class, value.getClass());
            }
            case Boolean: {
                return this.toString(sourceDataType, Boolean.class, value);
            }
            case Character: {
                return this.toString(sourceDataType, Character.class, value);
            }
            case Double: {
                return this.toString(sourceDataType, Double.class, value);
            }
            case Float: {
                return this.toString(sourceDataType, Float.class, value);
            }
            case Int: {
                return this.toString(sourceDataType, Integer.class, value);
            }
            case Integer: {
                return this.toString(sourceDataType, BigInteger.class, value);
            }
            case Long: {
                return this.toString(sourceDataType, Long.class, value);
            }
            case Short: {
                return this.toString(sourceDataType, Short.class, value);
            }
            case Strings: {
                if (!(value instanceof List)) {
                    throw new IllegalArgumentException("expected value as class " + List.class.getName() + ", not " + value.getClass().getName() + ", for datatype '" + sourceDataType.name() + "'");
                }
                StringBuffer buf = new StringBuffer();
                List list = (List)value;
                Iterator iter = list.iterator();
                int i = 0;
                while (iter.hasNext()) {
                    if (i > 0) {
                        buf.append(" ");
                    }
                    buf.append((String)iter.next());
                    ++i;
                }
                return buf.toString();
            }
            case Date: {
                if (value instanceof Date) {
                    return this.getDateFormat().format(value);
                }
                if (value instanceof List) {
                    ArrayList<String> result = new ArrayList<String>();
                    List dateList = (List)value;
                    for (Object listValue : dateList) {
                        if (!(listValue instanceof Date)) {
                            this.throwExpectedInstance(sourceDataType, Date.class, listValue.getClass());
                        }
                        result.add(this.getDateFormat().format(value));
                    }
                    return Arrays.toString(result.toArray());
                }
                this.throwExpectedInstance(sourceDataType, Date.class, value.getClass());
            }
            case Object: {
                return String.valueOf(value);
            }
        }
        throw new InvalidDataConversionException(DataType.String, sourceDataType, value);
    }

    private String toString(DataType sourceDataType, Class<?> typeClass, Object value) {
        String result = null;
        if (typeClass.isAssignableFrom(value.getClass())) {
            result = String.valueOf(value);
        } else if (value instanceof List) {
            List list = (List)value;
            for (Object listValue : (List)value) {
                if (typeClass.isAssignableFrom(listValue.getClass())) continue;
                this.throwExpectedInstance(sourceDataType, typeClass, listValue.getClass());
            }
            result = Arrays.toString(list.toArray());
        } else {
            this.throwExpectedInstance(sourceDataType, typeClass, value.getClass());
        }
        return result;
    }

    public String toString(Property property, Object value) {
        DataType sourceDataType = DataType.valueOf((String)property.getType().getName());
        switch (sourceDataType) {
            case DateTime: 
            case Day: 
            case Duration: 
            case Month: 
            case MonthDay: 
            case String: 
            case Time: 
            case URI: 
            case Year: 
            case YearMonth: 
            case YearMonthDay: {
                if (!property.isMany()) {
                    if (value instanceof String) {
                        return (String)value;
                    }
                    this.throwExpectedInstance(sourceDataType, String.class, value.getClass());
                } else {
                    if (value instanceof List) {
                        List list = (List)value;
                        for (Object listValue : (List)value) {
                            if (listValue instanceof String) continue;
                            this.throwExpectedInstance(sourceDataType, String.class, listValue.getClass());
                        }
                        return Arrays.toString(list.toArray());
                    }
                    throw new IllegalArgumentException("expected value as instanceof List for 'many' property, " + property.toString());
                }
            }
            case Decimal: {
                if (!property.isMany()) {
                    if (value instanceof BigDecimal) {
                        return ((BigDecimal)value).toString();
                    }
                    this.throwExpectedInstance(sourceDataType, BigDecimal.class, value.getClass());
                } else {
                    if (value instanceof List) {
                        List list = (List)value;
                        for (Object listValue : (List)value) {
                            if (listValue instanceof BigDecimal) continue;
                            this.throwExpectedInstance(sourceDataType, BigDecimal.class, listValue.getClass());
                        }
                        return Arrays.toString(list.toArray());
                    }
                    throw new IllegalArgumentException("expected value as instanceof List for 'many' property, " + property.toString());
                }
            }
            case Bytes: {
                if (!property.isMany()) {
                    if (value instanceof byte[]) {
                        return this.toHexString((byte[])value);
                    }
                    this.throwExpectedInstance(sourceDataType, byte[].class, value.getClass());
                } else {
                    if (value instanceof List) {
                        ArrayList<String> result = new ArrayList<String>();
                        List list = (List)value;
                        for (Object listValue : list) {
                            if (!(listValue instanceof byte[])) {
                                this.throwExpectedInstance(sourceDataType, byte[].class, listValue.getClass());
                            }
                            result.add(this.toHexString((byte[])listValue));
                        }
                        return Arrays.toString(result.toArray());
                    }
                    throw new IllegalArgumentException("expected value as instanceof List for 'many' property, " + property.toString());
                }
            }
            case Byte: {
                if (!property.isMany()) {
                    if (value instanceof Byte) {
                        return Integer.valueOf((Byte)value & 0xFF).toString();
                    }
                    this.throwExpectedInstance(sourceDataType, Byte.class, value.getClass());
                } else {
                    if (value instanceof List) {
                        ArrayList<String> result = new ArrayList<String>();
                        List list = (List)value;
                        for (Object listValue : list) {
                            if (!(listValue instanceof Byte)) {
                                this.throwExpectedInstance(sourceDataType, Byte.class, listValue.getClass());
                            }
                            result.add(Integer.valueOf((Byte)listValue & 0xFF).toString());
                        }
                        return Arrays.toString(result.toArray());
                    }
                    throw new IllegalArgumentException("expected value as instanceof List for 'many' property, " + property.toString());
                }
            }
            case Boolean: {
                return this.toString(property, Boolean.class, value);
            }
            case Character: {
                return this.toString(property, Character.class, value);
            }
            case Double: {
                return this.toString(property, Double.class, value);
            }
            case Float: {
                return this.toString(property, Float.class, value);
            }
            case Int: {
                return this.toString(property, Integer.class, value);
            }
            case Integer: {
                return this.toString(property, BigInteger.class, value);
            }
            case Long: {
                return this.toString(property, Long.class, value);
            }
            case Short: {
                return this.toString(property, Short.class, value);
            }
            case Strings: {
                if (!(value instanceof List)) {
                    throw new IllegalArgumentException("expected value as class " + List.class.getName() + ", not " + value.getClass().getName() + ", for datatype '" + sourceDataType.name() + "'");
                }
                StringBuffer buf = new StringBuffer();
                List list = (List)value;
                Iterator iter = list.iterator();
                int i = 0;
                while (iter.hasNext()) {
                    if (i > 0) {
                        buf.append(" ");
                    }
                    buf.append((String)iter.next());
                    ++i;
                }
                return buf.toString();
            }
            case Date: {
                if (!property.isMany()) {
                    if (value instanceof Date) {
                        return this.getDateFormat().format(value);
                    }
                    this.throwExpectedInstance(sourceDataType, Date.class, value.getClass());
                } else {
                    if (value instanceof List) {
                        ArrayList<String> result = new ArrayList<String>();
                        List dateList = (List)value;
                        for (Object listValue : dateList) {
                            if (!(listValue instanceof Date)) {
                                this.throwExpectedInstance(sourceDataType, Date.class, listValue.getClass());
                            }
                            result.add(this.getDateFormat().format(value));
                        }
                        return Arrays.toString(result.toArray());
                    }
                    throw new IllegalArgumentException("expected value as instanceof List for 'many' property, " + property.toString());
                }
            }
            case Object: {
                return String.valueOf(value);
            }
        }
        throw new InvalidDataConversionException(DataType.String, sourceDataType, value);
    }

    private String toString(Property property, Class<?> typeClass, Object value) {
        DataType sourceDataType = DataType.valueOf((String)property.getType().getName());
        String result = null;
        if (!property.isMany()) {
            if (typeClass.isAssignableFrom(value.getClass())) {
                result = String.valueOf(value);
            } else {
                this.throwExpectedInstance(sourceDataType, typeClass, value.getClass());
            }
        } else if (value instanceof List) {
            if (value instanceof List) {
                List list = (List)value;
                for (Object listValue : (List)value) {
                    if (typeClass.isAssignableFrom(listValue.getClass())) continue;
                    this.throwExpectedInstance(sourceDataType, typeClass, listValue.getClass());
                }
                result = Arrays.toString(list.toArray());
            } else {
                this.throwExpectedInstance(sourceDataType, typeClass, value.getClass());
            }
        } else {
            throw new IllegalArgumentException("expected value as instanceof List for 'many' property, " + property.toString());
        }
        return result;
    }

    private void throwExpectedInstance(DataType dataType, Class expectedClass, Class foundClass) {
        throw new IllegalArgumentException("expected value or list of class " + expectedClass.getName() + ", not " + foundClass.getName() + ", for datatype '" + dataType.name() + "'");
    }

    public Object fromString(Type targetType, String value) {
        DataType targetDataType = DataType.valueOf((String)targetType.getName());
        switch (targetDataType) {
            case String: {
                if (!value.startsWith("[")) {
                    return value;
                }
                String[] strings = value.replaceAll("[\\[\\]\\s]", "").split(",");
                ArrayList<String> list = new ArrayList<String>();
                String[] stringArray = strings;
                int n = strings.length;
                int n2 = 0;
                while (n2 < n) {
                    String arrayValue = stringArray[n2];
                    list.add(arrayValue);
                    ++n2;
                }
                return list;
            }
            case Decimal: {
                if (!value.startsWith("[")) {
                    return new BigDecimal(value);
                }
                String[] strings = value.replaceAll("[\\[\\]\\s]", "").split(",");
                ArrayList<BigDecimal> list = new ArrayList<BigDecimal>();
                String[] stringArray = strings;
                int n = strings.length;
                int n3 = 0;
                while (n3 < n) {
                    String arrayValue = stringArray[n3];
                    list.add(new BigDecimal(arrayValue));
                    ++n3;
                }
                return list;
            }
            case Bytes: {
                if (!value.startsWith("[")) {
                    return value.getBytes();
                }
                String[] strings = value.replaceAll("[\\[\\]\\s]", "").split(",");
                ArrayList<byte[]> list = new ArrayList<byte[]>();
                String[] stringArray = strings;
                int n = strings.length;
                int n4 = 0;
                while (n4 < n) {
                    String arrayValue = stringArray[n4];
                    list.add(value.getBytes());
                    ++n4;
                }
                return list;
            }
            case Byte: {
                if (!value.startsWith("[")) {
                    byte[] byteArray = value.getBytes();
                    return new Byte(byteArray[0]);
                }
                String[] strings = value.replaceAll("[\\[\\]\\s]", "").split(",");
                ArrayList<Byte> list = new ArrayList<Byte>();
                byte[] byteArray = null;
                String[] stringArray = strings;
                int n = strings.length;
                int n5 = 0;
                while (n5 < n) {
                    String arrayValue = stringArray[n5];
                    byteArray = arrayValue.getBytes();
                    list.add(new Byte(byteArray[0]));
                    ++n5;
                }
                return list;
            }
            case Boolean: {
                if (!value.startsWith("[")) {
                    return Boolean.valueOf(value);
                }
                String[] strings = value.replaceAll("[\\[\\]\\s]", "").split(",");
                ArrayList<Boolean> list = new ArrayList<Boolean>();
                String[] stringArray = strings;
                int n = strings.length;
                int arrayValue = 0;
                while (arrayValue < n) {
                    String arrayValue2 = stringArray[arrayValue];
                    list.add(Boolean.valueOf(arrayValue2));
                    ++arrayValue;
                }
                return list;
            }
            case Character: {
                if (!value.startsWith("[")) {
                    return Character.valueOf(value.charAt(0));
                }
                String[] strings = value.replaceAll("[\\[\\]\\s]", "").split(",");
                ArrayList<Character> list = new ArrayList<Character>();
                String[] stringArray = strings;
                int n = strings.length;
                int arrayValue = 0;
                while (arrayValue < n) {
                    String arrayValue3 = stringArray[arrayValue];
                    list.add(Character.valueOf(arrayValue3.charAt(0)));
                    ++arrayValue;
                }
                return list;
            }
            case Double: {
                if (!value.startsWith("[")) {
                    return Double.valueOf(value);
                }
                String[] strings = value.replaceAll("[\\[\\]\\s]", "").split(",");
                ArrayList<Double> list = new ArrayList<Double>();
                String[] stringArray = strings;
                int n = strings.length;
                int arrayValue = 0;
                while (arrayValue < n) {
                    String arrayValue4 = stringArray[arrayValue];
                    list.add(Double.valueOf(arrayValue4));
                    ++arrayValue;
                }
                return list;
            }
            case Float: {
                if (!value.startsWith("[")) {
                    return Float.valueOf(value);
                }
                String[] strings = value.replaceAll("[\\[\\]\\s]", "").split(",");
                ArrayList<Float> list = new ArrayList<Float>();
                String[] stringArray = strings;
                int n = strings.length;
                int arrayValue = 0;
                while (arrayValue < n) {
                    String arrayValue5 = stringArray[arrayValue];
                    list.add(Float.valueOf(arrayValue5));
                    ++arrayValue;
                }
                return list;
            }
            case Int: {
                if (!value.startsWith("[")) {
                    return Integer.valueOf(value);
                }
                String[] strings = value.replaceAll("[\\[\\]\\s]", "").split(",");
                ArrayList<Integer> list = new ArrayList<Integer>();
                String[] stringArray = strings;
                int n = strings.length;
                int arrayValue = 0;
                while (arrayValue < n) {
                    String arrayValue6 = stringArray[arrayValue];
                    list.add(Integer.valueOf(arrayValue6));
                    ++arrayValue;
                }
                return list;
            }
            case Integer: {
                if (!value.startsWith("[")) {
                    return new BigInteger(value);
                }
                String[] strings = value.replaceAll("[\\[\\]\\s]", "").split(",");
                ArrayList<BigInteger> list = new ArrayList<BigInteger>();
                String[] stringArray = strings;
                int n = strings.length;
                int arrayValue = 0;
                while (arrayValue < n) {
                    String arrayValue7 = stringArray[arrayValue];
                    list.add(new BigInteger(arrayValue7));
                    ++arrayValue;
                }
                return list;
            }
            case Long: {
                if (!value.startsWith("[")) {
                    return Long.valueOf(value);
                }
                String[] strings = value.replaceAll("[\\[\\]\\s]", "").split(",");
                ArrayList<Long> list = new ArrayList<Long>();
                String[] stringArray = strings;
                int n = strings.length;
                int arrayValue = 0;
                while (arrayValue < n) {
                    String arrayValue8 = stringArray[arrayValue];
                    list.add(Long.valueOf(arrayValue8));
                    ++arrayValue;
                }
                return list;
            }
            case Short: {
                if (!value.startsWith("[")) {
                    return Short.valueOf(value);
                }
                String[] strings = value.replaceAll("[\\[\\]\\s]", "").split(",");
                ArrayList<Short> list = new ArrayList<Short>();
                String[] stringArray = strings;
                int n = strings.length;
                int arrayValue = 0;
                while (arrayValue < n) {
                    String arrayValue9 = stringArray[arrayValue];
                    list.add(Short.valueOf(arrayValue9));
                    ++arrayValue;
                }
                return list;
            }
            case Strings: {
                if (!value.startsWith("[")) {
                    String[] values = value.split("\\s");
                    ArrayList<String> list = new ArrayList<String>(values.length);
                    int i = 0;
                    while (i < values.length) {
                        list.add(values[i]);
                        ++i;
                    }
                    return list;
                }
                String tempValue = value.replaceAll("[\\[\\]]", "");
                tempValue.trim();
                String[] strings = tempValue.split(",");
                ArrayList list = new ArrayList();
                String[] stringArray = strings;
                int n = strings.length;
                int n6 = 0;
                while (n6 < n) {
                    String arrayValue = stringArray[n6];
                    String[] values = arrayValue.split("\\s");
                    ArrayList<String> subList = new ArrayList<String>(values.length);
                    int i = 0;
                    while (i < values.length) {
                        subList.add(values[i]);
                        ++i;
                    }
                    list.add(subList);
                    ++n6;
                }
                return list;
            }
            case Date: {
                try {
                    if (!value.startsWith("[")) {
                        return this.getDateFormat().parse(value);
                    }
                    String[] strings = value.replaceAll("[\\[\\]\\s]", "").split(",");
                    ArrayList<Date> list = new ArrayList<Date>();
                    String[] stringArray = strings;
                    int n = strings.length;
                    int n7 = 0;
                    while (n7 < n) {
                        String arrayValue = stringArray[n7];
                        list.add(this.getDateFormat().parse(arrayValue));
                        ++n7;
                    }
                    return list;
                }
                catch (ParseException e) {
                    throw new PlasmaDataObjectException(e);
                }
            }
            case DateTime: 
            case Day: 
            case Duration: 
            case Month: 
            case MonthDay: 
            case Time: 
            case URI: 
            case Year: 
            case YearMonth: 
            case YearMonthDay: {
                if (!value.startsWith("[")) {
                    return value;
                }
                String[] strings = value.replaceAll("[\\[\\]\\s]", "").split(",");
                ArrayList<String> list = new ArrayList<String>();
                String[] stringArray = strings;
                int n = strings.length;
                int n8 = 0;
                while (n8 < n) {
                    String arrayValue = stringArray[n8];
                    list.add(arrayValue);
                    ++n8;
                }
                return list;
            }
        }
        throw new InvalidDataConversionException(targetDataType, DataType.String, value);
    }

    public Object fromString(Property targetProperty, String value) {
        DataType targetDataType = DataType.valueOf((String)targetProperty.getType().getName());
        switch (targetDataType) {
            case String: {
                if (!targetProperty.isMany()) {
                    if (!value.startsWith("[")) {
                        return value;
                    }
                    return value;
                }
                if (value.startsWith("[")) {
                    String[] strings = value.replaceAll("[\\[\\]\\s]", "").split(",");
                    ArrayList<String> list = new ArrayList<String>();
                    String[] stringArray = strings;
                    int n = strings.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String arrayValue = stringArray[n2];
                        list.add(arrayValue);
                        ++n2;
                    }
                    return list;
                }
                throw new IllegalArgumentException("no java.util.Arrays formatting detected for the given value, for the given 'many' property, " + targetProperty.toString());
            }
            case Decimal: {
                if (!targetProperty.isMany()) {
                    if (!value.startsWith("[")) {
                        return new BigDecimal(value);
                    }
                    throw new IllegalArgumentException("no java.util.Arrays formatting expected for the given value, for the given singular property, " + targetProperty.toString());
                }
                if (value.startsWith("[")) {
                    String[] strings = value.replaceAll("[\\[\\]\\s]", "").split(",");
                    ArrayList<BigDecimal> list = new ArrayList<BigDecimal>();
                    String[] stringArray = strings;
                    int n = strings.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String arrayValue = stringArray[n3];
                        list.add(new BigDecimal(arrayValue));
                        ++n3;
                    }
                    return list;
                }
                throw new IllegalArgumentException("no java.util.Arrays formatting detected for the given value, for the given 'many' property, " + targetProperty.toString());
            }
            case Bytes: {
                if (!targetProperty.isMany()) {
                    return value.getBytes();
                }
                if (value.startsWith("[")) {
                    String[] strings = value.replaceAll("[\\[\\]\\s]", "").split(",");
                    ArrayList<byte[]> list = new ArrayList<byte[]>();
                    String[] stringArray = strings;
                    int n = strings.length;
                    int n4 = 0;
                    while (n4 < n) {
                        String arrayValue = stringArray[n4];
                        list.add(value.getBytes());
                        ++n4;
                    }
                    return list;
                }
                throw new IllegalArgumentException("no java.util.Arrays formatting detected for the given value, for the given 'many' property, " + targetProperty.toString());
            }
            case Byte: {
                if (!targetProperty.isMany()) {
                    byte[] byteArray = value.getBytes();
                    return new Byte(byteArray[0]);
                }
                if (value.startsWith("[")) {
                    String[] strings = value.replaceAll("[\\[\\]\\s]", "").split(",");
                    ArrayList<Byte> list = new ArrayList<Byte>();
                    byte[] byteArray = null;
                    String[] stringArray = strings;
                    int n = strings.length;
                    int n5 = 0;
                    while (n5 < n) {
                        String arrayValue = stringArray[n5];
                        byteArray = arrayValue.getBytes();
                        list.add(new Byte(byteArray[0]));
                        ++n5;
                    }
                    return list;
                }
                throw new IllegalArgumentException("no java.util.Arrays formatting detected for the given value, for the given 'many' property, " + targetProperty.toString());
            }
            case Boolean: {
                if (!targetProperty.isMany()) {
                    if (!value.startsWith("[")) {
                        return Boolean.valueOf(value);
                    }
                    throw new IllegalArgumentException("no java.util.Arrays formatting expected for the given value, for the given singular property, " + targetProperty.toString());
                }
                if (value.startsWith("[")) {
                    String[] strings = value.replaceAll("[\\[\\]\\s]", "").split(",");
                    ArrayList<Boolean> list = new ArrayList<Boolean>();
                    String[] stringArray = strings;
                    int n = strings.length;
                    int arrayValue = 0;
                    while (arrayValue < n) {
                        String arrayValue2 = stringArray[arrayValue];
                        list.add(Boolean.valueOf(arrayValue2));
                        ++arrayValue;
                    }
                    return list;
                }
                throw new IllegalArgumentException("no java.util.Arrays formatting detected for the given value, for the given 'many' property, " + targetProperty.toString());
            }
            case Character: {
                if (!targetProperty.isMany()) {
                    return Character.valueOf(value.charAt(0));
                }
                if (value.startsWith("[")) {
                    String[] strings = value.replaceAll("[\\[\\]\\s]", "").split(",");
                    ArrayList<Character> list = new ArrayList<Character>();
                    String[] stringArray = strings;
                    int n = strings.length;
                    int arrayValue = 0;
                    while (arrayValue < n) {
                        String arrayValue3 = stringArray[arrayValue];
                        list.add(Character.valueOf(arrayValue3.charAt(0)));
                        ++arrayValue;
                    }
                    return list;
                }
                throw new IllegalArgumentException("no java.util.Arrays formatting detected for the given value, for the given 'many' property, " + targetProperty.toString());
            }
            case Double: {
                if (!targetProperty.isMany()) {
                    if (!value.startsWith("[")) {
                        return Double.valueOf(value);
                    }
                    throw new IllegalArgumentException("no java.util.Arrays formatting expected for the given value, for the given singular property, " + targetProperty.toString());
                }
                if (value.startsWith("[")) {
                    String[] strings = value.replaceAll("[\\[\\]\\s]", "").split(",");
                    ArrayList<Double> list = new ArrayList<Double>();
                    String[] stringArray = strings;
                    int n = strings.length;
                    int arrayValue = 0;
                    while (arrayValue < n) {
                        String arrayValue4 = stringArray[arrayValue];
                        list.add(Double.valueOf(arrayValue4));
                        ++arrayValue;
                    }
                    return list;
                }
                throw new IllegalArgumentException("no java.util.Arrays formatting detected for the given value, for the given 'many' property, " + targetProperty.toString());
            }
            case Float: {
                if (!targetProperty.isMany()) {
                    if (!value.startsWith("[")) {
                        return Float.valueOf(value);
                    }
                    throw new IllegalArgumentException("no java.util.Arrays formatting expected for the given value, for the given singular property, " + targetProperty.toString());
                }
                if (value.startsWith("[")) {
                    String[] strings = value.replaceAll("[\\[\\]\\s]", "").split(",");
                    ArrayList<Float> list = new ArrayList<Float>();
                    String[] stringArray = strings;
                    int n = strings.length;
                    int arrayValue = 0;
                    while (arrayValue < n) {
                        String arrayValue5 = stringArray[arrayValue];
                        list.add(Float.valueOf(arrayValue5));
                        ++arrayValue;
                    }
                    return list;
                }
                throw new IllegalArgumentException("no java.util.Arrays formatting detected for the given value, for the given 'many' property, " + targetProperty.toString());
            }
            case Int: {
                if (!targetProperty.isMany()) {
                    if (!value.startsWith("[")) {
                        return Integer.valueOf(value);
                    }
                    throw new IllegalArgumentException("no java.util.Arrays formatting expected for the given value, for the given singular property, " + targetProperty.toString());
                }
                if (value.startsWith("[")) {
                    String[] strings = value.replaceAll("[\\[\\]\\s]", "").split(",");
                    ArrayList<Integer> list = new ArrayList<Integer>();
                    String[] stringArray = strings;
                    int n = strings.length;
                    int arrayValue = 0;
                    while (arrayValue < n) {
                        String arrayValue6 = stringArray[arrayValue];
                        list.add(Integer.valueOf(arrayValue6));
                        ++arrayValue;
                    }
                    return list;
                }
                throw new IllegalArgumentException("no java.util.Arrays formatting detected for the given value, for the given 'many' property, " + targetProperty.toString());
            }
            case Integer: {
                if (!targetProperty.isMany()) {
                    if (!value.startsWith("[")) {
                        return new BigInteger(value);
                    }
                    throw new IllegalArgumentException("no java.util.Arrays formatting expected for the given value, for the given singular property, " + targetProperty.toString());
                }
                if (value.startsWith("[")) {
                    String[] strings = value.replaceAll("[\\[\\]\\s]", "").split(",");
                    ArrayList<BigInteger> list = new ArrayList<BigInteger>();
                    String[] stringArray = strings;
                    int n = strings.length;
                    int arrayValue = 0;
                    while (arrayValue < n) {
                        String arrayValue7 = stringArray[arrayValue];
                        list.add(new BigInteger(arrayValue7));
                        ++arrayValue;
                    }
                    return list;
                }
                throw new IllegalArgumentException("no java.util.Arrays formatting detected for the given value, for the given 'many' property, " + targetProperty.toString());
            }
            case Long: {
                if (!targetProperty.isMany()) {
                    if (!value.startsWith("[")) {
                        return Long.valueOf(value);
                    }
                    throw new IllegalArgumentException("no java.util.Arrays formatting expected for the given value, for the given singular property, " + targetProperty.toString());
                }
                if (value.startsWith("[")) {
                    String[] strings = value.replaceAll("[\\[\\]\\s]", "").split(",");
                    ArrayList<Long> list = new ArrayList<Long>();
                    String[] stringArray = strings;
                    int n = strings.length;
                    int arrayValue = 0;
                    while (arrayValue < n) {
                        String arrayValue8 = stringArray[arrayValue];
                        list.add(Long.valueOf(arrayValue8));
                        ++arrayValue;
                    }
                    return list;
                }
                throw new IllegalArgumentException("no java.util.Arrays formatting detected for the given value, for the given 'many' property, " + targetProperty.toString());
            }
            case Short: {
                if (!targetProperty.isMany()) {
                    if (!value.startsWith("[")) {
                        return Short.valueOf(value);
                    }
                    throw new IllegalArgumentException("no java.util.Arrays formatting expected for the given value, for the given singular property, " + targetProperty.toString());
                }
                if (value.startsWith("[")) {
                    String[] strings = value.replaceAll("[\\[\\]\\s]", "").split(",");
                    ArrayList<Short> list = new ArrayList<Short>();
                    String[] stringArray = strings;
                    int n = strings.length;
                    int arrayValue = 0;
                    while (arrayValue < n) {
                        String arrayValue9 = stringArray[arrayValue];
                        list.add(Short.valueOf(arrayValue9));
                        ++arrayValue;
                    }
                    return list;
                }
                throw new IllegalArgumentException("no java.util.Arrays formatting detected for the given value, for the given 'many' property, " + targetProperty.toString());
            }
            case Strings: {
                if (!targetProperty.isMany()) {
                    String[] values = value.split("\\s");
                    ArrayList<String> list = new ArrayList<String>(values.length);
                    int i = 0;
                    while (i < values.length) {
                        list.add(values[i]);
                        ++i;
                    }
                    return list;
                }
                if (value.startsWith("[")) {
                    String tempValue = value.replaceAll("[\\[\\]]", "");
                    tempValue.trim();
                    String[] strings = tempValue.split(",");
                    ArrayList list = new ArrayList();
                    String[] stringArray = strings;
                    int n = strings.length;
                    int n6 = 0;
                    while (n6 < n) {
                        String arrayValue = stringArray[n6];
                        String[] values = arrayValue.split("\\s");
                        ArrayList<String> subList = new ArrayList<String>(values.length);
                        int i = 0;
                        while (i < values.length) {
                            subList.add(values[i]);
                            ++i;
                        }
                        list.add(subList);
                        ++n6;
                    }
                    return list;
                }
                throw new IllegalArgumentException("no java.util.Arrays formatting detected for the given value, for the given 'many' property, " + targetProperty.toString());
            }
            case Date: {
                try {
                    if (!targetProperty.isMany()) {
                        return this.getDateFormat().parse(value);
                    }
                    if (value.startsWith("[")) {
                        String[] strings = value.replaceAll("[\\[\\]\\s]", "").split(",");
                        ArrayList<Date> list = new ArrayList<Date>();
                        String[] stringArray = strings;
                        int n = strings.length;
                        int n7 = 0;
                        while (n7 < n) {
                            String arrayValue = stringArray[n7];
                            list.add(this.getDateFormat().parse(arrayValue));
                            ++n7;
                        }
                        return list;
                    }
                    throw new IllegalArgumentException("no java.util.Arrays formatting detected for the given value, for the given 'many' property, " + targetProperty.toString());
                }
                catch (ParseException e) {
                    throw new PlasmaDataObjectException(e);
                }
            }
            case DateTime: 
            case Day: 
            case Duration: 
            case Month: 
            case MonthDay: 
            case Time: 
            case URI: 
            case Year: 
            case YearMonth: 
            case YearMonthDay: {
                if (!targetProperty.isMany()) {
                    if (!value.startsWith("[")) {
                        return value;
                    }
                    throw new IllegalArgumentException("no java.util.Arrays formatting expected for the given value, for the given singular property, " + targetProperty.toString());
                }
                if (value.startsWith("[")) {
                    String[] strings = value.replaceAll("[\\[\\]\\s]", "").split(",");
                    ArrayList<String> list = new ArrayList<String>();
                    String[] stringArray = strings;
                    int n = strings.length;
                    int n8 = 0;
                    while (n8 < n) {
                        String arrayValue = stringArray[n8];
                        list.add(arrayValue);
                        ++n8;
                    }
                    return list;
                }
                throw new IllegalArgumentException("no java.util.Arrays formatting detected for the given value, for the given 'many' property, " + targetProperty.toString());
            }
        }
        throw new InvalidDataConversionException(targetDataType, DataType.String, value);
    }

    public List<String> toStrings(Type sourceType, Object value) {
        DataType sourceDataType = DataType.valueOf((String)sourceType.getName());
        switch (sourceDataType) {
            case Strings: {
                return (List)value;
            }
            case String: {
                String[] values = ((String)value).split("\\s");
                ArrayList<String> list = new ArrayList<String>(values.length);
                int i = 0;
                while (i < values.length) {
                    list.add(values[i]);
                    ++i;
                }
                return list;
            }
        }
        throw new InvalidDataConversionException(DataType.Strings, sourceDataType, value);
    }

    public Object fromStrings(Type targetType, List<String> value) {
        DataType targetDataType = DataType.valueOf((String)targetType.getName());
        switch (targetDataType) {
            case Strings: {
                return value;
            }
            case String: {
                StringBuffer buf = new StringBuffer();
                Iterator<String> iter = value.iterator();
                int i = 0;
                while (iter.hasNext()) {
                    if (i > 0) {
                        buf.append(" ");
                    }
                    buf.append(iter.next());
                    ++i;
                }
                return buf.toString();
            }
        }
        throw new InvalidDataConversionException(targetDataType, DataType.Strings, value);
    }

    public Date toDate(Type sourceType, Object value) {
        DateFormat format = null;
        DataType sourceDataType = DataType.valueOf((String)sourceType.getName());
        switch (sourceDataType) {
            case Date: {
                return (Date)value;
            }
            case Long: {
                return new Date((Long)value);
            }
            case Day: {
                format = this.getDayFormat();
                break;
            }
            case Month: {
                format = this.getMonthFormat();
                break;
            }
            case MonthDay: {
                format = this.getMonthDayFormat();
                break;
            }
            case Time: {
                format = this.getTimeFormat();
                break;
            }
            case Year: {
                format = this.getYearFormat();
                break;
            }
            case YearMonth: {
                format = this.getYearMonthFormat();
                break;
            }
            case YearMonthDay: {
                format = this.getYearMonthDayFormat();
                break;
            }
            case DateTime: 
            case Duration: 
            case String: {
                format = this.getDateTimeFormat();
                break;
            }
            default: {
                throw new InvalidDataConversionException(DataType.Date, sourceDataType, value);
            }
        }
        try {
            return format.parse((String)value);
        }
        catch (ParseException e) {
            if (format instanceof SimpleDateFormat) {
                throw new InvalidDataFormatException("expected " + sourceDataType.toString() + " pattern '" + ((SimpleDateFormat)format).toPattern() + "' for value '" + value.toString() + "'", e);
            }
            throw new InvalidDataFormatException("expected " + sourceDataType.toString() + " pattern '" + "unknown" + "' for value '" + value.toString() + "'", e);
        }
    }

    public Object fromDate(Type targetType, Date value) {
        DataType targetDataType = DataType.valueOf((String)targetType.getName());
        switch (targetDataType) {
            case Date: {
                return value;
            }
            case DateTime: {
                return this.getDateTimeFormat().format(value);
            }
            case Day: {
                return this.getDayFormat().format(value);
            }
            case Month: {
                return this.getMonthFormat().format(value);
            }
            case MonthDay: {
                return this.getMonthDayFormat().format(value);
            }
            case Time: {
                return this.getTimeFormat().format(value);
            }
            case Year: {
                return this.getYearFormat().format(value);
            }
            case YearMonth: {
                return this.getYearMonthFormat().format(value);
            }
            case YearMonthDay: {
                return this.getYearMonthDayFormat().format(value);
            }
            case Long: {
                return new Long(value.getTime());
            }
            case String: {
                return this.getDateTimeFormat().format(value);
            }
            case Duration: {
                return new Duration(value.getTime());
            }
        }
        throw new InvalidDataConversionException(targetDataType, DataType.Date, value);
    }

    public String toTemporalDataType(Type targetType, Type sourceType, Object value) {
        DataType targetDataType = DataType.valueOf((String)targetType.getName());
        DataType sourceDataType = DataType.valueOf((String)sourceType.getName());
        switch (sourceDataType) {
            default: 
        }
        throw new InvalidDataConversionException(targetDataType, sourceDataType, value);
    }

    public Object fromTemporalDataType(Type targetType, Type sourceType, String value) {
        DataType targetDataType = DataType.valueOf((String)targetType.getName());
        DataType sourceDataType = DataType.valueOf((String)sourceType.getName());
        switch (targetDataType) {
            // Empty switch
        }
        throw new InvalidDataConversionException(targetDataType, sourceDataType, value);
    }

    public Class<?> toPrimitiveJavaClass(DataType dataType) {
        switch (dataType) {
            case Boolean: {
                return Boolean.TYPE;
            }
            case Byte: {
                return Byte.TYPE;
            }
            case Bytes: {
                return byte[].class;
            }
            case Character: {
                return Character.TYPE;
            }
            case Date: {
                return Date.class;
            }
            case DateTime: {
                return String.class;
            }
            case Day: {
                return String.class;
            }
            case Decimal: {
                return BigDecimal.class;
            }
            case Double: {
                return Double.TYPE;
            }
            case Duration: {
                return String.class;
            }
            case Float: {
                return Float.TYPE;
            }
            case Int: {
                return Integer.TYPE;
            }
            case Integer: {
                return BigInteger.class;
            }
            case Long: {
                return Long.TYPE;
            }
            case Month: {
                return String.class;
            }
            case MonthDay: {
                return String.class;
            }
            case Object: {
                return Object.class;
            }
            case Short: {
                return Short.TYPE;
            }
            case String: {
                return String.class;
            }
            case Strings: {
                return List.class;
            }
            case Time: {
                return String.class;
            }
            case URI: {
                return String.class;
            }
            case Year: {
                return String.class;
            }
            case YearMonth: {
                return String.class;
            }
            case YearMonthDay: {
                return String.class;
            }
        }
        throw new PlasmaDataObjectException("unknown SDO datatype, " + dataType.toString());
    }

    public Class<?> toWrapperJavaClass(DataType dataType) {
        switch (dataType) {
            case Boolean: {
                return Boolean.class;
            }
            case Byte: {
                return Byte.class;
            }
            case Bytes: {
                return byte[].class;
            }
            case Character: {
                return Character.class;
            }
            case Date: {
                return Date.class;
            }
            case DateTime: {
                return String.class;
            }
            case Day: {
                return String.class;
            }
            case Decimal: {
                return BigDecimal.class;
            }
            case Double: {
                return Double.class;
            }
            case Duration: {
                return String.class;
            }
            case Float: {
                return Float.class;
            }
            case Int: {
                return Integer.class;
            }
            case Integer: {
                return BigInteger.class;
            }
            case Long: {
                return Long.class;
            }
            case Month: {
                return String.class;
            }
            case MonthDay: {
                return String.class;
            }
            case Object: {
                return Object.class;
            }
            case Short: {
                return Short.class;
            }
            case String: {
                return String.class;
            }
            case Strings: {
                return List.class;
            }
            case Time: {
                return String.class;
            }
            case URI: {
                return String.class;
            }
            case Year: {
                return String.class;
            }
            case YearMonth: {
                return String.class;
            }
            case YearMonthDay: {
                return String.class;
            }
        }
        throw new PlasmaDataObjectException("unknown SDO datatype, " + dataType.toString());
    }

    public List<DataType> getAllowableTargetTypes(DataType dataType) {
        ArrayList<DataType> result = new ArrayList<DataType>();
        switch (dataType) {
            case Boolean: {
                result.add(DataType.Boolean);
                result.add(DataType.String);
                break;
            }
            case Byte: {
                result.add(DataType.Byte);
                result.add(DataType.Double);
                result.add(DataType.Float);
                result.add(DataType.Int);
                result.add(DataType.Long);
                result.add(DataType.Short);
                result.add(DataType.String);
                break;
            }
            case Bytes: {
                result.add(DataType.Bytes);
                result.add(DataType.String);
                result.add(DataType.Integer);
                break;
            }
            case Character: {
                result.add(DataType.Character);
                result.add(DataType.String);
                break;
            }
            case Decimal: {
                result.add(DataType.Decimal);
                result.add(DataType.Double);
                result.add(DataType.Float);
                result.add(DataType.Int);
                result.add(DataType.Long);
                result.add(DataType.Integer);
                result.add(DataType.String);
                break;
            }
            case Double: {
                result.add(DataType.Double);
                result.add(DataType.Byte);
                result.add(DataType.Float);
                result.add(DataType.Int);
                result.add(DataType.Long);
                result.add(DataType.Short);
                result.add(DataType.Decimal);
                result.add(DataType.Integer);
                result.add(DataType.String);
                break;
            }
            case Float: {
                result.add(DataType.Float);
                result.add(DataType.Byte);
                result.add(DataType.Double);
                result.add(DataType.Int);
                result.add(DataType.Long);
                result.add(DataType.Short);
                result.add(DataType.Decimal);
                result.add(DataType.Integer);
                result.add(DataType.String);
                break;
            }
            case Int: {
                result.add(DataType.Int);
                result.add(DataType.Byte);
                result.add(DataType.Double);
                result.add(DataType.Float);
                result.add(DataType.Long);
                result.add(DataType.Short);
                result.add(DataType.Decimal);
                result.add(DataType.Integer);
                result.add(DataType.String);
                break;
            }
            case Integer: {
                result.add(DataType.Integer);
                result.add(DataType.Double);
                result.add(DataType.Float);
                result.add(DataType.Int);
                result.add(DataType.Long);
                result.add(DataType.Bytes);
                result.add(DataType.Decimal);
                result.add(DataType.String);
                break;
            }
            case Long: {
                result.add(DataType.Long);
                result.add(DataType.Byte);
                result.add(DataType.Double);
                result.add(DataType.Float);
                result.add(DataType.Int);
                result.add(DataType.Short);
                result.add(DataType.Decimal);
                result.add(DataType.Integer);
                result.add(DataType.Date);
                result.add(DataType.String);
                break;
            }
            case Short: {
                result.add(DataType.Short);
                result.add(DataType.Byte);
                result.add(DataType.Double);
                result.add(DataType.Float);
                result.add(DataType.Int);
                result.add(DataType.Long);
                result.add(DataType.String);
                break;
            }
            case String: {
                result.add(DataType.String);
                result.add(DataType.Boolean);
                result.add(DataType.Byte);
                result.add(DataType.Bytes);
                result.add(DataType.Character);
                result.add(DataType.Date);
                result.add(DataType.DateTime);
                result.add(DataType.Day);
                result.add(DataType.Decimal);
                result.add(DataType.Double);
                result.add(DataType.Duration);
                result.add(DataType.Float);
                result.add(DataType.Int);
                result.add(DataType.Integer);
                result.add(DataType.Long);
                result.add(DataType.Month);
                result.add(DataType.MonthDay);
                result.add(DataType.Short);
                result.add(DataType.Strings);
                result.add(DataType.Time);
                result.add(DataType.URI);
                result.add(DataType.Year);
                result.add(DataType.YearMonth);
                result.add(DataType.YearMonthDay);
                break;
            }
            case Strings: {
                result.add(DataType.Strings);
                result.add(DataType.String);
                break;
            }
            case Date: {
                result.add(DataType.Date);
                result.add(DataType.Long);
                result.add(DataType.String);
                break;
            }
            case Duration: {
                result.add(DataType.Duration);
                result.add(DataType.Date);
                result.add(DataType.String);
                break;
            }
            case DateTime: {
                result.add(DataType.DateTime);
                result.add(DataType.Date);
                result.add(DataType.String);
                break;
            }
            case Day: {
                result.add(DataType.Day);
                result.add(DataType.Date);
                result.add(DataType.String);
                break;
            }
            case Month: {
                result.add(DataType.Month);
                result.add(DataType.Date);
                result.add(DataType.String);
                break;
            }
            case MonthDay: {
                result.add(DataType.MonthDay);
                result.add(DataType.Date);
                result.add(DataType.String);
                break;
            }
            case Year: {
                result.add(DataType.Year);
                result.add(DataType.Date);
                result.add(DataType.String);
                break;
            }
            case YearMonth: {
                result.add(DataType.YearMonth);
                result.add(DataType.Date);
                result.add(DataType.String);
                break;
            }
            case YearMonthDay: {
                result.add(DataType.YearMonthDay);
                result.add(DataType.Date);
                result.add(DataType.String);
                break;
            }
            case Time: {
                result.add(DataType.Time);
                result.add(DataType.Date);
                result.add(DataType.String);
                break;
            }
            case URI: {
                result.add(DataType.String);
            }
        }
        return result;
    }

    private String toHexString(byte[] block) {
        StringBuffer buf = new StringBuffer();
        char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int len = block.length;
        int high = 0;
        int low = 0;
        int i = 0;
        while (i < len) {
            high = (block[i] & 0xF0) >> 4;
            low = block[i] & 0xF;
            buf.append(hexChars[high]);
            buf.append(hexChars[low]);
            ++i;
        }
        return buf.toString();
    }

    static final class DateFormatMap {
        private static final ThreadLocal<SoftReference<Map<String, SimpleDateFormat>>> THREADLOCAL_FORMATS = new ThreadLocal<SoftReference<Map<String, SimpleDateFormat>>>(){

            @Override
            protected SoftReference<Map<String, SimpleDateFormat>> initialValue() {
                return new SoftReference<Map<String, SimpleDateFormat>>(new HashMap());
            }
        };

        DateFormatMap() {
        }

        public static SimpleDateFormat get(String pattern) {
            SimpleDateFormat format;
            SoftReference<Map<String, SimpleDateFormat>> ref = THREADLOCAL_FORMATS.get();
            Map<String, SimpleDateFormat> formats = ref.get();
            if (formats == null) {
                formats = new HashMap<String, SimpleDateFormat>();
                THREADLOCAL_FORMATS.set(new SoftReference<Map<String, SimpleDateFormat>>(formats));
            }
            if ((format = formats.get(pattern)) == null) {
                format = new SimpleDateFormat(pattern, Locale.US);
                format.setTimeZone(TimeZone.getTimeZone("GMT"));
                formats.put(pattern, format);
            }
            return format;
        }
    }
}

