/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.xpath;

import commonj.sdo.Property;
import commonj.sdo.Type;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.DefaultNavigator;
import org.jaxen.FunctionCallException;
import org.jaxen.JaxenConstants;
import org.jaxen.NamedAccessNavigator;
import org.jaxen.XPath;
import org.jaxen.saxpath.SAXPathException;
import org.jaxen.util.SingleObjectIterator;
import org.plasma.sdo.PlasmaType;
import org.plasma.sdo.xpath.MetaDataXPath;
import org.plasma.sdo.xpath.XPathProperty;
import org.plasma.sdo.xpath.XPathType;

public class MetaDataNavigator
extends DefaultNavigator
implements NamedAccessNavigator {
    private static final long serialVersionUID = -1636727587303584165L;
    private static Log log = LogFactory.getFactory().getInstance(MetaDataNavigator.class);

    public boolean isElement(Object obj) {
        return obj instanceof XPathType;
    }

    public boolean isComment(Object obj) {
        return false;
    }

    public boolean isText(Object obj) {
        return false;
    }

    public boolean isAttribute(Object obj) {
        return obj instanceof XPathProperty;
    }

    public boolean isProcessingInstruction(Object obj) {
        return false;
    }

    public boolean isDocument(Object obj) {
        return false;
    }

    public boolean isNamespace(Object obj) {
        return false;
    }

    public String getElementName(Object obj) {
        XPathType elem = (XPathType)obj;
        return elem.getType().getName();
    }

    public String getElementNamespaceUri(Object obj) {
        XPathType elem = (XPathType)obj;
        String uri = elem.getType().getURI();
        if (uri != null && uri.length() == 0) {
            return null;
        }
        return uri;
    }

    public String getAttributeName(Object obj) {
        XPathProperty attr = (XPathProperty)obj;
        return attr.getProperty().getName();
    }

    public String getAttributeNamespaceUri(Object obj) {
        XPathProperty attr = (XPathProperty)obj;
        String uri = attr.getProperty().getType().getURI();
        if (uri != null && uri.length() == 0) {
            return null;
        }
        return uri;
    }

    public Iterator getChildAxisIterator(Object contextNode) {
        throw new IllegalArgumentException("unexpected instance, " + contextNode.getClass().getName());
    }

    public Iterator getChildAxisIterator(Object contextNode, String localName, String namespacePrefix, String namespaceURI) {
        if (contextNode instanceof Type) {
            Type source = (Type)contextNode;
            return this.getChildResult(source, localName);
        }
        if (contextNode instanceof XPathType) {
            XPathType contextAdapter = (XPathType)contextNode;
            Type source = contextAdapter.getType();
            return this.getChildResult(source, localName);
        }
        throw new IllegalArgumentException("unexpected instance, " + contextNode.getClass().getName());
    }

    private Iterator getChildResult(Type source, String localName) {
        Property sourceProp;
        String propertyName = localName;
        int indexPosition = localName.indexOf(".");
        int index = 0;
        if (indexPosition >= 0) {
            propertyName = localName.substring(0, indexPosition);
            try {
                index = Integer.parseInt(localName.substring(indexPosition + 1));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(localName, e);
            }
        }
        if ((sourceProp = ((PlasmaType)source).findProperty(propertyName)) == null) {
            return JaxenConstants.EMPTY_ITERATOR;
        }
        if (!sourceProp.isMany() && indexPosition >= 0) {
            throw new IllegalArgumentException("index specified for singular property, " + source.getURI() + "#" + source.getName() + "." + propertyName);
        }
        if (sourceProp.getType().isDataType()) {
            return new SingleObjectIterator((Object)new XPathProperty(sourceProp, source, sourceProp));
        }
        Type targetType = sourceProp.getType();
        return new SingleObjectIterator((Object)new XPathType(targetType, source, sourceProp));
    }

    public Iterator getNamespaceAxisIterator(Object contextNode) {
        return JaxenConstants.EMPTY_ITERATOR;
    }

    public Iterator getParentAxisIterator(Object contextNode) {
        return JaxenConstants.EMPTY_ITERATOR;
    }

    public Iterator getAttributeAxisIterator(Object contextNode) {
        if (!(contextNode instanceof XPathType)) {
            return JaxenConstants.EMPTY_ITERATOR;
        }
        XPathType elem = (XPathType)contextNode;
        return elem.getType().getProperties().iterator();
    }

    public Iterator getAttributeAxisIterator(Object contextNode, String localName, String namespacePrefix, String namespaceURI) {
        if (contextNode instanceof XPathType) {
            XPathType adapter = (XPathType)contextNode;
            Property prop = adapter.getType().getProperty(localName);
            if (prop.getType().isDataType()) {
                return new SingleObjectIterator((Object)new XPathProperty(prop, adapter.getSource(), adapter.getSourceProperty()));
            }
            Type targetType = prop.getType();
            return new SingleObjectIterator((Object)new XPathType(targetType, adapter.getSource(), prop));
        }
        return JaxenConstants.EMPTY_ITERATOR;
    }

    public XPath parseXPath(String xpath) throws SAXPathException {
        return new MetaDataXPath(xpath);
    }

    public Object getDocumentNode(Object contextNode) {
        XPathType type = null;
        if (contextNode instanceof XPathType) {
            type = (XPathType)contextNode;
        }
        return type;
    }

    public String getElementQName(Object obj) {
        XPathType elem = (XPathType)obj;
        return String.valueOf(elem.getType().getURI()) + "#" + elem.getType().getName();
    }

    public String getAttributeQName(Object obj) {
        XPathProperty adapter = (XPathProperty)obj;
        return adapter.getProperty().getName();
    }

    public String getNamespaceStringValue(Object obj) {
        return obj.toString();
    }

    public String getNamespacePrefix(Object obj) {
        return obj.toString();
    }

    public String getTextStringValue(Object obj) {
        return obj.toString();
    }

    public String getAttributeStringValue(Object obj) {
        XPathProperty adapter = (XPathProperty)obj;
        return adapter.getProperty().getName();
    }

    public String getElementStringValue(Object obj) {
        return obj.toString();
    }

    public String getProcessingInstructionTarget(Object obj) {
        return null;
    }

    public String getProcessingInstructionData(Object obj) {
        return null;
    }

    public String getCommentStringValue(Object obj) {
        return null;
    }

    public String translateNamespacePrefixToUri(String prefix, Object context) {
        XPathType element = null;
        if (context instanceof XPathType) {
            element = (XPathType)context;
            return element.getType().getURI();
        }
        return null;
    }

    public Object getDocument(String url) throws FunctionCallException {
        throw new UnsupportedOperationException();
    }
}

