/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.sdo.xpath;

import commonj.sdo.Type;
import java.util.List;
import org.jaxen.Context;
import org.jaxen.JaxenException;
import org.jaxen.Navigator;
import org.plasma.sdo.xpath.DefaultXPath;
import org.plasma.sdo.xpath.InvalidEndpointException;
import org.plasma.sdo.xpath.InvalidMultiplicityException;
import org.plasma.sdo.xpath.MetaDataNavigator;
import org.plasma.sdo.xpath.MetaDataNodeAdapter;
import org.plasma.sdo.xpath.XPathProperty;

public class MetaDataXPath
extends DefaultXPath {
    private static final long serialVersionUID = 1L;
    private static final XPathProperty[] EMPTY_PROPERTY_ARRAY = new XPathProperty[0];
    private static final MetaDataNodeAdapter[] EMPTY_NODE_ARRAY = new MetaDataNodeAdapter[0];

    public MetaDataXPath(String xpathExpr) throws JaxenException {
        super(xpathExpr, (Navigator)new MetaDataNavigator());
    }

    public MetaDataXPath(String xpathExpr, Navigator navigator) throws JaxenException {
        super(xpathExpr, navigator);
    }

    public Context getNodeContext(Object node) {
        return this.getContext(node);
    }

    public MetaDataNodeAdapter[] getResults(Type root) throws JaxenException, InvalidMultiplicityException {
        List nodes = this.selectNodes(root);
        if (nodes == null || nodes.size() == 0) {
            return EMPTY_NODE_ARRAY;
        }
        MetaDataNodeAdapter[] adapters = new MetaDataNodeAdapter[nodes.size()];
        nodes.toArray(adapters);
        if (adapters.length > 1) {
            MetaDataNodeAdapter[] metaDataNodeAdapterArray = adapters;
            int n = adapters.length;
            int n2 = 0;
            while (n2 < n) {
                MetaDataNodeAdapter adapter = metaDataNodeAdapterArray[n2];
                if (!adapter.getSourceProperty().isMany()) {
                    throw new InvalidMultiplicityException("given XPATH '" + this.toString() + "' resulted in multiple values for singular " + "property, " + adapter.getSource().getURI() + "#" + adapter.getSource().getName() + "." + adapter.getSourceProperty().getName());
                }
                ++n2;
            }
        }
        return adapters;
    }

    public XPathProperty[] findProperties(Type root) throws JaxenException, InvalidEndpointException {
        List nodes = this.selectNodes(root);
        if (nodes == null || nodes.size() == 0) {
            return EMPTY_PROPERTY_ARRAY;
        }
        XPathProperty[] adapters = new XPathProperty[nodes.size()];
        int i = 0;
        while (i < nodes.size()) {
            Object node = nodes.get(i);
            if (!(node instanceof XPathProperty)) {
                throw new InvalidEndpointException("expected Property results for the given XPATH '" + this.toString() + "'");
            }
            adapters[i] = (XPathProperty)node;
            ++i;
        }
        return adapters;
    }

    public XPathProperty getProperty(Type root) throws JaxenException, InvalidEndpointException {
        Object node = this.selectSingleNode(root);
        if (node == null || !(node instanceof XPathProperty)) {
            throw new InvalidEndpointException("expected Property results for the given XPATH '" + this.toString() + "'");
        }
        return (XPathProperty)node;
    }

    public XPathProperty findProperty(Type root) throws JaxenException, InvalidEndpointException {
        Object node = this.selectSingleNode(root);
        if (node == null) {
            return null;
        }
        if (!(node instanceof XPathProperty)) {
            throw new InvalidEndpointException("expected Property results for the given XPATH '" + this.toString() + "'");
        }
        return (XPathProperty)node;
    }
}

