/*
 * Decompiled with CFR 0.152.
 */
package org.plasma.text.ddl;

import commonj.sdo.Property;
import commonj.sdo.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.plasma.config.DataStoreType;
import org.plasma.config.PlasmaConfig;
import org.plasma.sdo.DataType;
import org.plasma.sdo.PlasmaProperty;
import org.plasma.sdo.PlasmaType;
import org.plasma.sdo.helper.PlasmaTypeHelper;
import org.plasma.sdo.profile.KeyType;
import org.plasma.sdo.repository.Class_;
import org.plasma.sdo.repository.Enumeration;
import org.plasma.sdo.repository.EnumerationLiteral;
import org.plasma.sdo.repository.Namespace;
import org.plasma.sdo.repository.OpaqueBehavior;
import org.plasma.sdo.repository.PlasmaRepository;
import org.plasma.text.ddl.Behavior;
import org.plasma.text.ddl.BehaviorType;
import org.plasma.text.ddl.Check;
import org.plasma.text.ddl.Column;
import org.plasma.text.ddl.DDLException;
import org.plasma.text.ddl.Fk;
import org.plasma.text.ddl.Index;
import org.plasma.text.ddl.On;
import org.plasma.text.ddl.Pk;
import org.plasma.text.ddl.Schema;
import org.plasma.text.ddl.Schemas;
import org.plasma.text.ddl.Table;
import org.plasma.text.ddl.Unique;

public class DDLModelAssembler {
    private static Log log = LogFactory.getLog(DDLModelAssembler.class);
    private Schemas schemas;
    private Map<String, Map<String, PlasmaType>> schemaMap = new HashMap<String, Map<String, PlasmaType>>();
    private Map<String, String> reverseSchemaMap = new HashMap<String, String>();

    public DDLModelAssembler() {
        this(PlasmaRepository.getInstance().getAllNamespaces());
    }

    public DDLModelAssembler(String[] namespaces) {
        this(DDLModelAssembler.resultList(namespaces));
    }

    private static List<Namespace> resultList(String[] namespaces) {
        ArrayList<Namespace> result = new ArrayList<Namespace>();
        HashMap<String, String> map = new HashMap<String, String>();
        String[] stringArray = namespaces;
        int n = namespaces.length;
        int n2 = 0;
        while (n2 < n) {
            String uri = stringArray[n2];
            map.put(uri, uri);
            ++n2;
        }
        for (Namespace namespace : PlasmaRepository.getInstance().getAllNamespaces()) {
            if (!map.containsKey(namespace.getUri())) continue;
            result.add(namespace);
        }
        return result;
    }

    public DDLModelAssembler(List<Namespace> namespaces) {
        this.schemas = new Schemas();
        for (Namespace namespace : namespaces) {
            log.debug((Object)("processing namespace: " + namespace.getUri()));
            if (!PlasmaConfig.getInstance().hasNamespace(DataStoreType.RDBMS)) {
                log.debug((Object)("ignoring non " + DataStoreType.RDBMS.name() + " namespace: " + namespace.getUri()));
                continue;
            }
            List<Type> types = PlasmaTypeHelper.INSTANCE.getTypes(namespace.getUri());
            for (Type type : types) {
                PlasmaType plasmaType = (PlasmaType)type;
                String typePhysicalName = null;
                typePhysicalName = plasmaType.getPhysicalName() == null || plasmaType.getPhysicalName().length() == 0 ? this.derivePhysicalName(plasmaType) : plasmaType.getPhysicalName();
                String namespacePhysicalName = null;
                namespacePhysicalName = namespace.getPhysicalName() == null || namespace.getPhysicalName().trim().length() == 0 ? this.derivePhysicalName(namespace) : namespace.getPhysicalName();
                Map<String, PlasmaType> typeMap = this.schemaMap.get(namespacePhysicalName);
                if (typeMap == null) {
                    typeMap = new HashMap<String, PlasmaType>();
                    this.schemaMap.put(namespacePhysicalName, typeMap);
                }
                typeMap.put(typePhysicalName, plasmaType);
                this.reverseSchemaMap.put(typePhysicalName, namespacePhysicalName);
            }
        }
        for (String schemaName : this.schemaMap.keySet()) {
            log.debug((Object)("creating schema: " + schemaName));
            Schema schema = this.createSchema(schemaName);
            Map<String, PlasmaType> typeMap = this.schemaMap.get(schemaName);
            for (PlasmaType type : typeMap.values()) {
                if (type.isAbstract()) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("skipping abstract type, " + type));
                    continue;
                }
                Table table = this.createTable(schema, type);
                schema.getTables().add(table);
                List properties = type.getProperties();
                HashMap<Property, Property> map = new HashMap<Property, Property>();
                for (Property p : properties) {
                    map.put(p, p);
                }
                this.createColumns(schema, table, type, map.values());
                this.createPriKey(table, map.values());
                Class_ repositoryClass = (Class_)type.getClassifier();
                List<OpaqueBehavior> ddlBehaviors = repositoryClass.getOpaqueBehaviors("DDL");
                this.createBehaviors(table, ddlBehaviors);
                List<OpaqueBehavior> sqlBehaviors = repositoryClass.getOpaqueBehaviors("SQL");
                this.createBehaviors(table, sqlBehaviors);
                this.createForeignConstraints(table, type, map.values());
                this.createUniqueConstraints(table, map.values());
                this.createCheckConstraints(table, map.values());
                this.createIndexes(table, map.values());
            }
        }
    }

    private void createIndexes(Table table, Collection<Property> properties) {
        int i = 1;
        for (Property prop : properties) {
            PlasmaProperty plasmaProperty = (PlasmaProperty)prop;
            if (plasmaProperty.getPhysicalName() == null || plasmaProperty.getType().isDataType()) continue;
            Index index = new Index();
            index.setName("I_" + table.getName() + String.valueOf(i));
            index.setColumn(plasmaProperty.getPhysicalName());
            table.getIndices().add(index);
            ++i;
        }
    }

    private void createCheckConstraints(Table table, Collection<Property> properties) {
        int i = 1;
        for (Property prop : properties) {
            PlasmaProperty plasmaProperty = (PlasmaProperty)prop;
            if (plasmaProperty.getPhysicalName() == null || !plasmaProperty.getType().isDataType() || plasmaProperty.getRestriction() == null) continue;
            Check check = new Check();
            check.setName("CK_" + table.getName() + "_" + String.valueOf(i));
            check.setColumn(plasmaProperty.getPhysicalName());
            table.getChecks().add(check);
            Enumeration restriction = plasmaProperty.getRestriction();
            for (EnumerationLiteral lit : restriction.getOwnedLiteral()) {
                check.getValues().add(lit.getPhysicalName());
            }
            ++i;
        }
    }

    private void createUniqueConstraints(Table table, Collection<Property> properties) {
        int uniqueCount = 0;
        for (Property prop : properties) {
            Boolean isUnique;
            PlasmaProperty plasmaProperty = (PlasmaProperty)prop;
            if (plasmaProperty.getPhysicalName() == null || plasmaProperty.getKey() != null && plasmaProperty.getKey().getType().ordinal() == KeyType.primary.ordinal() || (isUnique = (Boolean)plasmaProperty.get(PlasmaProperty.INSTANCE_PROPERTY_BOOLEAN_ISUNIQUE)) == null || !isUnique.booleanValue()) continue;
            ++uniqueCount;
        }
        if (uniqueCount > 0) {
            Unique unique = new Unique();
            unique.setName("UK_" + table.getName());
            table.getUniques().add(unique);
            int i = 1;
            for (Property prop : properties) {
                Boolean isUnique;
                PlasmaProperty plasmaProperty = (PlasmaProperty)prop;
                if (plasmaProperty.getPhysicalName() == null || plasmaProperty.getKey() != null && plasmaProperty.getKey().getType().ordinal() == KeyType.primary.ordinal() || (isUnique = (Boolean)plasmaProperty.get(PlasmaProperty.INSTANCE_PROPERTY_BOOLEAN_ISUNIQUE)) == null || !isUnique.booleanValue()) continue;
                On on = new On();
                on.setColumn(plasmaProperty.getPhysicalName());
                unique.getOns().add(on);
                ++i;
            }
        }
    }

    private void createForeignConstraints(Table table, PlasmaType plasmaType, Collection<Property> properties) {
        int i = 1;
        for (Property prop : properties) {
            String schemaPhysicalname;
            String typePhysicalName;
            PlasmaProperty plasmaProperty = (PlasmaProperty)prop;
            if (plasmaProperty.getType().isDataType() || plasmaProperty.isMany()) continue;
            String physicalName = null;
            if (plasmaProperty.getPhysicalName() == null) {
                log.warn((Object)("no physical name found for singular property, " + plasmaProperty.getContainingType().getURI() + "#" + plasmaProperty.getContainingType().getName() + "." + plasmaProperty.getName() + " - deriving"));
                physicalName = this.derivePhysicalName(plasmaProperty);
            } else {
                physicalName = plasmaProperty.getPhysicalName();
            }
            Fk fk = new Fk();
            fk.setName("FK_" + table.getName() + String.valueOf(i));
            fk.setColumn(physicalName);
            Type oppositeType = plasmaProperty.getType();
            if (!oppositeType.isAbstract()) {
                typePhysicalName = null;
                typePhysicalName = ((PlasmaType)oppositeType).getPhysicalName() != null ? ((PlasmaType)oppositeType).getPhysicalName() : this.derivePhysicalName((PlasmaType)oppositeType);
                schemaPhysicalname = this.reverseSchemaMap.get(typePhysicalName);
                fk.setToTable(typePhysicalName);
                fk.setToSchema(schemaPhysicalname);
            } else {
                typePhysicalName = null;
                typePhysicalName = plasmaType.getPhysicalName() != null ? plasmaType.getPhysicalName() : this.derivePhysicalName(plasmaType);
                schemaPhysicalname = this.reverseSchemaMap.get(typePhysicalName);
                fk.setToTable(typePhysicalName);
                fk.setToSchema(schemaPhysicalname);
            }
            table.getFks().add(fk);
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void createBehaviors(Table table, List<OpaqueBehavior> behaviors) {
        for (OpaqueBehavior behavior : behaviors) {
            block7: {
                type = null;
                try {
                    type = BehaviorType.fromValue((String)behavior.getName().toLowerCase());
                    break block7;
                }
                catch (IllegalArgumentException e) {
                    buf = new StringBuilder();
                    i = 0;
                    ** while (i < BehaviorType.values().length)
                }
lbl-1000:
                // 1 sources

                {
                    if (i > 0) {
                        buf.append(", ");
                    }
                    buf.append(BehaviorType.values()[i].value());
                    ++i;
                    continue;
                }
lbl17:
                // 1 sources

                throw new DDLException("unknown behavior name '" + behavior.getName() + "' - expected one of [" + buf.toString() + "]");
            }
            ddlBehavior = new Behavior();
            ddlBehavior.setType(type);
            ddlBehavior.setValue(behavior.getBody());
            if (!ddlBehavior.getValue().trim().endsWith(":")) {
                if (DDLModelAssembler.log.isDebugEnabled()) {
                    DDLModelAssembler.log.debug((Object)("appending DDL statement terminator for '" + ddlBehavior.getType() + "'"));
                }
                ddlBehavior.setValue(String.valueOf(ddlBehavior.getValue().trim()) + ";");
            }
            table.getBehaviors().add(ddlBehavior);
        }
    }

    private String derivePhysicalName(PlasmaProperty plasmaProperty) {
        String derivedPhysicalName = null;
        if (plasmaProperty.getType().isDataType()) {
            derivedPhysicalName = plasmaProperty.getName().toUpperCase();
        } else {
            Type oppositeType = plasmaProperty.getType();
            derivedPhysicalName = ((PlasmaType)oppositeType).getPhysicalName();
            if (derivedPhysicalName == null) {
                derivedPhysicalName = this.derivePhysicalName((PlasmaType)oppositeType);
            }
        }
        if (derivedPhysicalName == null || derivedPhysicalName.trim().length() == 0) {
            throw new DDLException("could not derive physical name for property, " + plasmaProperty);
        }
        return derivedPhysicalName;
    }

    private String derivePhysicalName(PlasmaType plasmatype) {
        String derivedPhysicalName = plasmatype.getName().toUpperCase();
        return derivedPhysicalName;
    }

    private String derivePhysicalName(Namespace namespace) {
        String derivedPhysicalName = namespace.getName().toUpperCase();
        return derivedPhysicalName;
    }

    private void createColumns(Schema schema, Table table, PlasmaType plasmaType, Collection<Property> properties) {
        for (Property prop : properties) {
            PlasmaProperty plasmaProperty = (PlasmaProperty)prop;
            if (plasmaProperty.isMany()) continue;
            String derivedPhysicalName = null;
            if (plasmaProperty.getPhysicalName() == null) {
                log.warn((Object)("no physical name found for singular property, " + plasmaProperty.getContainingType().getURI() + "#" + plasmaProperty.getContainingType().getName() + "." + plasmaProperty.getName() + " - deriving"));
                derivedPhysicalName = this.derivePhysicalName(plasmaProperty);
            }
            Column column = null;
            column = derivedPhysicalName == null ? this.createColumn(schema, table, plasmaType, plasmaProperty) : this.createColumn(schema, table, plasmaType, plasmaProperty, derivedPhysicalName);
            table.getColumns().add(column);
        }
    }

    private void createPriKey(Table table, Collection<Property> properties) {
        for (Property prop : properties) {
            PlasmaProperty plasmaProperty = (PlasmaProperty)prop;
            if (plasmaProperty.getPhysicalName() == null || !plasmaProperty.isKey(KeyType.primary)) continue;
            Pk pk = table.getPk();
            if (pk == null) {
                pk = this.createPk(table, plasmaProperty);
                table.setPk(pk);
            }
            On on = new On();
            on.setColumn(plasmaProperty.getPhysicalName());
            table.getPk().getOns().add(on);
        }
    }

    private Pk createPk(Table table, PlasmaProperty plasmaProperty) {
        Pk pk = new Pk();
        pk.setName("PK_" + table.getName());
        return pk;
    }

    private Column createColumn(Schema schema, Table table, PlasmaType plasmaType, PlasmaProperty plasmaProperty) {
        return this.createColumn(schema, table, plasmaType, plasmaProperty, null);
    }

    private Column createColumn(Schema schema, Table table, PlasmaType plasmaType, PlasmaProperty plasmaProperty, String derivedPhysicalName) {
        Column column = new Column();
        if (derivedPhysicalName != null) {
            column.setName(derivedPhysicalName);
        } else {
            column.setName(plasmaProperty.getPhysicalName());
        }
        column.setNullable(Boolean.valueOf(plasmaProperty.isNullable()));
        if (plasmaProperty.getMaxLength() > 0L) {
            column.setSize(plasmaProperty.getMaxLength());
        } else {
            column.setSize(-1L);
        }
        if (plasmaProperty.getType().isDataType()) {
            DataType sdoType = DataType.valueOf((String)plasmaProperty.getType().getName());
            column.setType(sdoType.name());
        } else {
            PlasmaProperty oppositePkProp = null;
            if (!plasmaProperty.getType().isAbstract()) {
                for (Property p : plasmaProperty.getType().getProperties()) {
                    PlasmaProperty oppositeProp = (PlasmaProperty)p;
                    if (!oppositeProp.isKey(KeyType.primary)) continue;
                    if (oppositePkProp != null) {
                        throw new DDLException("multiple opposite pri-key propertys found for '" + plasmaProperty.getContainingType().getURI() + "#" + plasmaProperty.getContainingType().getName() + "." + plasmaProperty.getName() + "'");
                    }
                    oppositePkProp = oppositeProp;
                }
            } else {
                oppositePkProp = (PlasmaProperty)plasmaType.findProperty(KeyType.primary);
            }
            if (oppositePkProp == null) {
                throw new DDLException("could not find opposite pri-key property for '" + plasmaProperty.getContainingType().getURI() + "#" + plasmaProperty.getContainingType().getName() + "." + plasmaProperty.getName() + "'");
            }
            DataType sdoType = DataType.valueOf((String)oppositePkProp.getType().getName());
            column.setType(sdoType.name());
        }
        return column;
    }

    private Table createTable(Schema schema, PlasmaType plasmaType) {
        Table table = new Table();
        String typePhysicalName = null;
        typePhysicalName = plasmaType.getPhysicalName() != null ? plasmaType.getPhysicalName() : this.derivePhysicalName(plasmaType);
        log.debug((Object)("creating table: " + typePhysicalName));
        table.setName(typePhysicalName);
        return table;
    }

    private Schema createSchema(String name) {
        Schema schema = new Schema();
        this.schemas.getSchemas().add(schema);
        schema.setName(name);
        return schema;
    }

    public Schemas getSchemas() {
        return this.schemas;
    }
}

