/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.cartridge.html4;

import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testatoo.cartridge.html4.By;
import org.testatoo.cartridge.html4.HtmlEvaluator;

public class ByTest {
    private HtmlEvaluator evaluator;
    private String id = "myId";

    @Before
    public void setUp() {
        this.evaluator = (HtmlEvaluator)Mockito.mock(HtmlEvaluator.class);
    }

    @Test
    public void can_find_component_by_jquery() {
        Mockito.when((Object)this.evaluator.elementsId("jquery:$('div#content .photo')")).thenReturn((Object)new String[]{this.id});
        By by = By.$((String)"$('div#content .photo')");
        by.id(this.evaluator);
        ((HtmlEvaluator)Mockito.verify((Object)this.evaluator, (VerificationMode)Mockito.times((int)1))).elementsId("jquery:$('div#content .photo')");
    }

    @Test
    public void can_find_component_by_jquery_selector() {
        Mockito.when((Object)this.evaluator.elementsId("jquery:$('div#content .photo')")).thenReturn((Object)new String[]{this.id});
        By by = By.$((String)"div#content .photo");
        by.id(this.evaluator);
        ((HtmlEvaluator)Mockito.verify((Object)this.evaluator, (VerificationMode)Mockito.times((int)1))).elementsId("jquery:$('div#content .photo')");
    }

    @Test
    public void can_find_component_by_$_selector() {
        Mockito.when((Object)this.evaluator.elementsId("jquery:$('div#content .photo')")).thenReturn((Object)new String[]{this.id});
        By.$((String)"div#content .photo").id(this.evaluator);
        ((HtmlEvaluator)Mockito.verify((Object)this.evaluator, (VerificationMode)Mockito.times((int)1))).elementsId("jquery:$('div#content .photo')");
    }

    @Test
    public void can_find_components_by_jquery() {
        String[] result = new String[]{"myId_1", "myId_2", "myId_3"};
        Mockito.when((Object)this.evaluator.elementsId("jquery:$('#tableId tr')")).thenReturn((Object)result);
        By by = By.$((String)"$('#tableId tr')");
        by.ids(this.evaluator);
        ((HtmlEvaluator)Mockito.verify((Object)this.evaluator, (VerificationMode)Mockito.times((int)1))).elementsId("jquery:$('#tableId tr')");
    }

    @Test
    public void can_find_components_by_jquery_selector() {
        String[] result = new String[]{"myId_1", "myId_2", "myId_3"};
        Mockito.when((Object)this.evaluator.elementsId("jquery:$('#tableId tr')")).thenReturn((Object)result);
        By by = By.$((String)"#tableId tr");
        by.ids(this.evaluator);
        ((HtmlEvaluator)Mockito.verify((Object)this.evaluator, (VerificationMode)Mockito.times((int)1))).elementsId("jquery:$('#tableId tr')");
    }
}

