/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.cartridge.html4.element;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.testatoo.WebTest;
import org.testatoo.cartridge.html4.By;
import org.testatoo.cartridge.html4.element.Base;
import org.testatoo.core.ComponentException;
import org.testatoo.core.ComponentFactory;
import org.testatoo.core.Language;

public class BaseTest
extends WebTest {
    @BeforeClass
    public static void setUp() {
        ComponentFactory.page().open("Base.html");
    }

    @Test
    public void can_find_base_by_id() {
        ComponentFactory.component(Base.class, (By)By.$((String)"#base"));
        try {
            ComponentFactory.component(Base.class, (By)By.$((String)"#otherBase"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"Cannot find component defined by jQueryExpression=$('#otherBase')"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_html_base() {
        try {
            ComponentFactory.component(Base.class, (By)By.$((String)"#link"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"The component with id=link is not a Base but a A"));
        }
    }

    @Test
    public void test_base_specifics_attributes() {
        Language.assertThat((Object)((Base)ComponentFactory.component(Base.class, (By)By.$((String)"#base"))).href(), (Matcher)Matchers.is((Object)"http://www.google.ca"));
    }

    @Test
    public void testBase_toString() {
        Language.assertThat((Object)((Base)ComponentFactory.component(Base.class, (By)By.$((String)"#base"))).toString(), (Matcher)Matchers.is((Object)"class org.testatoo.cartridge.html4.element.Base with state : enabled:true, visible:false, reference:http://www.google.ca"));
    }
}

