/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.cartridge.html4.element;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.testatoo.WebTest;
import org.testatoo.cartridge.html4.By;
import org.testatoo.cartridge.html4.element.Direction;
import org.testatoo.cartridge.html4.element.FieldSet;
import org.testatoo.core.ComponentException;
import org.testatoo.core.ComponentFactory;
import org.testatoo.core.Language;

public class FieldSetTest
extends WebTest {
    @BeforeClass
    public static void setUp() {
        ComponentFactory.page().open("FieldSet.html");
    }

    @Test
    public void can_find_fieldSet_by_id() {
        ComponentFactory.component(FieldSet.class, (By)By.$((String)"#fieldSet_1"));
        try {
            ComponentFactory.component(FieldSet.class, (By)By.$((String)"#fieldSet_0"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"Cannot find component defined by jQueryExpression=$('#fieldSet_0')"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_html_fieldSet() {
        try {
            ComponentFactory.component(FieldSet.class, (By)By.$((String)"#radio"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"The component with id=radio is not a FieldSet but a Radio"));
        }
    }

    @Test
    public void test_fieldSet_i18nAttributes() {
        FieldSet fieldSet_1 = (FieldSet)ComponentFactory.component(FieldSet.class, (By)By.$((String)"#fieldSet_1"));
        Language.assertThat((Object)fieldSet_1.direction(), (Matcher)Matchers.is((Object)Direction.lefttoright));
        Language.assertThat((Object)fieldSet_1.language(), (Matcher)Matchers.is((Object)"fr"));
    }

    @Test
    public void test_fieldSet_coreAttributes() {
        FieldSet fieldSet_1 = (FieldSet)ComponentFactory.component(FieldSet.class, (By)By.$((String)"#fieldSet_1"));
        Language.assertThat((Object)fieldSet_1.id(), (Matcher)Matchers.is((Object)"fieldSet_1"));
        Language.assertThat((Object)fieldSet_1.classname(), (Matcher)Matchers.is((Object)"MyFIELDSETClass"));
        Language.assertThat((Object)fieldSet_1.style(), (Matcher)Matchers.containsString((String)"color:black"));
        Language.assertThat((Object)fieldSet_1.title(), (Matcher)Matchers.is((Object)"fieldSetTitle"));
    }

    @Test
    public void test_toString() {
        FieldSet fieldSet = (FieldSet)ComponentFactory.component(FieldSet.class, (By)By.$((String)"#fieldSet_1"));
        Language.assertThat((Object)fieldSet.toString(), (Matcher)Matchers.is((Object)"class org.testatoo.cartridge.html4.element.FieldSet with state : enabled:true, visible:true"));
    }
}

