/*
 * Decompiled with CFR 0.152.
 */
package org.testatoo.cartridge.html4.element;

import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.testatoo.WebTest;
import org.testatoo.cartridge.html4.By;
import org.testatoo.cartridge.html4.element.Area;
import org.testatoo.cartridge.html4.element.Direction;
import org.testatoo.cartridge.html4.element.Img;
import org.testatoo.cartridge.html4.element.Map;
import org.testatoo.cartridge.html4.element.Shape;
import org.testatoo.core.ComponentException;
import org.testatoo.core.ComponentFactory;
import org.testatoo.core.Language;
import org.testatoo.core.matcher.Matchers;

public class ImgTest
extends WebTest {
    @BeforeClass
    public static void setUp() {
        ComponentFactory.page().open("Img.html");
    }

    @Test
    public void can_find_image_by_id() {
        ComponentFactory.component(Img.class, (By)By.$((String)"#image_1"));
        try {
            ComponentFactory.component(Img.class, (By)By.$((String)"#image_0"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)org.hamcrest.Matchers.is((Object)"Cannot find component defined by jQueryExpression=$('#image_0')"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_html_image() {
        try {
            ComponentFactory.component(Img.class, (By)By.$((String)"#div_1"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)org.hamcrest.Matchers.is((Object)"The component with id=div_1 is not a Image but a Panel"));
        }
    }

    @Test
    public void can_find_image_source() {
        Language.assertThat((Object)((Img)ComponentFactory.component(Img.class, (By)By.$((String)"#image_1"))).source(), (Matcher)org.hamcrest.Matchers.is((Object)"images/Montpellier.jpg"));
    }

    @Test
    public void test_image_i18nAttributes() {
        Img image_1 = (Img)ComponentFactory.component(Img.class, (By)By.$((String)"#image_1"));
        Language.assertThat((Object)image_1.direction(), (Matcher)org.hamcrest.Matchers.is((Object)Direction.lefttoright));
        Language.assertThat((Object)image_1.language(), (Matcher)org.hamcrest.Matchers.is((Object)"fr"));
    }

    @Test
    public void test_image_coreAttributes() {
        Img image_1 = (Img)ComponentFactory.component(Img.class, (By)By.$((String)"#image_1"));
        Language.assertThat((Object)image_1.id(), (Matcher)org.hamcrest.Matchers.is((Object)"image_1"));
        Language.assertThat((Object)image_1.classname(), (Matcher)org.hamcrest.Matchers.is((Object)"MyIMAGEClass"));
        Language.assertThat((Object)image_1.style(), (Matcher)org.hamcrest.Matchers.containsString((String)"color:black"));
        Language.assertThat((Object)image_1.title(), (Matcher)org.hamcrest.Matchers.is((Object)"imageTitle"));
    }

    @Test
    public void test_image_specifics_attributes() {
        Img image_1 = (Img)ComponentFactory.component(Img.class, (By)By.$((String)"#image_1"));
        Img image_2 = (Img)ComponentFactory.component(Img.class, (By)By.$((String)"#image_2"));
        Language.assertThat((Object)image_1.name(), (Matcher)org.hamcrest.Matchers.is((Object)"imageName"));
        Language.assertThat((Object)image_1.alt(), (Matcher)org.hamcrest.Matchers.is((Object)"Montpellier tramway"));
        Language.assertThat((Object)image_1.longdesc(), (Matcher)org.hamcrest.Matchers.is((Object)"Montpellier first line tramway"));
        Language.assertThat((Object)image_1.usemap(), (Matcher)org.hamcrest.Matchers.is((Object)"http://mySite/images"));
        Language.assertThat((Object)image_2.usemap(), (Matcher)org.hamcrest.Matchers.is((Object)"#map_2"));
    }

    @Test
    public void test_image_toString() {
        Language.assertThat((Object)((Img)ComponentFactory.component(Img.class, (By)By.$((String)"#image_1"))).toString(), (Matcher)org.hamcrest.Matchers.is((Object)"class org.testatoo.cartridge.html4.element.Img with state : enabled:true, visible:true, source:images/Montpellier.jpg"));
    }

    @Test
    public void can_find_map_by_id() {
        ComponentFactory.component(Map.class, (By)By.$((String)"#map_2"));
        try {
            ComponentFactory.component(Map.class, (By)By.$((String)"#map_0"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)org.hamcrest.Matchers.is((Object)"Cannot find component defined by jQueryExpression=$('#map_0')"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_html_map() {
        try {
            ComponentFactory.component(Map.class, (By)By.$((String)"#div_1"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)org.hamcrest.Matchers.is((Object)"The component with id=div_1 is not a Map but a Div"));
        }
        try {
            ComponentFactory.component(Map.class, (By)By.$((String)"#image_1"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)org.hamcrest.Matchers.is((Object)"The component with id=image_1 is not a Map but a Img"));
        }
    }

    @Test
    public void test_map_i18nAttributes() {
        Map map_2 = (Map)ComponentFactory.component(Map.class, (By)By.$((String)"#map_2"));
        Language.assertThat((Object)map_2.direction(), (Matcher)org.hamcrest.Matchers.is((Object)Direction.righttoleft));
        Language.assertThat((Object)map_2.language(), (Matcher)org.hamcrest.Matchers.is((Object)"en"));
    }

    @Test
    public void test_map_coreAttributes() {
        Map map_2 = (Map)ComponentFactory.component(Map.class, (By)By.$((String)"#map_2"));
        Language.assertThat((Object)map_2.id(), (Matcher)org.hamcrest.Matchers.is((Object)"map_2"));
        Language.assertThat((Object)map_2.classname(), (Matcher)org.hamcrest.Matchers.is((Object)"MyMAPClass"));
        Language.assertThat((Object)map_2.style(), (Matcher)org.hamcrest.Matchers.containsString((String)"color:blue"));
        Language.assertThat((Object)map_2.title(), (Matcher)org.hamcrest.Matchers.is((Object)"map_title2"));
    }

    @Test
    public void test_map_specifics_attributes() {
        Map map_2 = (Map)ComponentFactory.component(Map.class, (By)By.$((String)"#map_2"));
        Language.assertThat((Object)map_2.name(), (Matcher)org.hamcrest.Matchers.is((Object)"map_2"));
    }

    @Test
    public void can_obtain_area() {
        Map map_2 = (Map)ComponentFactory.component(Map.class, (By)By.$((String)"#map_2"));
        Language.assertThat((Object)map_2.areas(), (Matcher)Matchers.has((Matcher)Matchers.size((int)4)));
        Language.assertThat((Object)((Area)map_2.areas().get(0)).coords(), (Matcher)org.hamcrest.Matchers.is((Object)"40,144,80,171"));
        Language.assertThat((Object)((Area)map_2.areas().get(1)).coords(), (Matcher)org.hamcrest.Matchers.is((Object)"112,144,152,171"));
        Language.assertThat((Object)((Area)map_2.areas().get(2)).coords(), (Matcher)org.hamcrest.Matchers.is((Object)"184,144,224,171"));
        Language.assertThat((Object)((Area)map_2.areas().get(3)).coords(), (Matcher)org.hamcrest.Matchers.is((Object)"256,144,296,171"));
    }

    @Test
    public void test_map_toString() {
        Language.assertThat((Object)((Map)ComponentFactory.component(Map.class, (By)By.$((String)"#map_2"))).toString(), (Matcher)org.hamcrest.Matchers.is((Object)"class org.testatoo.cartridge.html4.element.Map with state : enabled:true, visible:false, title:map_title2"));
    }

    @Test
    public void can_find_area_by_id() {
        ComponentFactory.component(Area.class, (By)By.$((String)"#area_1"));
        try {
            ComponentFactory.component(Area.class, (By)By.$((String)"#area_0"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)org.hamcrest.Matchers.is((Object)"Cannot find component defined by jQueryExpression=$('#area_0')"));
        }
    }

    @Test
    public void exception_thrown_if_component_not_a_html_area() {
        try {
            ComponentFactory.component(Area.class, (By)By.$((String)"#div_1"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)org.hamcrest.Matchers.is((Object)"The component with id=div_1 is not a Area but a Div"));
        }
        try {
            ComponentFactory.component(Area.class, (By)By.$((String)"#image_1"));
            Assert.fail();
        }
        catch (ComponentException e) {
            Language.assertThat((Object)e.getMessage(), (Matcher)org.hamcrest.Matchers.is((Object)"The component with id=image_1 is not a Area but a Img"));
        }
    }

    @Test
    public void test_area_i18nAttributes() {
        Area area_1 = (Area)ComponentFactory.component(Area.class, (By)By.$((String)"#area_1"));
        Language.assertThat((Object)area_1.direction(), (Matcher)org.hamcrest.Matchers.is((Object)Direction.righttoleft));
        Language.assertThat((Object)area_1.language(), (Matcher)org.hamcrest.Matchers.is((Object)"dr"));
    }

    @Test
    public void test_area_coreAttributes() {
        Area area_1 = (Area)ComponentFactory.component(Area.class, (By)By.$((String)"#area_1"));
        Language.assertThat((Object)area_1.id(), (Matcher)org.hamcrest.Matchers.is((Object)"area_1"));
        Language.assertThat((Object)area_1.classname(), (Matcher)org.hamcrest.Matchers.is((Object)"MyAREAClass"));
        Language.assertThat((Object)area_1.style(), (Matcher)org.hamcrest.Matchers.containsString((String)"color:red"));
        Language.assertThat((Object)area_1.title(), (Matcher)org.hamcrest.Matchers.is((Object)"area_title1"));
    }

    @Test
    public void test_area_specifics_attributes() {
        Area area_1 = (Area)ComponentFactory.component(Area.class, (By)By.$((String)"#area_1"));
        Area area_2 = (Area)ComponentFactory.component(Area.class, (By)By.$((String)"#area_2"));
        Language.assertThat((Object)area_1.shape(), (Matcher)org.hamcrest.Matchers.is((Object)Shape.rect));
        Language.assertThat((Object)area_1.accesskey(), (Matcher)org.hamcrest.Matchers.is((Object)"C"));
        Language.assertThat((Object)area_1.alt(), (Matcher)org.hamcrest.Matchers.is((Object)"area1"));
        Language.assertThat((Object)area_1.coords(), (Matcher)org.hamcrest.Matchers.is((Object)"40,144,80,171"));
        Language.assertThat((Object)area_2.href(), (Matcher)org.hamcrest.Matchers.is((Object)"Exit.html"));
        Language.assertThat((Object)area_2.tabindex(), (Matcher)org.hamcrest.Matchers.is((Object)2));
    }

    @Test
    public void test_visibility() {
        Area area = (Area)ComponentFactory.component(Area.class, (By)By.$((String)"#area_1"));
        Language.assertThat((Object)area.isVisible(), (Matcher)org.hamcrest.Matchers.is((Object)false));
    }

    @Test
    public void test_area_toString() {
        Language.assertThat((Object)((Area)ComponentFactory.component(Area.class, (By)By.$((String)"#area_1"))).toString(), (Matcher)org.hamcrest.Matchers.is((Object)"class org.testatoo.cartridge.html4.element.Area with state : enabled:true, visible:false, title:area_title1, href:Exit.html"));
    }
}

